/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.dsl.naming.TableNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.ToStringBuilder;
import org.codefilarete.stalactite.engine.configurer.builder.PrimaryKeyStep;
import org.codefilarete.stalactite.engine.configurer.builder.TableMappingStep;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.function.Sequence;
import org.junit.jupiter.api.Test;

class PrimaryKeyStepTest {
    PrimaryKeyStepTest() {
    }

    @Test
    void alreadyAssignedPolicy() {
        PrimaryKeyStep testInstance = new PrimaryKeyStep();
        EntityMappingConfiguration identifyingConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(o -> {}, o -> true)).withColumnNaming(accessorDefinition -> "myId").getConfiguration();
        Table mainTable = new Table("AbstractVehicle");
        testInstance.addIdentifyingPrimarykey((AbstractIdentification)AbstractIdentification.forSingleKey((EntityMappingConfiguration)identifyingConfiguration), new TableMappingStep().mapEntityConfigurationToTable(identifyingConfiguration, mainTable, TableNamingStrategy.DEFAULT), new ColumnBinderRegistry(), identifyingConfiguration.getColumnNamingStrategy(), identifyingConfiguration.getIndexNamingStrategy());
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mainTable.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{mainTable.getColumn("myId")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isAutoGenerated()).isFalse();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isNullable()).isFalse();
    }

    @Test
    void beforeInsertPolicy() {
        PrimaryKeyStep testInstance = new PrimaryKeyStep();
        EntityMappingConfiguration identifyingConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, (IdentifierPolicy)IdentifierPolicy.pooledHiLoSequence((Sequence)new Sequence<Identifier<Long>>(){
            private long identifier = 0L;

            public Identifier<Long> next() {
                return new PersistableIdentifier<Long>(this.identifier++);
            }
        })).withColumnNaming(accessorDefinition -> "myId").getConfiguration();
        Table mainTable = new Table("AbstractVehicle");
        testInstance.addIdentifyingPrimarykey((AbstractIdentification)AbstractIdentification.forSingleKey((EntityMappingConfiguration)identifyingConfiguration), new TableMappingStep().mapEntityConfigurationToTable(identifyingConfiguration, mainTable, TableNamingStrategy.DEFAULT), new ColumnBinderRegistry(), identifyingConfiguration.getColumnNamingStrategy(), identifyingConfiguration.getIndexNamingStrategy());
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mainTable.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{mainTable.getColumn("myId")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isAutoGenerated()).isFalse();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isNullable()).isFalse();
    }

    @Test
    void afterInsertPolicy() {
        PrimaryKeyStep testInstance = new PrimaryKeyStep();
        EntityMappingConfiguration identifyingConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).withColumnNaming(accessorDefinition -> "myId").getConfiguration();
        Table mainTable = new Table("AbstractVehicle");
        testInstance.addIdentifyingPrimarykey((AbstractIdentification)AbstractIdentification.forSingleKey((EntityMappingConfiguration)identifyingConfiguration), new TableMappingStep().mapEntityConfigurationToTable(identifyingConfiguration, mainTable, TableNamingStrategy.DEFAULT), new ColumnBinderRegistry(), identifyingConfiguration.getColumnNamingStrategy(), identifyingConfiguration.getIndexNamingStrategy());
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mainTable.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{mainTable.getColumn("myId")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isAutoGenerated()).isTrue();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isNullable()).isFalse();
    }
}

