/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manyToOne;

import java.util.Collection;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.TableNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.AbstractRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.EntityMappingConfigurationWithTable;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneCycleConfigurer;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneOwnedBySourceConfigurer;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;

public class ManyToOneRelationConfigurer<C, I, TRGT, TRGTID>
extends AbstractRelationConfigurer<C, I, TRGT, TRGTID> {
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;

    public ManyToOneRelationConfigurer(Dialect dialect, ConnectionConfiguration connectionConfiguration, ConfiguredRelationalPersister<C, I> sourcePersister, TableNamingStrategy tableNamingStrategy, JoinColumnNamingStrategy joinColumnNamingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy, PersisterBuilderContext currentBuilderContext) {
        super(dialect, connectionConfiguration, sourcePersister, tableNamingStrategy, currentBuilderContext);
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
    }

    public void configure(ManyToOneRelation<C, TRGT, TRGTID, Collection<C>> manyToOneRelation) {
        ManyToOneOwnedBySourceConfigurer configurer = new ManyToOneOwnedBySourceConfigurer(this.sourcePersister, manyToOneRelation, this.joinColumnNamingStrategy, this.foreignKeyNamingStrategy);
        String relationName = AccessorDefinition.giveDefinition(manyToOneRelation.getTargetProvider()).getName();
        EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration = manyToOneRelation.getTargetMappingConfiguration();
        if (this.currentBuilderContext.isCycling(targetMappingConfiguration)) {
            Class targetEntityType = targetMappingConfiguration.getEntityType();
            ManyToOneCycleConfigurer cycleSolver = (ManyToOneCycleConfigurer)Iterables.find(this.currentBuilderContext.getBuildLifeCycleListeners(), p -> p instanceof ManyToOneCycleConfigurer && ((ManyToOneCycleConfigurer)p).getEntityType() == targetEntityType);
            if (cycleSolver == null) {
                cycleSolver = new ManyToOneCycleConfigurer(targetEntityType, manyToOneRelation);
                this.currentBuilderContext.addBuildLifeCycleListener(cycleSolver);
            }
            cycleSolver.addCycleSolver(relationName, configurer);
        } else {
            Table targetTable = this.determineTargetTable(manyToOneRelation);
            ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = this.persisterBuilder.build(new EntityMappingConfigurationWithTable<TRGT, TRGTID>(targetMappingConfiguration, targetTable));
            String tableAlias = relationName.replace('.', '_');
            configurer.configure(tableAlias, targetPersister, manyToOneRelation);
        }
    }

    private Table determineTargetTable(ManyToOneRelation<C, TRGT, TRGTID, Collection<C>> manyToOneRelation) {
        EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration = manyToOneRelation.getTargetMappingConfiguration();
        Table targetTable = targetMappingConfiguration.getTable();
        if (targetTable == null) {
            targetTable = this.lookupTableInRegisteredPersisters(targetMappingConfiguration.getEntityType());
        }
        return targetTable;
    }
}

