/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manytomany;

import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.tool.Reflections;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class ManyToManyRelation<SRC, TRGT, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>> {
    private final ReversibleAccessor<SRC, C1> collectionAccessor;
    private final BooleanSupplier sourceTablePerClassPolymorphic;
    private final EntityMappingConfigurationProvider<TRGT, TRGTID> targetMappingConfiguration;
    private CascadeOptions.RelationMode relationMode = CascadeOptions.RelationMode.ALL;
    private Supplier<C1> collectionFactory;
    private final MappedByConfiguration<SRC, TRGT, C2> mappedByConfiguration;
    private boolean fetchSeparately;
    private boolean ordered = false;
    private String indexingColumnName;

    public ManyToManyRelation(ReversibleAccessor<SRC, C1> collectionAccessor, BooleanSupplier sourceTablePerClassPolymorphic, EntityMappingConfigurationProvider<? super TRGT, TRGTID> targetMappingConfiguration) {
        this.collectionAccessor = collectionAccessor;
        this.sourceTablePerClassPolymorphic = sourceTablePerClassPolymorphic;
        this.targetMappingConfiguration = targetMappingConfiguration;
        this.mappedByConfiguration = new MappedByConfiguration();
    }

    public ManyToManyRelation(ReversibleAccessor<SRC, C1> collectionAccessor, BooleanSupplier sourceTablePerClassPolymorphic, EntityMappingConfigurationProvider<? super TRGT, TRGTID> targetMappingConfiguration, MappedByConfiguration<?, TRGT, ?> mappedByConfiguration) {
        this.collectionAccessor = collectionAccessor;
        this.sourceTablePerClassPolymorphic = sourceTablePerClassPolymorphic;
        this.targetMappingConfiguration = targetMappingConfiguration;
        this.mappedByConfiguration = mappedByConfiguration;
    }

    public ReversibleAccessor<SRC, C1> getCollectionAccessor() {
        return this.collectionAccessor;
    }

    public boolean isSourceTablePerClassPolymorphic() {
        return this.sourceTablePerClassPolymorphic.getAsBoolean();
    }

    public EntityMappingConfiguration<TRGT, TRGTID> getTargetMappingConfiguration() {
        return this.targetMappingConfiguration.getConfiguration();
    }

    public boolean isTargetTablePerClassPolymorphic() {
        return this.getTargetMappingConfiguration().getPolymorphismPolicy() instanceof PolymorphismPolicy.TablePerClassPolymorphism;
    }

    public CascadeOptions.RelationMode getRelationMode() {
        return this.relationMode;
    }

    public void setRelationMode(CascadeOptions.RelationMode relationMode) {
        this.relationMode = relationMode;
    }

    @Nullable
    public Supplier<C1> getCollectionFactory() {
        return this.collectionFactory;
    }

    public void setCollectionFactory(Supplier<C1> collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    public MappedByConfiguration<SRC, TRGT, C2> getMappedByConfiguration() {
        return this.mappedByConfiguration;
    }

    public void setIndexingColumnName(String columnName) {
        this.ordered();
        this.indexingColumnName = columnName;
    }

    @Nullable
    public String getIndexingColumnName() {
        return this.indexingColumnName;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void ordered() {
        this.ordered = true;
    }

    public boolean isFetchSeparately() {
        return this.fetchSeparately;
    }

    public void setFetchSeparately(boolean fetchSeparately) {
        this.fetchSeparately = fetchSeparately;
    }

    public void fetchSeparately() {
        this.setFetchSeparately(true);
    }

    public <E, S extends Collection<E>> ManyToManyRelation<E, TRGT, TRGTID, C1, S> embedInto(final Accessor<E, SRC> accessor, final Class<SRC> embeddedType) {
        AccessorChain shiftedTargetProvider = new AccessorChain(new Accessor[]{accessor, this.collectionAccessor});
        shiftedTargetProvider.setNullValueHandler((AccessorChain.NullValueHandler)new AccessorChain.ValueInitializerOnNullValue(){

            protected <T> T newInstance(Accessor<?, T> segmentAccessor, Class<T> valueType) {
                if (segmentAccessor == accessor) {
                    return (T)Reflections.newInstance((Class)embeddedType);
                }
                if (segmentAccessor == ManyToManyRelation.this.collectionAccessor) {
                    if (ManyToManyRelation.this.collectionFactory != null) {
                        return ManyToManyRelation.this.collectionFactory.get();
                    }
                    return (T)super.newInstance(segmentAccessor, valueType);
                }
                return (T)super.newInstance(segmentAccessor, valueType);
            }
        });
        ShiftedMappedByConfiguration<E, SRC, TRGT, C2> shiftedMappedByConfiguration = this.mappedByConfiguration.embedInto(accessor);
        ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> result = new ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2>(shiftedTargetProvider, this::isSourceTablePerClassPolymorphic, this.targetMappingConfiguration, shiftedMappedByConfiguration);
        result.setRelationMode(this.getRelationMode());
        result.setFetchSeparately(this.isFetchSeparately());
        result.setIndexingColumnName(this.getIndexingColumnName());
        result.setOrdered(this.isOrdered());
        result.setCollectionFactory(this.getCollectionFactory());
        return result;
    }

    public static class ShiftedMappedByConfiguration<C, SRC, TRGT, C2 extends Collection<SRC>>
    extends MappedByConfiguration<SRC, TRGT, C2> {
        private final Accessor<C, SRC> shifter;

        private ShiftedMappedByConfiguration(Accessor<C, SRC> shifter, MappedByConfiguration<SRC, TRGT, C2> mappedByConfiguration) {
            this.setReverseCombiner(mappedByConfiguration.getReverseCombiner());
            this.setReverseCollectionAccessor(mappedByConfiguration.getReverseCollectionAccessor());
            this.setReverseCollectionMutator(mappedByConfiguration.getReverseCollectionMutator());
            this.setReverseCollectionFactory(mappedByConfiguration.getReverseCollectionFactory());
            this.shifter = shifter;
        }

        public Accessor<C, SRC> getShifter() {
            return this.shifter;
        }
    }

    public static class MappedByConfiguration<SRC, TRGT, C2 extends Collection<SRC>> {
        @Nullable
        private SerializableBiConsumer<TRGT, SRC> reverseCombiner;
        @Nullable
        private SerializableFunction<TRGT, C2> reverseCollectionAccessor;
        @Nullable
        private SerializableBiConsumer<TRGT, C2> reverseCollectionMutator;
        @Nullable
        private Supplier<C2> reverseCollectionFactory;

        @Nullable
        public SerializableBiConsumer<TRGT, SRC> getReverseCombiner() {
            return this.reverseCombiner;
        }

        public void setReverseCombiner(@Nullable SerializableBiConsumer<TRGT, SRC> reverseCombiner) {
            this.reverseCombiner = reverseCombiner;
        }

        @Nullable
        public SerializableFunction<TRGT, C2> getReverseCollectionAccessor() {
            return this.reverseCollectionAccessor;
        }

        public void setReverseCollectionAccessor(@Nullable SerializableFunction<TRGT, C2> reverseCollectionAccessor) {
            this.reverseCollectionAccessor = reverseCollectionAccessor;
        }

        @Nullable
        public SerializableBiConsumer<TRGT, C2> getReverseCollectionMutator() {
            return this.reverseCollectionMutator;
        }

        public void setReverseCollectionMutator(@Nullable SerializableBiConsumer<TRGT, C2> reverseCollectionMutator) {
            this.reverseCollectionMutator = reverseCollectionMutator;
        }

        @Nullable
        public Supplier<C2> getReverseCollectionFactory() {
            return this.reverseCollectionFactory;
        }

        public void setReverseCollectionFactory(@Nullable Supplier<C2> reverseCollectionFactory) {
            this.reverseCollectionFactory = reverseCollectionFactory;
        }

        public boolean isEmpty() {
            return this.reverseCollectionAccessor == null && this.reverseCollectionMutator == null && this.reverseCollectionFactory == null && this.reverseCombiner == null;
        }

        <C> ShiftedMappedByConfiguration<C, SRC, TRGT, C2> embedInto(Accessor<C, SRC> accessor) {
            return new ShiftedMappedByConfiguration(accessor, this);
        }
    }
}

