/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetoone;

import javax.annotation.Nullable;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class OneToOneRelation<SRC, TRGT, TRGTID> {
    private final ReversibleAccessor<SRC, TRGT> targetProvider;
    private final EntityMappingConfigurationProvider<TRGT, TRGTID> targetMappingConfiguration;
    @Nullable
    private final Table targetTable;
    private boolean nullable = true;
    @Nullable
    private SerializableFunction<TRGT, SRC> reverseGetter;
    @Nullable
    private SerializableBiConsumer<TRGT, SRC> reverseSetter;
    @Nullable
    private Column<Table, SRC> reverseColumn;
    private CascadeOptions.RelationMode relationMode = CascadeOptions.RelationMode.ALL;
    private boolean fetchSeparately;

    public <T extends Table> OneToOneRelation(ReversibleAccessor<SRC, TRGT> targetProvider, EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration, T table) {
        this(targetProvider, () -> targetMappingConfiguration, table);
    }

    public <T extends Table> OneToOneRelation(ReversibleAccessor<SRC, TRGT> targetProvider, EntityMappingConfigurationProvider<TRGT, TRGTID> targetMappingConfiguration, T table) {
        this.targetMappingConfiguration = targetMappingConfiguration;
        this.targetProvider = targetProvider;
        this.targetTable = table;
    }

    public ReversibleAccessor<SRC, TRGT> getTargetProvider() {
        return this.targetProvider;
    }

    public EntityMappingConfiguration<TRGT, TRGTID> getTargetMappingConfiguration() {
        return this.targetMappingConfiguration.getConfiguration();
    }

    @Nullable
    public Table getTargetTable() {
        return this.targetTable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Nullable
    public SerializableFunction<TRGT, SRC> getReverseGetter() {
        return this.reverseGetter;
    }

    public void setReverseGetter(@Nullable SerializableFunction<TRGT, SRC> reverseGetter) {
        this.reverseGetter = reverseGetter;
    }

    @Nullable
    public SerializableBiConsumer<TRGT, SRC> getReverseSetter() {
        return this.reverseSetter;
    }

    public void setReverseSetter(@Nullable SerializableBiConsumer<TRGT, SRC> reverseSetter) {
        this.reverseSetter = reverseSetter;
    }

    @Nullable
    public <T extends Table, O> Column<T, O> getReverseColumn() {
        return this.reverseColumn;
    }

    public void setReverseColumn(Column reverseSide) {
        this.reverseColumn = reverseSide;
    }

    public CascadeOptions.RelationMode getRelationMode() {
        return this.relationMode;
    }

    public void setRelationMode(CascadeOptions.RelationMode relationMode) {
        this.relationMode = relationMode;
    }

    public boolean isRelationOwnedByTarget() {
        return this.getReverseSetter() != null || this.getReverseGetter() != null || this.getReverseColumn() != null;
    }

    public boolean isFetchSeparately() {
        return this.fetchSeparately;
    }

    public void setFetchSeparately(boolean fetchSeparately) {
        this.fetchSeparately = fetchSeparately;
    }

    public void fetchSeparately() {
        this.setFetchSeparately(true);
    }
}

