/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.SimpleIdentifierAssembler;
import org.codefilarete.stalactite.query.HashedMap;
import org.codefilarete.stalactite.query.LogicalOperator;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.PairIterator;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class EntityCriteriaSupport<C>
implements RelationalEntityCriteria<C> {
    private final Criteria criteria = new Criteria();
    private final EntityGraphNode<C> rootConfiguration;

    public EntityCriteriaSupport(EntityMapping<C, ?, ?> entityMapping) {
        this.rootConfiguration = new EntityGraphNode<C>(entityMapping);
    }

    public EntityCriteriaSupport(EntityCriteriaSupport<C> source) {
        this.rootConfiguration = source.rootConfiguration;
    }

    public EntityGraphNode<C> getRootConfiguration() {
        return this.rootConfiguration;
    }

    public void registerRelation(ValueAccessPoint<C> relation, RelationalEntityPersister<?, ?> persister) {
        this.rootConfiguration.registerRelation(relation, persister);
    }

    private <O> EntityCriteriaSupport<C> add(LogicalOperator logicalOperator, SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(logicalOperator, this.rootConfiguration.getColumn(Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)})), operator);
    }

    private <O> EntityCriteriaSupport<C> add(LogicalOperator logicalOperator, SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.add(logicalOperator, this.rootConfiguration.getColumn(Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)})), operator);
    }

    private <O> EntityCriteriaSupport<C> add(LogicalOperator logicalOperator, Column column, ConditionalOperator<O, ?> operator) {
        if (logicalOperator == LogicalOperator.OR) {
            this.criteria.or(column, operator);
        } else {
            this.criteria.and(column, operator);
        }
        return this;
    }

    @Override
    public <O> EntityCriteriaSupport<C> and(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, getter, operator);
    }

    @Override
    public <O> EntityCriteriaSupport<C> and(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, setter, operator);
    }

    @Override
    public <O> EntityCriteriaSupport<C> or(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, getter, operator);
    }

    @Override
    public <O> EntityCriteriaSupport<C> or(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, setter, operator);
    }

    @Override
    public <A, B> EntityCriteriaSupport<C> and(SerializableFunction<C, A> getter1, SerializableFunction<A, B> getter2, ConditionalOperator<B, ?> operator) {
        this.criteria.and(this.rootConfiguration.getColumn(AccessorChain.chain(getter1, getter2).getAccessors()), operator);
        return this;
    }

    @Override
    public <O> RelationalEntityCriteria<C> and(AccessorChain<C, O> getter, ConditionalOperator<O, ?> operator) {
        this.criteria.and(this.rootConfiguration.getColumn(getter.getAccessors()), operator);
        return this;
    }

    @Override
    public <S extends Collection<A>, A, B> EntityCriteriaSupport<C> andMany(SerializableFunction<C, S> getter1, SerializableFunction<A, B> getter2, ConditionalOperator<B, ?> operator) {
        this.criteria.and(this.rootConfiguration.getColumn(Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter1), new AccessorByMethodReference(getter2)})), operator);
        return this;
    }

    public CriteriaChain getCriteria() {
        return this.criteria;
    }

    public static class EntityGraphNode<C> {
        private final Map<List<? extends ValueAccessPoint<?>>, Column> propertyToColumn = new HashedMap<List<? extends ValueAccessPoint<?>>, Column>(){

            @Override
            protected int hash(Object key) {
                List accessors = (List)key;
                int result = 1;
                for (ValueAccessPoint accessor : accessors) {
                    AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)accessor);
                    result = 31 * result + 31 * accessorDefinition.getDeclaringClass().hashCode() + accessorDefinition.getName().hashCode();
                }
                return result;
            }

            @Override
            protected boolean isEqualKey(Object key1, Object key2) {
                List accessors1 = (List)key1;
                List accessors2 = (List)key2;
                List accessorDefintiions1 = accessors1.stream().map(AccessorDefinition::giveDefinition).collect(Collectors.toList());
                List accessorDefintiions2 = accessors2.stream().map(AccessorDefinition::giveDefinition).collect(Collectors.toList());
                PairIterator pairIterator = new PairIterator(accessorDefintiions1, accessorDefintiions2);
                boolean result = false;
                while (!result && pairIterator.hasNext()) {
                    Duo accessorsPair = pairIterator.next();
                    result = ((AccessorDefinition)accessorsPair.getLeft()).getDeclaringClass().equals(((AccessorDefinition)accessorsPair.getRight()).getDeclaringClass()) && ((AccessorDefinition)accessorsPair.getLeft()).getName().equals(((AccessorDefinition)accessorsPair.getRight()).getName()) && ((AccessorDefinition)accessorsPair.getLeft()).getMemberType().equals(((AccessorDefinition)accessorsPair.getRight()).getMemberType());
                }
                return result;
            }
        };
        private final Class<?> entityClass;
        private final ValueAccessPointMap<C, RelationalEntityPersister<?, ?>> relations = new ValueAccessPointMap();

        @VisibleForTesting
        EntityGraphNode(EntityMapping<C, ?, ?> entityMapping) {
            this.entityClass = entityMapping.getClassToPersist();
            Stream.concat(entityMapping.getPropertyToColumn().entrySet().stream(), entityMapping.getReadonlyPropertyToColumn().entrySet().stream()).forEach(entry -> {
                ReversibleAccessor accessor = (ReversibleAccessor)entry.getKey();
                List key = accessor instanceof AccessorChain ? ((AccessorChain)accessor).getAccessors() : Arrays.asList((Object[])new ReversibleAccessor[]{accessor});
                this.propertyToColumn.put(key, (Column)entry.getValue());
            });
            IdMapping idMapping = entityMapping.getIdMapping();
            if (idMapping instanceof SimpleIdMapping) {
                Column primaryKey = ((SimpleIdentifierAssembler)idMapping.getIdentifierAssembler()).getColumn();
                this.propertyToColumn.put(Arrays.asList((Object[])new ReversibleAccessor[]{((SimpleIdMapping)idMapping).getIdAccessor().getIdAccessor()}), primaryKey);
            }
            entityMapping.getEmbeddedBeanStrategies().forEach((k, v) -> v.getPropertyToColumn().forEach((p, c) -> this.propertyToColumn.put(new AccessorChain(new Accessor[]{k, p}).getAccessors(), (Column)c)));
        }

        @VisibleForTesting
        void registerRelation(ValueAccessPoint<C> relationProvider, RelationalEntityPersister<?, ?> mappingStrategy) {
            this.propertyToColumn.remove(Arrays.asList((Object[])new ValueAccessPoint[]{relationProvider}));
            this.relations.put(relationProvider, mappingStrategy);
        }

        public Column getColumn(List<? extends ValueAccessPoint<?>> valueAccessPoints) {
            Column column = this.propertyToColumn.get(valueAccessPoints);
            if (column != null) {
                return column;
            }
            RelationalEntityPersister entityGraphNode = (RelationalEntityPersister)this.relations.get(valueAccessPoints.get(0));
            if (entityGraphNode != null) {
                column = entityGraphNode.getColumn(valueAccessPoints.subList(1, valueAccessPoints.size()));
            }
            if (column == null) {
                throw this.newConfigurationException(valueAccessPoints);
            }
            return column;
        }

        private MappingConfigurationException newConfigurationException(List<? extends ValueAccessPoint<?>> valueAccessPoints) {
            StringAppender accessPointAsString = new StringAppender(){

                public StringAppender cat(Object o) {
                    if (o instanceof ValueAccessPoint) {
                        super.cat((Object)AccessorDefinition.toString((ValueAccessPoint)((ValueAccessPoint)o)));
                    } else {
                        super.cat(o);
                    }
                    return this;
                }
            };
            accessPointAsString.ccat(valueAccessPoints, (Object)" > ");
            return new MappingConfigurationException("Error while looking for column of " + accessPointAsString + " : it is not declared in mapping of " + Reflections.toString(this.entityClass));
        }
    }
}

