/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableProjection;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.BeanPersister;
import org.codefilarete.stalactite.engine.runtime.CompositeKeyedBeanPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.DeleteExecutor;
import org.codefilarete.stalactite.engine.runtime.EntityMappingTreeSelectExecutor;
import org.codefilarete.stalactite.engine.runtime.InsertExecutor;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.EntityGraphSelector;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Iterables;

public class SimpleRelationalEntityPersister<C, I, T extends Table<T>>
implements ConfiguredRelationalPersister<C, I> {
    private final BeanPersister<C, I, T> persister;
    private final EntitySelector<C, I> entitySelector;
    private final EntityCriteriaSupport<C> criteriaSupport;
    private final EntityMappingTreeSelectExecutor<C, I, T> selectGraphExecutor;

    public SimpleRelationalEntityPersister(ClassMapping<C, I, T> mainMappingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this(new BeanPersister(mainMappingStrategy, dialect, connectionConfiguration), dialect, connectionConfiguration);
    }

    public SimpleRelationalEntityPersister(BeanPersister<C, I, T> persister, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this.persister = persister;
        this.criteriaSupport = new EntityCriteriaSupport(persister.getMapping());
        this.selectGraphExecutor = this.newSelectExecutor(persister.getMapping(), connectionConfiguration.getConnectionProvider(), dialect);
        this.entitySelector = this.newEntitySelectExecutor(dialect);
    }

    protected EntityMappingTreeSelectExecutor<C, I, T> newSelectExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionProvider connectionProvider, Dialect dialect) {
        return new EntityMappingTreeSelectExecutor<C, I, T>(mappingStrategy, dialect, connectionProvider);
    }

    protected EntitySelector<C, I> newEntitySelectExecutor(Dialect dialect) {
        return new EntityGraphSelector(this.persister, this.selectGraphExecutor.getEntityJoinTree(), this.persister.getConnectionProvider(), dialect);
    }

    @Override
    public Column getColumn(List<? extends ValueAccessPoint<?>> accessorChain) {
        return this.criteriaSupport.getRootConfiguration().getColumn(accessorChain);
    }

    public EntityMappingTreeSelectExecutor<C, I, T> getEntityMappingTreeSelectExecutor() {
        return this.selectGraphExecutor;
    }

    public I getId(C entity) {
        return (I)this.persister.getId(entity);
    }

    public T getMainTable() {
        return (T)this.persister.getMainTable();
    }

    public InsertExecutor<C, I, T> getInsertExecutor() {
        return this.persister.getInsertExecutor();
    }

    public org.codefilarete.stalactite.engine.runtime.UpdateExecutor<C, I, T> getUpdateExecutor() {
        return this.persister.getUpdateExecutor();
    }

    public EntityMappingTreeSelectExecutor<C, I, T> getSelectExecutor() {
        return this.selectGraphExecutor;
    }

    public DeleteExecutor<C, I, T> getDeleteExecutor() {
        return this.persister.getDeleteExecutor();
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.getEntityMappingTreeSelectExecutor().getEntityJoinTree();
    }

    public Set<C> select(Iterable<I> ids) {
        if (Iterables.isEmpty(ids)) {
            return new HashSet();
        }
        return this.getPersisterListener().doWithSelectListener(ids, () -> this.doSelect(ids));
    }

    protected Set<C> doSelect(Iterable<I> ids) {
        return this.selectGraphExecutor.select(ids);
    }

    public EntityMapping<C, I, T> getMapping() {
        return this.persister.getMapping();
    }

    public Set<Table> giveImpliedTables() {
        return this.getEntityJoinTree().giveTables();
    }

    public PersisterListenerCollection<C, I> getPersisterListener() {
        return this.persister.getPersisterListener();
    }

    @Override
    public RelationalEntityPersister.RelationalExecutableEntityQuery<C> selectWhere() {
        EntityCriteriaSupport<C> localCriteriaSupport = this.newWhere();
        return this.wrapIntoExecutable(localCriteriaSupport);
    }

    private RelationalEntityPersister.RelationalExecutableEntityQuery<C> wrapIntoExecutable(EntityCriteriaSupport<C> localCriteriaSupport) {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        return (RelationalEntityPersister.RelationalExecutableEntityQuery)methodDispatcher.redirect(ExecutableQuery::execute, this.wrapGraphLoad(localCriteriaSupport)).redirect(CriteriaProvider::getCriteria, localCriteriaSupport::getCriteria).redirect(RelationalEntityCriteria.class, localCriteriaSupport, true).build(RelationalEntityPersister.RelationalExecutableEntityQuery.class);
    }

    private <R> Function<Accumulator<C, Set<C>, R>, R> wrapGraphLoad(EntityCriteriaSupport<C> localCriteriaSupport) {
        return accumulator -> {
            Set result = this.getPersisterListener().doWithSelectListener(Collections.emptySet(), () -> this.entitySelector.select(localCriteriaSupport.getCriteria()));
            return accumulator.collect((Iterable)result);
        };
    }

    private EntityCriteriaSupport<C> newWhere() {
        return new EntityCriteriaSupport<C>(this.criteriaSupport);
    }

    public EntityPersister.ExecutableProjectionQuery<C> selectProjectionWhere(Consumer<Select> selectAdapter) {
        EntityCriteriaSupport<C> localCriteriaSupport = this.newWhere();
        return this.wrapIntoExecutable(selectAdapter, localCriteriaSupport);
    }

    private EntityPersister.ExecutableProjectionQuery<C> wrapIntoExecutable(Consumer<Select> selectAdapter, EntityCriteriaSupport<C> localCriteriaSupport) {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        ExecutableProjectionQuerySupport querySugarSupport = new ExecutableProjectionQuerySupport();
        return (EntityPersister.ExecutableProjectionQuery)methodDispatcher.redirect(ExecutableProjection::execute, this.wrapProjectionLoad(selectAdapter, localCriteriaSupport, querySugarSupport)).redirect(ExecutableProjection::distinct, querySugarSupport::distinct).redirect(ExecutableProjection::limit, querySugarSupport::limit).redirect(EntityPersister.EntityCriteria.class, localCriteriaSupport, true).build(EntityPersister.ExecutableProjectionQuery.class);
    }

    private <R> Function<Accumulator<? super Function<? extends Selectable, Object>, Object, R>, R> wrapProjectionLoad(Consumer<Select> selectAdapter, EntityCriteriaSupport<C> localCriteriaSupport, ExecutableProjectionQuerySupport querySugarSupport) {
        return accumulator -> this.entitySelector.selectProjection(selectAdapter, accumulator, localCriteriaSupport.getCriteria(), querySugarSupport.isDistinct(), fluentOrderByClause -> Nullable.nullable((Object)querySugarSupport.getLimit()).invoke(arg_0 -> ((Query.FluentOrderByClause)fluentOrderByClause).limit(arg_0)));
    }

    public Set<C> selectAll() {
        return this.getPersisterListener().doWithSelectListener(Collections.emptyList(), () -> this.entitySelector.select(this.newWhere().getCriteria()));
    }

    public boolean isNew(C entity) {
        return this.persister.isNew(entity);
    }

    public Class<C> getClassToPersist() {
        return this.persister.getClassToPersist();
    }

    @Override
    public void registerRelation(ValueAccessPoint<C> relation, RelationalEntityPersister<?, ?> persister) {
        this.criteriaSupport.registerRelation(relation, persister);
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsOne(RelationalEntityPersister<SRC, SRCID> sourcePersister, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, String rightTableAlias, BeanRelationFixer<SRC, C> beanRelationFixer, boolean optional, boolean loadSeparately) {
        EntityInflater.EntityMappingAdapter<C, I, T> strategy = new EntityInflater.EntityMappingAdapter<C, I, T>(this.getMapping());
        String createdJoinNodeName = sourcePersister.getEntityJoinTree().addRelationJoin("ROOT", strategy, leftColumn, rightColumn, rightTableAlias, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, beanRelationFixer, Collections.emptySet());
        this.copyRootJoinsTo(sourcePersister.getEntityJoinTree(), createdJoinNodeName);
        return createdJoinNodeName;
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsMany(RelationalEntityPersister<SRC, SRCID> sourcePersister, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, BeanRelationFixer<SRC, C> beanRelationFixer, @javax.annotation.Nullable BiFunction<Row, ColumnedRow, Object> relationIdentifierProvider, String joinName, Set<? extends Column<T2, Object>> selectableColumns, boolean optional, boolean loadSeparately) {
        EntityInflater.EntityMappingAdapter<C, I, T> strategy = new EntityInflater.EntityMappingAdapter<C, I, T>(this.getMapping());
        String createdJoinNodeName = sourcePersister.getEntityJoinTree().addRelationJoin(joinName, strategy, leftColumn, rightColumn, null, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, beanRelationFixer, selectableColumns, relationIdentifierProvider);
        this.copyRootJoinsTo(sourcePersister.getEntityJoinTree(), createdJoinNodeName);
        return createdJoinNodeName;
    }

    @Override
    public <E, ID> void copyRootJoinsTo(EntityJoinTree<E, ID> entityJoinTree, String joinName) {
        this.getEntityJoinTree().projectTo(entityJoinTree, joinName);
    }

    public void delete(Iterable<? extends C> entities) {
        this.persister.delete(entities);
    }

    public void deleteById(Iterable<? extends C> entities) {
        this.persister.deleteById(entities);
    }

    public void insert(Iterable<? extends C> entities) {
        this.persister.insert(entities);
    }

    public void persist(Iterable<? extends C> entities) {
        if (this.persister instanceof CompositeKeyedBeanPersister) {
            this.getPersisterListener().doWithPersistListener(entities, () -> PersistExecutor.persist((Iterable)entities, (SelectExecutor)this, (UpdateExecutor)this, (org.codefilarete.stalactite.engine.InsertExecutor)this, this::getId));
        } else {
            this.getPersisterListener().doWithPersistListener(entities, () -> PersistExecutor.persist((Iterable)entities, this::isNew, (SelectExecutor)this, (UpdateExecutor)this, (org.codefilarete.stalactite.engine.InsertExecutor)this, this::getId));
        }
    }

    public void updateById(Iterable<? extends C> entities) {
        this.persister.updateById(entities);
    }

    public void update(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        this.persister.update(differencesIterable, allColumnsStatement);
    }

    public void addPersistListener(PersistListener<? extends C> persistListener) {
        this.persister.addPersistListener(persistListener);
    }

    public void addInsertListener(InsertListener<? extends C> insertListener) {
        this.persister.addInsertListener(insertListener);
    }

    public void addUpdateListener(UpdateListener<? extends C> updateListener) {
        this.persister.addUpdateListener(updateListener);
    }

    public void addUpdateByIdListener(UpdateByIdListener<? extends C> updateByIdListener) {
        this.persister.addUpdateByIdListener(updateByIdListener);
    }

    public void addSelectListener(SelectListener<? extends C, I> selectListener) {
        this.persister.addSelectListener(selectListener);
    }

    public void addDeleteListener(DeleteListener<? extends C> deleteListener) {
        this.persister.addDeleteListener(deleteListener);
    }

    public void addDeleteByIdListener(DeleteByIdListener<? extends C> deleteListener) {
        this.persister.addDeleteByIdListener(deleteListener);
    }

    private static class ExecutableProjectionQuerySupport {
        private boolean distinct;
        private Integer limit;

        private ExecutableProjectionQuerySupport() {
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        void distinct() {
            this.distinct = true;
        }

        public Integer getLimit() {
            return this.limit;
        }

        void limit(int count) {
            this.limit = count;
        }
    }

    public static interface CriteriaProvider {
        public CriteriaChain getCriteria();
    }
}

