/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.InMemoryCounterIdentifierGenerator;
import org.codefilarete.stalactite.engine.runtime.BeanPersister;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.PersistentFieldHarvester;
import org.codefilarete.stalactite.mapping.id.manager.BeforeInsertIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Database;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.test.DatabaseIntegrationTest;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Sequence;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class PersisterITTest
extends DatabaseIntegrationTest {
    private BeanPersister<Toto, Integer, TotoTable> testInstance;
    private InMemoryCounterIdentifierGenerator identifierGenerator;

    PersisterITTest() {
    }

    abstract Dialect createDialect();

    @BeforeEach
    void setUp() {
        TotoTable totoClassTable = new TotoTable(null, "Toto");
        PersistentFieldHarvester persistentFieldHarvester = new PersistentFieldHarvester();
        Map totoClassMapping = persistentFieldHarvester.mapFields(Toto.class, (Table)totoClassTable);
        Map columns = totoClassTable.mapColumnsOnName();
        ((Column)columns.get("a")).setPrimaryKey(true);
        this.identifierGenerator = new InMemoryCounterIdentifierGenerator();
        PropertyAccessor identifierAccessor = Accessors.propertyAccessor((Field)persistentFieldHarvester.getField("a"));
        ClassMapping totoClassMappingStrategy = new ClassMapping(Toto.class, (Table)totoClassTable, totoClassMapping, (ReversibleAccessor)identifierAccessor, (IdentifierInsertionManager)new BeforeInsertIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor((ReversibleAccessor)identifierAccessor), (Sequence)this.identifierGenerator, Integer.class));
        Dialect dialect = this.createDialect();
        this.identifierGenerator.reset();
        this.testInstance = new BeanPersister((EntityMapping)totoClassMappingStrategy, dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(this.connectionProvider, 3));
        DDLDeployer ddlDeployer = new DDLDeployer(dialect.getSqlTypeRegistry(), this.connectionProvider);
        ddlDeployer.getDdlGenerator().setTables((Set)Arrays.asSet((Object[])new Table[]{totoClassTable}));
        ddlDeployer.deployDDL();
    }

    @Test
    void persist() throws SQLException {
        Connection connection = this.connectionProvider.giveConnection();
        Integer persistedInstanceID = this.identifierGenerator.next();
        connection.prepareStatement("insert into Toto(a, b, c) values (" + persistedInstanceID + ", 10, 100)").execute();
        Toto toBeInserted = new Toto(null, 20, 200);
        Toto toBeUpdated = new Toto(persistedInstanceID, 11, 111);
        this.testInstance.persist((Iterable)Arrays.asList((Object[])new Toto[]{toBeInserted, toBeUpdated}));
        ResultSetIterator<Map> resultSetIterator = new ResultSetIterator<Map>(){

            public Map convert(ResultSet resultSet) throws SQLException {
                return Maps.forHashMap(String.class, Integer.class).add((Object)"a", (Object)resultSet.getInt("a")).add((Object)"b", (Object)resultSet.getInt("b")).add((Object)"c", (Object)resultSet.getInt("c"));
            }
        };
        ResultSet resultSet = connection.prepareStatement("select * from Toto order by a").executeQuery();
        resultSetIterator.setResultSet(resultSet);
        List result = Iterables.copy((Iterator)resultSetIterator);
        Assertions.assertThat((List)result).isEqualTo((Object)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)11).add((Object)"c", (Object)111), Maps.asMap((Object)"a", (Object)2).add((Object)"b", (Object)20).add((Object)"c", (Object)200)}));
    }

    @Test
    void insert() throws SQLException {
        Toto toBeInserted = new Toto(1, 10, 100);
        this.testInstance.insert((Object)toBeInserted);
        Connection connection = this.connectionProvider.giveConnection();
        ResultSetIterator<Map> resultSetIterator = new ResultSetIterator<Map>(){

            public Map convert(ResultSet resultSet) throws SQLException {
                return Maps.forHashMap(String.class, Integer.class).add((Object)"a", (Object)resultSet.getInt("a")).add((Object)"b", (Object)resultSet.getInt("b")).add((Object)"c", (Object)resultSet.getInt("c"));
            }
        };
        ResultSet resultSet = connection.prepareStatement("select * from Toto").executeQuery();
        resultSetIterator.setResultSet(resultSet);
        List result = Iterables.copy((Iterator)resultSetIterator);
        Assertions.assertThat((List)result).isEqualTo((Object)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)10).add((Object)"c", (Object)100)}));
    }

    @Test
    void update() throws SQLException {
        Connection connection = this.connectionProvider.giveConnection();
        Integer persistedInstanceID = this.identifierGenerator.next();
        connection.prepareStatement("insert into Toto(a, b, c) values (" + persistedInstanceID + ", 10, 100)").execute();
        this.testInstance.update((Object)new Toto(persistedInstanceID, 11, 111), (Object)new Toto(persistedInstanceID, 10, 100), true);
        ResultSetIterator<Map> resultSetIterator = new ResultSetIterator<Map>(){

            public Map convert(ResultSet resultSet) throws SQLException {
                return Maps.forHashMap(String.class, Integer.class).add((Object)"a", (Object)resultSet.getInt("a")).add((Object)"b", (Object)resultSet.getInt("b")).add((Object)"c", (Object)resultSet.getInt("c"));
            }
        };
        ResultSet resultSet = connection.prepareStatement("select * from Toto").executeQuery();
        resultSetIterator.setResultSet(resultSet);
        List result = Iterables.copy((Iterator)resultSetIterator);
        Assertions.assertThat((List)result).isEqualTo((Object)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)11).add((Object)"c", (Object)111)}));
        this.testInstance.updateById((Object)new Toto(persistedInstanceID, 12, 122));
        resultSet = connection.prepareStatement("select * from Toto").executeQuery();
        resultSetIterator.setResultSet(resultSet);
        result = Iterables.copy((Iterator)resultSetIterator);
        Assertions.assertThat((List)result).isEqualTo((Object)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)12).add((Object)"c", (Object)122)}));
    }

    @Test
    void delete() throws SQLException {
        Connection connection = this.connectionProvider.giveConnection();
        Integer persistedInstanceID = this.identifierGenerator.next();
        connection.prepareStatement("insert into Toto(a, b, c) values (" + persistedInstanceID + ", 10, 100)").execute();
        this.testInstance.delete((Object)new Toto(persistedInstanceID, 11, 111));
        ResultSetIterator<Map> resultSetIterator = new ResultSetIterator<Map>(){

            public Map convert(ResultSet resultSet) throws SQLException {
                return Maps.asMap((Object)"a", (Object)resultSet.getObject("a")).add((Object)"b", resultSet.getObject("b")).add((Object)"c", resultSet.getObject("c"));
            }
        };
        ResultSet resultSet = connection.prepareStatement("select * from Toto").executeQuery();
        resultSetIterator.setResultSet(resultSet);
        List result = Iterables.copy((Iterator)resultSetIterator);
        Assertions.assertThat((List)result).isEqualTo((Object)Arrays.asList((Object[])new Object[0]));
        connection.prepareStatement("insert into Toto(a, b, c) values (" + persistedInstanceID + ", 10, 100)").execute();
        this.testInstance.deleteById((Object)new Toto(persistedInstanceID, 12, 122));
        resultSet = connection.prepareStatement("select * from Toto").executeQuery();
        resultSetIterator.setResultSet(resultSet);
        result = Iterables.copy((Iterator)resultSetIterator);
        Assertions.assertThat((List)result).isEqualTo((Object)Arrays.asList((Object[])new Object[0]));
    }

    @Test
    void select() throws SQLException {
        Connection connection = this.connectionProvider.giveConnection();
        connection.prepareStatement("insert into Toto(a, b, c) values (1, 10, 100)").execute();
        connection.prepareStatement("insert into Toto(a, b, c) values (2, 20, 200)").execute();
        connection.prepareStatement("insert into Toto(a, b, c) values (3, 30, 300)").execute();
        connection.prepareStatement("insert into Toto(a, b, c) values (4, 40, 400)").execute();
        Set totos = this.testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{1}));
        Toto t = (Toto)Iterables.first((Iterable)totos);
        Assertions.assertThat((Object)t.a).isEqualTo((Object)1);
        Assertions.assertThat((Object)t.b).isEqualTo((Object)10);
        Assertions.assertThat((Object)t.c).isEqualTo((Object)100);
        totos = this.testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{2, 3, 4}));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)totos).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(2, 20, 200), new Toto(3, 30, 300), new Toto(4, 40, 400)});
    }

    static class TotoTable
    extends Table<TotoTable> {
        public TotoTable(String name) {
            super(name);
        }

        public TotoTable(Database.Schema schema, String name) {
            super(schema, name);
        }
    }

    static class Toto {
        private Integer a;
        private Integer b;
        private Integer c;

        public Toto() {
        }

        public Toto(Integer a, Integer b, Integer c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public Toto(Integer b, Integer c) {
            this.b = b;
            this.c = c;
        }

        public String toString() {
            return "Toto{a=" + this.a + ", b=" + this.b + ", c=" + this.c + '}';
        }
    }
}

