/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.function.SerializableThrowingBiFunction;

public class NullAwareResultSetReader<T>
implements ResultSetReader<T> {
    private final ResultSetReader<T> delegate;

    public NullAwareResultSetReader(SerializableThrowingBiFunction<ResultSet, String, T, SQLException> resultSetGetter) {
        this(ResultSetReader.ofMethodReference(resultSetGetter));
    }

    public NullAwareResultSetReader(ResultSetReader<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T doGet(ResultSet resultSet, String columnName) throws SQLException {
        if (!this.isNull(columnName, resultSet)) {
            return this.getNotNull(columnName, resultSet);
        }
        return null;
    }

    @Override
    public Class<T> getType() {
        return this.delegate.getType();
    }

    @Override
    public <O> Class<O> getColumnType() {
        return this.delegate.getColumnType();
    }

    protected boolean isNull(String columnName, ResultSet resultSet) throws SQLException {
        return resultSet.getObject(columnName) == null;
    }

    public T getNotNull(String columnName, ResultSet resultSet) {
        return this.delegate.get(resultSet, columnName);
    }
}

