/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.SerializableThrowingBiFunction;

public class GeneratedKeysReader<I> {
    private final String keyName;
    private final ResultSetReader<I> typeReader;

    public GeneratedKeysReader(String keyName, SerializableThrowingBiFunction<ResultSet, String, I, SQLException> resultSetGetter) {
        this(keyName, ResultSetReader.ofMethodReference(resultSetGetter));
    }

    public GeneratedKeysReader(String keyName, ResultSetReader<I> typeReader) {
        this.keyName = keyName;
        this.typeReader = typeReader;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public List<I> convert(WriteOperation writeOperation) throws SQLException {
        try (ResultSet generatedKeys = writeOperation.preparedStatement.getGeneratedKeys();){
            List<I> list = this.convert(generatedKeys);
            return list;
        }
    }

    public List<I> convert(ResultSet generatedKeys) {
        ResultSetIterator iterator = new ResultSetIterator<I>(generatedKeys){

            @Override
            public I convert(ResultSet rs) throws SQLException {
                return GeneratedKeysReader.this.readKey(rs);
            }
        };
        return Iterables.copy((Iterator)((Object)iterator));
    }

    protected I readKey(ResultSet rs) throws SQLException {
        return this.typeReader.get(rs, this.getKeyName());
    }
}

