/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.query;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Stream;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.engine.configurer.DefaultComposedIdentifierAssembler;
import org.codefilarete.stalactite.engine.configurer.builder.BuildLifeCycleListener;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementRecord;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementRecordMapping;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecord;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMapping;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.TablePerClassRootJoinNode;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.SingleIdentifierAssembler;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;

public class AggregateAccessPointToColumnMapping<C> {
    private final Map<List<? extends ValueAccessPoint<?>>, JoinLink<?, ?>> propertyToColumn = new EntityCriteriaSupport.AccessorToColumnMap();
    private final EntityJoinTree<C, ?> tree;

    @VisibleForTesting
    AggregateAccessPointToColumnMapping(EntityJoinTree<C, ?> tree, boolean withImmediatePropertiesCollect) {
        this.tree = tree;
        if (withImmediatePropertiesCollect) {
            this.collectPropertiesMapping();
        } else {
            PersisterBuilderContext.CURRENT.get().addBuildLifeCycleListener(new BuildLifeCycleListener(){

                @Override
                public void afterBuild() {
                    AggregateAccessPointToColumnMapping.this.collectPropertiesMapping();
                }

                @Override
                public void afterAllBuild() {
                }
            });
        }
    }

    public boolean hasCollectionProperty() {
        return this.propertyToColumn.keySet().stream().flatMap(Collection::stream).anyMatch(valueAccessPoint -> Iterable.class.isAssignableFrom(AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint).getMemberType()));
    }

    @VisibleForTesting
    public Map<List<? extends ValueAccessPoint<?>>, JoinLink<?, ?>> getPropertyToColumn() {
        return this.propertyToColumn;
    }

    private void collectPropertiesMapping() {
        ArrayDeque accessorPath = new ArrayDeque();
        Map<List<ValueAccessPoint<?>>, Selectable<?>> rootProperties = this.collectPropertiesMapping(this.tree.getRoot(), accessorPath);
        rootProperties.forEach((valueAccessPoints, selectable) -> this.propertyToColumn.put((List<ValueAccessPoint<?>>)valueAccessPoints, this.tree.getRoot().getOriginalColumnsToLocalOnes().get(selectable)));
        Queue<AbstractJoinNode<?, ?, ?, ?>> stack = Collections.asLifoQueue(new ArrayDeque());
        stack.addAll((Collection<AbstractJoinNode<?, ?, ?, ?>>)this.tree.getRoot().getJoins());
        while (!stack.isEmpty()) {
            AbstractJoinNode abstractJoinNode = (AbstractJoinNode)stack.poll();
            if (abstractJoinNode instanceof RelationJoinNode) {
                RelationJoinNode relationJoinNode = (RelationJoinNode)abstractJoinNode;
                accessorPath.add(relationJoinNode.getPropertyAccessor());
                Map<List<ValueAccessPoint<?>>, Selectable<?>> joinNodeProperties = this.collectPropertiesMapping(relationJoinNode, accessorPath);
                joinNodeProperties.forEach((valueAccessPoints, selectable) -> this.propertyToColumn.put((List<ValueAccessPoint<?>>)valueAccessPoints, relationJoinNode.getOriginalColumnsToLocalOnes().get(selectable)));
                if (abstractJoinNode.getJoins().isEmpty()) {
                    accessorPath.removeLast();
                }
            }
            stack.addAll((Collection<AbstractJoinNode<?, ?, ?, ?>>)abstractJoinNode.getJoins());
        }
    }

    private <E> Map<List<ValueAccessPoint<?>>, Selectable<?>> collectPropertiesMapping(JoinNode<E, ?> joinNode, Deque<Accessor<?, ?>> accessorPath) {
        EntityMapping entityMapping;
        EntityInflater entityInflater;
        if (joinNode instanceof JoinRoot) {
            if (joinNode instanceof TablePerClassRootJoinNode) {
                EntityInflater entityInflater2 = ((TablePerClassRootJoinNode)joinNode).getEntityInflater();
                EntityMapping entityMapping2 = entityInflater2.getEntityMapping();
                QueryStatement.PseudoTable pseudoTable = (QueryStatement.PseudoTable)((TablePerClassRootJoinNode)joinNode).getTable();
                return this.collectPropertiesMapping(entityMapping2, accessorPath, col -> pseudoTable.findColumn(col.getExpression()));
            }
            entityInflater = ((JoinRoot)joinNode).getEntityInflater();
        } else if (joinNode instanceof RelationJoinNode) {
            entityInflater = ((RelationJoinNode)joinNode).getEntityInflater();
            entityMapping = entityInflater.getEntityMapping();
            if (entityMapping instanceof ElementRecordMapping) {
                HashMap result = new HashMap();
                Column mapValueColumn = (Column)entityMapping.getPropertyToColumn().get(ElementRecord.ELEMENT_ACCESSOR);
                ArrayList accessorPrefix = new ArrayList(accessorPath);
                result.put((List<ValueAccessPoint<?>>)accessorPrefix, (Selectable<?>)mapValueColumn);
                return result;
            }
            if (entityMapping instanceof KeyValueRecordMapping) {
                HashMap result = new HashMap();
                Column mapValueColumn = (Column)entityMapping.getPropertyToColumn().get(KeyValueRecord.VALUE_ACCESSOR);
                ArrayList accessorPrefix = new ArrayList(accessorPath);
                result.put((List<ValueAccessPoint<?>>)accessorPrefix, (Selectable<?>)mapValueColumn);
                return result;
            }
        } else {
            throw new UnsupportedOperationException("Unsupported join type " + Reflections.toString(joinNode.getClass()));
        }
        entityMapping = entityInflater.getEntityMapping();
        return this.collectPropertiesMapping(entityMapping, accessorPath, Function.identity());
    }

    private <E> Map<List<ValueAccessPoint<?>>, Selectable<?>> collectPropertiesMapping(EntityMapping<E, ?, ?> entityMapping, Collection<Accessor<?, ?>> nodeAccessorPath, Function<Selectable<?>, Selectable<?>> columnAdapter) {
        HashMap result = new HashMap();
        Stream.concat(entityMapping.getPropertyToColumn().entrySet().stream(), entityMapping.getReadonlyPropertyToColumn().entrySet().stream()).forEach(entry -> {
            ReversibleAccessor accessor = (ReversibleAccessor)entry.getKey();
            List key = accessor instanceof AccessorChain ? new ArrayList(((AccessorChain)accessor).getAccessors()) : Arrays.asList((Object[])new ValueAccessPoint[]{accessor});
            result.put((List<ValueAccessPoint<?>>)key, (Selectable<?>)columnAdapter.apply((Selectable<?>)entry.getValue()));
        });
        IdentifierAssembler identifierAssembler = entityMapping.getIdMapping().getIdentifierAssembler();
        if (identifierAssembler instanceof SingleIdentifierAssembler) {
            Column idColumn2 = ((SingleIdentifierAssembler)identifierAssembler).getColumn();
            ReversibleAccessor idAccessor2 = ((AccessorWrapperIdAccessor)entityMapping.getIdMapping().getIdAccessor()).getIdAccessor();
            result.put(Arrays.asList((Object[])new ValueAccessPoint[]{idAccessor2}), columnAdapter.apply((Selectable<?>)idColumn2));
        } else if (identifierAssembler instanceof DefaultComposedIdentifierAssembler) {
            ((DefaultComposedIdentifierAssembler)identifierAssembler).getMapping().forEach((idAccessor, idColumn) -> {
                ReversibleAccessor accessorPrefix = ((AccessorWrapperIdAccessor)entityMapping.getIdMapping().getIdAccessor()).getIdAccessor();
                result.put(Arrays.asList((Object[])new ValueAccessPoint[]{accessorPrefix, idAccessor}), (Selectable<?>)columnAdapter.apply((Selectable<?>)idColumn));
            });
        }
        entityMapping.getEmbeddedBeanStrategies().forEach((k, v) -> v.getPropertyToColumn().forEach((p, c) -> result.put(Arrays.asList((Object[])new ValueAccessPoint[]{k}), (Selectable<?>)columnAdapter.apply((Selectable<?>)c))));
        result.forEach((k, v) -> k.addAll(0, nodeAccessorPath));
        return result;
    }

    public JoinLink<?, ?> giveColumn(List<? extends ValueAccessPoint<?>> valueAccessPoints) {
        JoinLink<?, ?> column = this.propertyToColumn.get(valueAccessPoints);
        if (column != null) {
            return column;
        }
        throw this.newConfigurationException(valueAccessPoints);
    }

    private MappingConfigurationException newConfigurationException(List<? extends ValueAccessPoint<?>> valueAccessPoints) {
        StringAppender accessPointAsString = new StringAppender(){

            public StringAppender cat(Object o) {
                if (o instanceof ValueAccessPoint) {
                    super.cat((Object)AccessorDefinition.toString((ValueAccessPoint)((ValueAccessPoint)o)));
                } else {
                    super.cat(o);
                }
                return this;
            }
        };
        accessPointAsString.ccat(valueAccessPoints, (Object)" > ");
        return new MappingConfigurationException("Error while looking for column of " + accessPointAsString + " : it is not declared in mapping of " + Reflections.toString(this.tree.getRoot().getEntityInflater().getEntityType()));
    }
}

