/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.runtime.DMLExecutor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSelect;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectExecutor<C, I, T extends Table<T>>
extends DMLExecutor<C, I, T>
implements org.codefilarete.stalactite.engine.SelectExecutor<C, I> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final InternalExecutor<C, I, T> internalExecutor;
    private final ReadOperationFactory readOperationFactory;
    private final Integer fetchSize;
    protected SQLOperation.SQLOperationListener<Column<T, ?>> operationListener;

    public SelectExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, ReadOperationFactory readOperationFactory, int inOperatorMaxSize) {
        super(mappingStrategy, connectionConfiguration.getConnectionProvider(), dmlGenerator, inOperatorMaxSize);
        this.internalExecutor = new InternalExecutor<C, I, T>(mappingStrategy);
        this.readOperationFactory = readOperationFactory;
        this.fetchSize = connectionConfiguration.getFetchSize();
    }

    public void setOperationListener(SQLOperation.SQLOperationListener<Column<T, ?>> operationListener) {
        this.operationListener = operationListener;
    }

    @Override
    public Set<C> select(Iterable<I> ids) {
        HashSet result = new HashSet(Iterables.size(ids, () -> 50));
        SimpleConnectionProvider localConnectionProvider = new SimpleConnectionProvider(this.getConnectionProvider().giveConnection());
        Iterables.forEachChunk(ids, (int)this.getInOperatorMaxSize(), chunks -> this.LOGGER.debug("selecting entities in {} chunks", (Object)chunks.size()), arg_0 -> this.lambda$select$2((ConnectionProvider)localConnectionProvider, arg_0), (readOperation, chunk) -> result.addAll(this.internalExecutor.execute((ReadOperation<Column<T, ?>>)readOperation, (Collection<I>)chunk)), SQLOperation::close);
        return result;
    }

    private ReadOperation<Column<T, ?>> newReadOperation(T targetTable, Set<Column<T, ?>> columnsToRead, int blockSize, ConnectionProvider connectionProvider) {
        ColumnParameterizedSelect<T> selectStatement = this.getDmlGenerator().buildSelectByKey(targetTable, columnsToRead, ((Table)targetTable).getPrimaryKey().getColumns(), blockSize);
        ReadOperation<T> readOperation = this.readOperationFactory.createInstance(selectStatement, connectionProvider, this.fetchSize);
        readOperation.setListener(this.operationListener);
        return readOperation;
    }

    private /* synthetic */ ReadOperation lambda$select$2(ConnectionProvider localConnectionProvider, Integer chunkSize) {
        return this.newReadOperation(this.getMapping().getTargetTable(), this.getMapping().getSelectableColumns(), chunkSize, localConnectionProvider);
    }

    @VisibleForTesting
    static class InternalExecutor<C, I, T extends Table<T>> {
        private final IdentifierAssembler<I, T> primaryKeyProvider;
        private final Function<ColumnedRow, C> transformer;

        InternalExecutor(EntityMapping<C, I, T> mapping) {
            this(mapping.getIdMapping().getIdentifierAssembler(), mapping::transform);
        }

        InternalExecutor(IdentifierAssembler<I, T> primaryKeyProvider, Function<ColumnedRow, C> transformer) {
            this.primaryKeyProvider = primaryKeyProvider;
            this.transformer = transformer;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @VisibleForTesting
        Set<C> execute(ReadOperation<Column<T, ?>> operation, Collection<I> ids) {
            Map<Column<T, ?>, ?> primaryKeyValues = this.primaryKeyProvider.getColumnValues((Iterable<I>)ids);
            try (ReadOperation<Column<T, ?>> closeableOperation = operation;){
                closeableOperation.setValues(primaryKeyValues);
                Set<C> set = this.transform(closeableOperation, primaryKeyValues.size());
                return set;
            }
            catch (RuntimeException e) {
                throw new SQLExecutionException(operation.getSqlStatement().getSQL(), (Throwable)e);
            }
        }

        protected Set<C> transform(ReadOperation<Column<T, ?>> closeableOperation, int size) {
            ResultSet resultSet = closeableOperation.execute();
            ColumnParameterizedSelect sqlStatement = (ColumnParameterizedSelect)closeableOperation.getSqlStatement();
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, sqlStatement.getSelectParameterBinders(), sqlStatement.getAliases());
            return this.transform((Iterator<ColumnedRow>)((Object)rowIterator), size);
        }

        protected Set<C> transform(Iterator<? extends ColumnedRow> rowIterator, int resultSize) {
            Iterable rows = () -> rowIterator;
            return (Set)Iterables.collect(rows, this.transformer, () -> new HashSet(resultSize));
        }
    }
}

