/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import org.codefilarete.stalactite.query.builder.FromSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.OperatorSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SelectSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.WhereSQLBuilderFactory;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;

public class QuerySQLBuilderFactoryBuilder {
    protected final DMLNameProviderFactory dmlNameProviderFactory;
    protected final ColumnBinderRegistry parameterBinderRegistry;
    protected final JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping;
    protected SelectSQLBuilderFactory selectBuilderFactory;
    protected FromSQLBuilderFactory fromSqlBuilderFactory;
    protected WhereSQLBuilderFactory whereSqlBuilderFactory;
    protected WhereSQLBuilderFactory havingBuilderFactory;
    protected OperatorSQLBuilderFactory operatorSQLBuilderFactory;
    protected FunctionSQLBuilderFactory functionSQLBuilderFactory;

    public QuerySQLBuilderFactoryBuilder(DMLNameProviderFactory dmlNameProviderFactory, ColumnBinderRegistry parameterBinderRegistry, JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping) {
        this.dmlNameProviderFactory = dmlNameProviderFactory;
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.javaTypeToSqlTypeMapping = javaTypeToSqlTypeMapping;
    }

    public QuerySQLBuilderFactoryBuilder withSelectBuilderFactory(SelectSQLBuilderFactory selectBuilderFactory) {
        this.selectBuilderFactory = selectBuilderFactory;
        return this;
    }

    public QuerySQLBuilderFactoryBuilder withFromSqlBuilderFactory(FromSQLBuilderFactory fromSqlBuilderFactory) {
        this.fromSqlBuilderFactory = fromSqlBuilderFactory;
        return this;
    }

    public QuerySQLBuilderFactoryBuilder withWhereSqlBuilderFactory(WhereSQLBuilderFactory whereSqlBuilderFactory) {
        this.whereSqlBuilderFactory = whereSqlBuilderFactory;
        return this;
    }

    public QuerySQLBuilderFactoryBuilder withHavingBuilderFactory(WhereSQLBuilderFactory havingBuilderFactory) {
        this.havingBuilderFactory = havingBuilderFactory;
        return this;
    }

    public QuerySQLBuilderFactoryBuilder withOperatorSQLBuilderFactory(OperatorSQLBuilderFactory operatorSQLBuilderFactory) {
        this.operatorSQLBuilderFactory = operatorSQLBuilderFactory;
        return this;
    }

    public QuerySQLBuilderFactoryBuilder withFunctionSQLBuilderFactory(FunctionSQLBuilderFactory functionSQLBuilderFactory) {
        this.functionSQLBuilderFactory = functionSQLBuilderFactory;
        return this;
    }

    public QuerySQLBuilderFactory build() {
        if (this.operatorSQLBuilderFactory == null) {
            this.withOperatorSQLBuilderFactory(new OperatorSQLBuilderFactory());
        }
        if (this.functionSQLBuilderFactory == null) {
            this.withFunctionSQLBuilderFactory(new FunctionSQLBuilderFactory(this.javaTypeToSqlTypeMapping));
        }
        if (this.whereSqlBuilderFactory == null) {
            this.withWhereSqlBuilderFactory(new WhereSQLBuilderFactory(this.parameterBinderRegistry, this.operatorSQLBuilderFactory, this.functionSQLBuilderFactory));
        }
        if (this.havingBuilderFactory == null) {
            this.withHavingBuilderFactory(this.whereSqlBuilderFactory);
        }
        if (this.fromSqlBuilderFactory == null) {
            this.withFromSqlBuilderFactory(new FromSQLBuilderFactory());
        }
        if (this.selectBuilderFactory == null) {
            this.withSelectBuilderFactory(new SelectSQLBuilderFactory(this.functionSQLBuilderFactory));
        }
        return new QuerySQLBuilderFactory(this.dmlNameProviderFactory, this.parameterBinderRegistry, this.selectBuilderFactory, this.fromSqlBuilderFactory, this.whereSqlBuilderFactory, this.havingBuilderFactory, this.functionSQLBuilderFactory);
    }
}

