/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetomany;

import java.util.Collection;
import java.util.function.Supplier;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Reflections;

class OneToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>, LEFTTABLE extends Table<LEFTTABLE>> {
    private final OneToManyRelation<SRC, TRGT, TRGTID, C> oneToManyRelation;
    private final ConfiguredRelationalPersister<SRC, SRCID> srcPersister;
    private final PrimaryKey<LEFTTABLE, SRCID> leftPrimaryKey;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final ColumnNamingStrategy indexColumnNamingStrategy;
    private final ReversibleAccessor<SRC, C> collectionGetter;
    private final String columnName;
    private final Mutator<SRC, C> setter;
    private final boolean orphanRemoval;
    private final boolean writeAuthorized;
    private final AccessorDefinition accessorDefinition;
    private final Supplier<C> collectionFactory;

    OneToManyAssociationConfiguration(OneToManyRelation<SRC, TRGT, TRGTID, C> oneToManyRelation, ConfiguredRelationalPersister<SRC, SRCID> srcPersister, PrimaryKey<LEFTTABLE, SRCID> leftPrimaryKey, ForeignKeyNamingStrategy foreignKeyNamingStrategy, JoinColumnNamingStrategy joinColumnNamingStrategy, ColumnNamingStrategy indexColumnNamingStrategy, String columnName, boolean orphanRemoval, boolean writeAuthorized) {
        this.oneToManyRelation = oneToManyRelation;
        this.srcPersister = srcPersister;
        this.leftPrimaryKey = leftPrimaryKey;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.indexColumnNamingStrategy = indexColumnNamingStrategy;
        this.columnName = columnName;
        this.collectionGetter = oneToManyRelation.getCollectionProvider();
        this.setter = this.collectionGetter.toMutator();
        this.orphanRemoval = orphanRemoval;
        this.writeAuthorized = writeAuthorized;
        this.accessorDefinition = AccessorDefinition.giveDefinition(this.oneToManyRelation.getCollectionProvider());
        this.collectionFactory = this.buildCollectionFactory();
    }

    private Supplier<C> buildCollectionFactory() {
        Supplier result = this.oneToManyRelation.getCollectionFactory();
        if (result == null) {
            result = Reflections.giveCollectionFactory((Class)this.accessorDefinition.getMemberType());
        }
        return result;
    }

    public OneToManyRelation<SRC, TRGT, TRGTID, C> getOneToManyRelation() {
        return this.oneToManyRelation;
    }

    public ConfiguredRelationalPersister<SRC, SRCID> getSrcPersister() {
        return this.srcPersister;
    }

    public PrimaryKey<LEFTTABLE, SRCID> getLeftPrimaryKey() {
        return this.leftPrimaryKey;
    }

    public ForeignKeyNamingStrategy getForeignKeyNamingStrategy() {
        return this.foreignKeyNamingStrategy;
    }

    public JoinColumnNamingStrategy getJoinColumnNamingStrategy() {
        return this.joinColumnNamingStrategy;
    }

    public ColumnNamingStrategy getIndexColumnNamingStrategy() {
        return this.indexColumnNamingStrategy;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ReversibleAccessor<SRC, C> getCollectionGetter() {
        return this.collectionGetter;
    }

    public Mutator<SRC, C> getSetter() {
        return this.setter;
    }

    public boolean isOrphanRemoval() {
        return this.orphanRemoval;
    }

    public boolean isWriteAuthorized() {
        return this.writeAuthorized;
    }

    public AccessorDefinition getAccessorDefinition() {
        return this.accessorDefinition;
    }

    public Supplier<C> getCollectionFactory() {
        return this.collectionFactory;
    }
}

