/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.IndexNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.MapEntryTableNamingStrategy;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.cascade.BeforeDeleteCollectionCascader;
import org.codefilarete.stalactite.engine.cascade.BeforeInsertCollectionCascader;
import org.codefilarete.stalactite.engine.configurer.map.ConvertingMapAccessor;
import org.codefilarete.stalactite.engine.configurer.map.InMemoryRelationHolder;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecord;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMapping;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.map.MapRelation;
import org.codefilarete.stalactite.engine.configurer.map.MapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.MapUpdater;
import org.codefilarete.stalactite.engine.configurer.map.RecordId;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.function.Functions;

public class ValueAsKeyMapRelationConfigurer<SRC, SRCID, K, V, VID, M extends Map<K, V>, MM extends Map<K, VID>>
extends MapRelationConfigurer<SRC, SRCID, K, VID, MM> {
    private final MapRelation<SRC, K, V, M> originalMapRelation;
    private final ConfiguredRelationalPersister<V, VID> valueEntityPersister;
    private final Function<SRC, M> mapGetter;
    private final InMemoryRelationHolder<SRCID, K, VID, V> inMemoryRelationHolder;
    private Key<?, VID> keyIdColumnsProjectInAssociationTable;
    private final CascadeOptions.RelationMode maintenanceMode;

    private static <SRC, K, V, VID, M extends Map<K, V>, MM extends Map<K, VID>> MapRelation<SRC, K, VID, MM> convertEntityMapToIdentifierMap(MapRelation<SRC, K, V, M> mapRelation, ConfiguredRelationalPersister<V, VID> valueEntityPersister) {
        ConvertingMapAccessor mapAccessor = new ConvertingMapAccessor(mapRelation, (k, v, result) -> result.put(k, valueEntityPersister.getId(v)));
        PropertyAccessor propertyAccessor = new PropertyAccessor(mapAccessor, (src, mm) -> {});
        return new MapRelation(propertyAccessor, mapRelation.getKeyType(), valueEntityPersister.getMapping().getIdMapping().getIdentifierInsertionManager().getIdentifierType());
    }

    public ValueAsKeyMapRelationConfigurer(MapRelation<SRC, K, V, M> mapRelation, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, ConfiguredRelationalPersister<V, VID> valueEntityPersister, ForeignKeyNamingStrategy foreignKeyNamingStrategy, ColumnNamingStrategy columnNamingStrategy, MapEntryTableNamingStrategy tableNamingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration, IndexNamingStrategy indexNamingStrategy) {
        super(ValueAsKeyMapRelationConfigurer.convertEntityMapToIdentifierMap(mapRelation, valueEntityPersister), sourcePersister, foreignKeyNamingStrategy, columnNamingStrategy, tableNamingStrategy, dialect, connectionConfiguration, indexNamingStrategy);
        this.originalMapRelation = mapRelation;
        this.valueEntityPersister = valueEntityPersister;
        this.mapGetter = arg_0 -> this.originalMapRelation.getMapProvider().get(arg_0);
        this.inMemoryRelationHolder = new InMemoryRelationHolder(trio -> new Duo(trio.getKeyLookup(), trio.getEntity()));
        this.maintenanceMode = mapRelation.getValueEntityRelationMode();
    }

    @Override
    public void configure() {
        AccessorDefinition mapProviderDefinition = AccessorDefinition.giveDefinition(this.originalMapRelation.getMapProvider());
        final Supplier mapFactory = Reflections.giveMapFactory((Class)mapProviderDefinition.getMemberType());
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>(){

            public void beforeSelect(Iterable<SRCID> ids) {
                ValueAsKeyMapRelationConfigurer.this.inMemoryRelationHolder.init();
            }

            public void afterSelect(Set<? extends SRC> result) {
                BeanRelationFixer originalRelationFixer = BeanRelationFixer.ofMapAdapter((arg_0, arg_1) -> ((Mutator)ValueAsKeyMapRelationConfigurer.this.originalMapRelation.getMapProvider().toMutator()).set(arg_0, arg_1), (Function)ValueAsKeyMapRelationConfigurer.this.mapGetter, (Supplier)mapFactory, (bean, duo, map) -> map.put(duo.getLeft(), duo.getRight()));
                result.forEach(bean -> {
                    Collection<Duo<Object, Object>> keyValuePairs = ValueAsKeyMapRelationConfigurer.this.inMemoryRelationHolder.get(ValueAsKeyMapRelationConfigurer.this.sourcePersister.getId(bean));
                    if (keyValuePairs != null) {
                        keyValuePairs.forEach(duo -> originalRelationFixer.apply(bean, duo));
                    }
                });
                ValueAsKeyMapRelationConfigurer.this.inMemoryRelationHolder.clear();
            }
        });
        super.configure();
    }

    @Override
    <TT extends Table<TT>, TARGETTABLE extends Table<TARGETTABLE>> DefaultEntityMapping<KeyValueRecord<K, VID, SRCID>, RecordId<K, SRCID>, TARGETTABLE> buildKeyValueRecordMapping(final TARGETTABLE targetTable, IdentifierAssembler<SRCID, TT> sourceIdentifierAssembler, Map<Column<TT, ?>, Column<TARGETTABLE, ?>> primaryKeyForeignColumnMapping, EmbeddableMappingConfiguration<K> keyEmbeddableConfiguration, EmbeddableMappingConfiguration<VID> valueEmbeddableConfiguration) {
        KeyValueRecordMappingBuilder builder = new KeyValueRecordMappingBuilder<K, VID, SRCID, TARGETTABLE, TT>(targetTable, sourceIdentifierAssembler, primaryKeyForeignColumnMapping){
            private final Map<Column<TARGETTABLE, Object>, Column<Table, Object>> foreignKeyBootstrap;
            {
                super(associationTable, sourceIdentifierAssembler, primaryKeyForeignColumnMapping);
                this.foreignKeyBootstrap = new HashMap();
            }

            @Override
            void withEntryValueIsSingleProperty(Column<TARGETTABLE, VID> keyColumn) {
                super.withEntryValueIsSingleProperty(keyColumn);
                Column column = ((SimpleIdMapping)ValueAsKeyMapRelationConfigurer.this.valueEntityPersister.getMapping().getIdMapping()).getIdentifierAssembler().getColumn();
                this.foreignKeyBootstrap.put(keyColumn, (Column<Table, Object>)column);
                ValueAsKeyMapRelationConfigurer.this.keyIdColumnsProjectInAssociationTable = Key.ofSingleColumn(keyColumn);
            }

            @Override
            void withEntryValueIsComplexType(EmbeddedClassMapping<VID, TARGETTABLE> entryKeyMapping) {
                super.withEntryValueIsComplexType(entryKeyMapping);
                Key.KeyBuilder keyIdColumnsProjectInAssociationTableBuilder = Key.from((Fromable)targetTable);
                entryKeyMapping.getPropertyToColumn().values().forEach(arg_0 -> ((Key.KeyBuilder)keyIdColumnsProjectInAssociationTableBuilder).addColumn(arg_0));
                ValueAsKeyMapRelationConfigurer.this.keyIdColumnsProjectInAssociationTable = keyIdColumnsProjectInAssociationTableBuilder.build();
            }

            @Override
            KeyValueRecordMapping<K, VID, SRCID, TARGETTABLE> build() {
                Key.KeyBuilder keyBuilder1 = Key.from((Fromable)targetTable);
                Key.KeyBuilder keyBuilder2 = Key.from(ValueAsKeyMapRelationConfigurer.this.valueEntityPersister.getMainTable());
                this.foreignKeyBootstrap.forEach((key, value) -> {
                    keyBuilder1.addColumn((JoinLink)key);
                    keyBuilder2.addColumn((JoinLink)value);
                });
                targetTable.addForeignKey(ValueAsKeyMapRelationConfigurer.this.foreignKeyNamingStrategy::giveName, keyBuilder1.build(), keyBuilder2.build());
                return super.build();
            }
        };
        return super.buildKeyValueRecordMapping(keyEmbeddableConfiguration, targetTable, builder, valueEmbeddableConfiguration);
    }

    @Override
    protected void addInsertCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, EntityPersister<KeyValueRecord<K, VID, SRCID>, RecordId<K, SRCID>> relationRecordPersister, Accessor<SRC, MM> mapAccessor) {
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            sourcePersister.addInsertListener(new BeforeInsertCollectionCascader<SRC, V>(this.valueEntityPersister){

                @Override
                protected Collection<V> getTargets(SRC src) {
                    return ((Map)ValueAsKeyMapRelationConfigurer.this.mapGetter.apply(src)).values();
                }
            });
        }
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            Function mapProviderForInsert = this.toRecordCollectionProvider(sourcePersister.getMapping(), false);
            sourcePersister.addInsertListener(new MapRelationConfigurer.TargetInstancesInsertCascader(relationRecordPersister, mapProviderForInsert));
        }
    }

    @Override
    protected void addUpdateCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, EntityPersister<KeyValueRecord<K, VID, SRCID>, RecordId<K, SRCID>> relationRecordPersister) {
        Functions.NullProofFunction targetEntitiesGetter = new Functions.NullProofFunction(this.mapGetter).andThen(Map::entrySet);
        BiFunction<Map.Entry, Object, KeyValueRecord> entryKeyValueRecordFunction = (record, srcId) -> new KeyValueRecord(srcId, record.getKey(), this.valueEntityPersister.getId(record.getValue()));
        MapUpdater mapUpdater = new MapUpdater(targetEntitiesGetter, this.valueEntityPersister, relationRecordPersister, sourcePersister, this.maintenanceMode, Map.Entry::getValue, entryKeyValueRecordFunction);
        sourcePersister.addUpdateListener(new OneToManyWithMappedAssociationEngine.AfterUpdateTrigger(mapUpdater));
    }

    @Override
    protected void addDeleteCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, EntityPersister<KeyValueRecord<K, VID, SRCID>, RecordId<K, SRCID>> relationRecordPersister) {
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            super.addDeleteCascade(sourcePersister, relationRecordPersister);
        }
        if (this.maintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
            Functions.NullProofFunction targetEntitiesGetter = new Functions.NullProofFunction(this.mapGetter).andThen(Map::entrySet).andThen(entries -> entries.stream().map(Map.Entry::getValue).collect(Collectors.toSet()));
            sourcePersister.addDeleteListener(new BeforeDeleteCollectionCascader<SRC, V>(this.valueEntityPersister, (Function)targetEntitiesGetter){
                final /* synthetic */ Function val$targetEntitiesGetter;
                {
                    this.val$targetEntitiesGetter = function;
                    super(persister);
                }

                @Override
                protected Collection<V> getTargets(SRC src) {
                    return (Collection)this.val$targetEntitiesGetter.apply(src);
                }
            });
        }
    }

    @Override
    protected void addSelectCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, SimpleRelationalEntityPersister<KeyValueRecord<K, VID, SRCID>, RecordId<K, SRCID>, ?> relationRecordPersister, PrimaryKey<?, SRCID> sourcePK, ForeignKey<?, ?, SRCID> keyValueRecordToSourceForeignKey, BiConsumer<SRC, MM> mapSetter, Accessor<SRC, MM> mapGetter, Supplier<MM> mapFactory) {
        BeanRelationFixer relationFixer = BeanRelationFixer.ofMapAdapter(mapSetter, arg_0 -> mapGetter.get(arg_0), mapFactory, (bean, input, map) -> this.inMemoryRelationHolder.storeRelation(sourcePersister.getId(bean), input.getKey(), input.getValue()));
        this.valueEntityPersister.joinAsMany("ROOT", relationRecordPersister, (Accessor)Accessors.accessorByMethodReference(KeyValueRecord::getValue), this.keyIdColumnsProjectInAssociationTable, (Key)this.valueEntityPersister.getMainTable().getPrimaryKey(), (bean, input) -> this.inMemoryRelationHolder.storeEntity(bean.getId().getId(), bean.getKey(), input), null, true, false);
        relationRecordPersister.joinAsMany("ROOT", sourcePersister, (Accessor)this.mapRelation.getMapProvider(), (Key)sourcePK, (Key)keyValueRecordToSourceForeignKey, relationFixer, null, true, this.originalMapRelation.isFetchSeparately());
    }
}

