/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manyToOne;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethod;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByMethod;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelation;
import org.codefilarete.tool.Nullable;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class ManyToOneRelation<SRC, TRGT, TRGTID, C extends Collection<SRC>> {
    private final ReversibleAccessor<SRC, TRGT> targetProvider;
    private final EntityMappingConfigurationProvider<TRGT, TRGTID> targetMappingConfiguration;
    private final BooleanSupplier sourceTablePerClassPolymorphic;
    private boolean nullable = true;
    private CascadeOptions.RelationMode relationMode = CascadeOptions.RelationMode.ALL;
    private final ManyToManyRelation.MappedByConfiguration<SRC, TRGT, C> mappedByConfiguration = new ManyToManyRelation.MappedByConfiguration();
    private boolean fetchSeparately;
    @javax.annotation.Nullable
    private String columnName;
    private final MethodReferenceCapturer methodSpy = new MethodReferenceCapturer();

    public ManyToOneRelation(ReversibleAccessor<SRC, TRGT> targetProvider, BooleanSupplier sourceTablePerClassPolymorphic, EntityMappingConfigurationProvider<? extends TRGT, TRGTID> targetMappingConfiguration) {
        this.sourceTablePerClassPolymorphic = sourceTablePerClassPolymorphic;
        this.targetMappingConfiguration = targetMappingConfiguration;
        this.targetProvider = targetProvider;
    }

    public ReversibleAccessor<SRC, TRGT> getTargetProvider() {
        return this.targetProvider;
    }

    public boolean isSourceTablePerClassPolymorphic() {
        return this.sourceTablePerClassPolymorphic.getAsBoolean();
    }

    public EntityMappingConfiguration<TRGT, TRGTID> getTargetMappingConfiguration() {
        return this.targetMappingConfiguration.getConfiguration();
    }

    public boolean isTargetTablePerClassPolymorphic() {
        return this.getTargetMappingConfiguration().getPolymorphismPolicy() instanceof PolymorphismPolicy.TablePerClassPolymorphism;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public CascadeOptions.RelationMode getRelationMode() {
        return this.relationMode;
    }

    public void setRelationMode(CascadeOptions.RelationMode relationMode) {
        this.relationMode = relationMode;
    }

    public ManyToManyRelation.MappedByConfiguration getMappedByConfiguration() {
        return this.mappedByConfiguration;
    }

    public boolean isFetchSeparately() {
        return this.fetchSeparately;
    }

    public void setFetchSeparately(boolean fetchSeparately) {
        this.fetchSeparately = fetchSeparately;
    }

    public void fetchSeparately() {
        this.setFetchSeparately(true);
    }

    @javax.annotation.Nullable
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(@javax.annotation.Nullable String columnName) {
        this.columnName = columnName;
    }

    @javax.annotation.Nullable
    PropertyAccessor<TRGT, C> buildReversePropertyAccessor() {
        Nullable getterReference = Nullable.nullable(this.mappedByConfiguration.getReverseCollectionAccessor()).map(Accessors::accessorByMethodReference);
        Nullable setterReference = Nullable.nullable(this.mappedByConfiguration.getReverseCollectionMutator()).map(Accessors::mutatorByMethodReference);
        if (getterReference.isAbsent() && setterReference.isAbsent()) {
            return null;
        }
        if (getterReference.isPresent() && setterReference.isPresent()) {
            return new PropertyAccessor((Accessor)getterReference.get(), (Mutator)setterReference.get());
        }
        if (getterReference.isPresent() && setterReference.isAbsent()) {
            return new PropertyAccessor((Accessor)getterReference.get(), new AccessorByMethod(this.captureMethod(this.mappedByConfiguration.getReverseCollectionAccessor())).toMutator());
        }
        return new PropertyAccessor(new MutatorByMethod(this.captureMethod(this.mappedByConfiguration.getReverseCollectionMutator())).toAccessor(), (Mutator)setterReference.get());
    }

    private Method captureMethod(SerializableFunction getter) {
        return this.methodSpy.findMethod(getter);
    }

    private Method captureMethod(SerializableBiConsumer setter) {
        return this.methodSpy.findMethod(setter);
    }
}

