/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.engine.cascade.AfterInsertSupport;
import org.codefilarete.stalactite.engine.cascade.AfterUpdateByIdSupport;
import org.codefilarete.stalactite.engine.cascade.AfterUpdateSupport;
import org.codefilarete.stalactite.engine.cascade.BeforeDeleteByIdSupport;
import org.codefilarete.stalactite.engine.cascade.BeforeDeleteSupport;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.FluentEmbeddableMappingConfigurationSupport;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.builder.MainPersisterStep;
import org.codefilarete.stalactite.engine.configurer.builder.PrimaryKeyPropagationStep;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableMapping;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableMappingBuilder;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;

public class ExtraTableConfigurer<C, I, T extends Table<T>> {
    private final PrimaryKey<T, I> mainTablePrimaryKey;
    private final ConfiguredRelationalPersister<C, I> mainPersister;
    private final AbstractIdentification<C, I> identification;
    private final Map<String, Set<EmbeddableMappingConfiguration.Linkage>> extraTableLinkages;
    private final ColumnBinderRegistry columnBinderRegistry;
    private final NamingConfiguration namingConfiguration;

    public ExtraTableConfigurer(AbstractIdentification<C, I> identification, ConfiguredRelationalPersister<C, I> mainPersister, Map<String, Set<EmbeddableMappingConfiguration.Linkage>> extraTableLinkages, ColumnBinderRegistry columnBinderRegistry, NamingConfiguration namingConfiguration) {
        this.identification = identification;
        this.mainPersister = mainPersister;
        this.extraTableLinkages = extraTableLinkages;
        this.columnBinderRegistry = columnBinderRegistry;
        this.namingConfiguration = namingConfiguration;
        this.mainTablePrimaryKey = mainPersister.getMapping().getTargetTable().getPrimaryKey();
    }

    public void configure(Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        KeepOrderSet extraTablePersisters = new KeepOrderSet();
        this.extraTableLinkages.forEach((arg_0, arg_1) -> this.lambda$configure$0((Set)extraTablePersisters, dialect, connectionConfiguration, arg_0, arg_1));
        extraTablePersisters.forEach(extraTablePersister -> {
            this.mainPersister.addInsertListener(new AfterInsertSupport(arg_0 -> ((SimpleRelationalEntityPersister)extraTablePersister).insert(arg_0), Function.identity()));
            this.mainPersister.addUpdateListener(new AfterUpdateSupport((arg_0, arg_1) -> ((SimpleRelationalEntityPersister)extraTablePersister).update(arg_0, arg_1), Function.identity()));
            this.mainPersister.addUpdateByIdListener(new AfterUpdateByIdSupport(arg_0 -> ((SimpleRelationalEntityPersister)extraTablePersister).updateById(arg_0), Function.identity()));
            this.mainPersister.addDeleteListener(new BeforeDeleteSupport(arg_0 -> ((SimpleRelationalEntityPersister)extraTablePersister).delete(arg_0), Function.identity()));
            this.mainPersister.addDeleteByIdListener(new BeforeDeleteByIdSupport(arg_0 -> ((SimpleRelationalEntityPersister)extraTablePersister).deleteById(arg_0), Function.identity()));
        });
    }

    private <EXTRATABLE extends Table<EXTRATABLE>> DefaultEntityMapping<C, I, EXTRATABLE> buildExtraTableClassMapping(String extraTableName, Set<EmbeddableMappingConfiguration.Linkage> linkages) {
        Table extraTable = new Table(extraTableName);
        this.addPrimaryKey(extraTable);
        this.addForeignKey(extraTable);
        FluentEmbeddableMappingConfigurationSupport fluentEmbeddableMappingConfigurationSupport = new FluentEmbeddableMappingConfigurationSupport(this.mainPersister.getClassToPersist());
        fluentEmbeddableMappingConfigurationSupport.getPropertiesMapping().addAll(linkages);
        EmbeddableMappingBuilder embeddableMappingBuilder = new EmbeddableMappingBuilder(fluentEmbeddableMappingConfigurationSupport, extraTable, this.columnBinderRegistry, this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getIndexNamingStrategy());
        EmbeddableMapping build = embeddableMappingBuilder.build(true);
        DefaultEntityMapping extratableEntityMapping = MainPersisterStep.createEntityMapping(false, extraTable, build.getMapping(), build.getReadonlyMapping(), build.getReadConverters(), build.getWriteConverters(), new ValueAccessPointSet(), this.identification, this.mainPersister.getClassToPersist(), null);
        this.mainPersister.getEntityJoinTree().addMergeJoin("ROOT", new EntityMerger.EntityMergerAdapter(extratableEntityMapping), this.mainPersister.getMainTable().getPrimaryKey(), extraTable.getPrimaryKey(), EntityJoinTree.JoinType.OUTER);
        return extratableEntityMapping;
    }

    private void addPrimaryKey(Table table) {
        PrimaryKeyPropagationStep.propagatePrimaryKey(this.mainTablePrimaryKey, Arrays.asSet((Object[])new Table[]{table}));
    }

    private void addForeignKey(Table table) {
        PrimaryKeyPropagationStep.applyForeignKeys(this.mainTablePrimaryKey, this.namingConfiguration.getForeignKeyNamingStrategy(), Arrays.asSet((Object[])new Table[]{table}));
    }

    private /* synthetic */ void lambda$configure$0(Set extraTablePersisters, Dialect dialect, ConnectionConfiguration connectionConfiguration, String extraTableName, Set linkages) {
        DefaultEntityMapping extratableEntityMapping = this.buildExtraTableClassMapping(extraTableName, linkages);
        extraTablePersisters.add(new SimpleRelationalEntityPersister(extratableEntityMapping, dialect, connectionConfiguration));
    }
}

