/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.model;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;

public class Car
extends Vehicle {
    private String model;
    private Radio radio;
    private Set<String> plates = new HashSet<String>();

    public Car() {
    }

    public Car(Long id) {
        this(new PersistableIdentifier<Long>(id));
    }

    public Car(Identifier<Long> id) {
        super(id);
    }

    public Car(Long id, String model) {
        this(new PersistableIdentifier<Long>(id), model);
    }

    public Car(Identifier<Long> id, String model) {
        super(id);
        this.setModel(model);
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Radio getRadio() {
        return this.radio;
    }

    public void setRadio(Radio radio) {
        this.radio = radio;
        radio.setCar(this);
    }

    public Set<String> getPlates() {
        return this.plates;
    }

    public void addPlate(String plateNumber) {
        this.plates.add(plateNumber);
    }

    public static class Radio
    extends AbstractRadio {
        private String serialNumber;
        private String model;
        private boolean persisted;

        private Radio() {
        }

        public Radio(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public String getModel() {
            return this.model;
        }

        public Radio setModel(String model) {
            this.model = model;
            return this;
        }

        public boolean isPersisted() {
            return this.persisted;
        }

        public void markAsPersisted() {
            this.persisted = true;
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static abstract class AbstractRadio {
        private Car car;

        public Car getCar() {
            return this.car;
        }

        public void setCar(Car car) {
            this.car = car;
        }
    }
}

