/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetomany;

import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.AccessorDefinitionDefiner;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Reflections;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class OneToManyRelation<SRC, TRGT, TRGTID, S extends Collection<TRGT>> {
    private final ReversibleAccessor<SRC, S> collectionProvider;
    private final BooleanSupplier sourceTablePerClassPolymorphic;
    private final EntityMappingConfigurationProvider<TRGT, TRGTID> targetMappingConfiguration;
    private final MappedByConfiguration<TRGT, SRC> mappedByConfiguration;
    @Nullable
    private SerializableBiConsumer<TRGT, SRC> reverseLink;
    private CascadeOptions.RelationMode relationMode = CascadeOptions.RelationMode.ALL;
    @Nullable
    private Supplier<S> collectionFactory;
    private boolean fetchSeparately;
    @Nullable
    private Column indexingColumn;
    @Nullable
    private String indexingColumnName;
    private boolean ordered = false;

    public OneToManyRelation(ReversibleAccessor<SRC, S> collectionProvider, BooleanSupplier sourceTablePerClassPolymorphic, EntityMappingConfigurationProvider<? super TRGT, TRGTID> targetMappingConfiguration) {
        this.collectionProvider = collectionProvider;
        this.sourceTablePerClassPolymorphic = sourceTablePerClassPolymorphic;
        this.targetMappingConfiguration = targetMappingConfiguration;
        this.mappedByConfiguration = new MappedByConfiguration();
    }

    private OneToManyRelation(ReversibleAccessor<SRC, S> collectionProvider, BooleanSupplier sourceTablePerClassPolymorphic, EntityMappingConfigurationProvider<? super TRGT, TRGTID> targetMappingConfiguration, MappedByConfiguration<TRGT, ?> mappedByConfiguration) {
        this.collectionProvider = collectionProvider;
        this.sourceTablePerClassPolymorphic = sourceTablePerClassPolymorphic;
        this.targetMappingConfiguration = targetMappingConfiguration;
        this.mappedByConfiguration = mappedByConfiguration;
    }

    public ReversibleAccessor<SRC, S> getCollectionProvider() {
        return this.collectionProvider;
    }

    public boolean isSourceTablePerClassPolymorphic() {
        return this.sourceTablePerClassPolymorphic.getAsBoolean();
    }

    public EntityMappingConfiguration<TRGT, TRGTID> getTargetMappingConfiguration() {
        return this.targetMappingConfiguration.getConfiguration();
    }

    public boolean isTargetTablePerClassPolymorphic() {
        return this.getTargetMappingConfiguration().getPolymorphismPolicy() instanceof PolymorphismPolicy.TablePerClassPolymorphism;
    }

    public void setReverseGetter(SerializableFunction<TRGT, ? super SRC> reverseGetter) {
        this.mappedByConfiguration.setReverseGetter(reverseGetter);
    }

    public void setReverseSetter(SerializableBiConsumer<TRGT, ? super SRC> reverseSetter) {
        this.mappedByConfiguration.setReverseSetter(reverseSetter);
    }

    @Nullable
    public Mutator<TRGT, SRC> giveReverseSetter() {
        return this.mappedByConfiguration.giveReverseSetter();
    }

    @Nullable
    public <O> Column<Table<?>, O> getReverseColumn() {
        return this.mappedByConfiguration.getReverseColumn();
    }

    public void setReverseColumn(Column<?, ?> reverseColumn) {
        this.mappedByConfiguration.setReverseColumn(reverseColumn);
    }

    @Nullable
    public String getReverseColumnName() {
        return this.mappedByConfiguration.getReverseColumnName();
    }

    public void setReverseColumn(@Nullable String reverseColumnName) {
        this.mappedByConfiguration.setReverseColumnName(reverseColumnName);
    }

    public ValueAccessPointMap<SRC, Column<Table<?>, Object>> getForeignKeyColumnMapping() {
        return this.mappedByConfiguration.getForeignKeyColumnMapping();
    }

    public ValueAccessPointMap<SRC, String> getForeignKeyNameMapping() {
        return this.mappedByConfiguration.getForeignKeyNameMapping();
    }

    @Nullable
    public SerializableBiConsumer<TRGT, SRC> getReverseLink() {
        return this.reverseLink;
    }

    public void setReverseLink(SerializableBiConsumer<TRGT, SRC> reverseLink) {
        this.reverseLink = reverseLink;
    }

    public CascadeOptions.RelationMode getRelationMode() {
        return this.relationMode;
    }

    public void setRelationMode(CascadeOptions.RelationMode relationMode) {
        this.relationMode = relationMode;
    }

    public boolean isOwnedByReverseSide() {
        return this.mappedByConfiguration.isNotEmpty();
    }

    @Nullable
    public Supplier<S> getCollectionFactory() {
        return this.collectionFactory;
    }

    public void setCollectionFactory(Supplier<S> collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    public boolean isFetchSeparately() {
        return this.fetchSeparately;
    }

    public void setFetchSeparately(boolean fetchSeparately) {
        this.fetchSeparately = fetchSeparately;
    }

    public void fetchSeparately() {
        this.setFetchSeparately(true);
    }

    public void setIndexingColumn(Column<?, Integer> indexingColumn) {
        this.ordered();
        this.indexingColumn = indexingColumn;
    }

    @Nullable
    public <T extends Table<T>> Column<T, Integer> getIndexingColumn() {
        return this.indexingColumn;
    }

    public void setIndexingColumnName(String columnName) {
        this.ordered();
        this.indexingColumnName = columnName;
    }

    @Nullable
    public String getIndexingColumnName() {
        return this.indexingColumnName;
    }

    public void ordered() {
        this.ordered = true;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public <C> OneToManyRelation<C, TRGT, TRGTID, S> embedInto(final Accessor<C, SRC> accessor, final Class<SRC> embeddedType) {
        AccessorChain slidedTargetProvider = new AccessorChain(new Accessor[]{accessor, this.collectionProvider});
        slidedTargetProvider.setNullValueHandler((AccessorChain.NullValueHandler)new AccessorChain.ValueInitializerOnNullValue(){

            protected <T> T newInstance(Accessor<?, T> segmentAccessor, Class<T> valueType) {
                if (segmentAccessor == accessor) {
                    return (T)Reflections.newInstance((Class)embeddedType);
                }
                return (T)super.newInstance(segmentAccessor, valueType);
            }
        });
        MappedByConfiguration<TRGT, C> slidedMappedByConfiguration = this.mappedByConfiguration.embedInto(accessor);
        OneToManyRelation<SRC, TRGT, TRGTID, S> result = new OneToManyRelation<SRC, TRGT, TRGTID, S>(slidedTargetProvider, this::isSourceTablePerClassPolymorphic, this.targetMappingConfiguration, slidedMappedByConfiguration);
        result.setRelationMode(this.getRelationMode());
        result.setFetchSeparately(this.isFetchSeparately());
        return result;
    }

    private static class SlidedMappedByConfiguration<C, TRGT, SRC>
    extends MappedByConfiguration<TRGT, C> {
        private final Mutator<TRGT, C> effectiveReverseMutator;

        public SlidedMappedByConfiguration(Accessor<C, SRC> accessor, MappedByConfiguration<TRGT, SRC> mappedByConfiguration) {
            this.reverseColumn = mappedByConfiguration.reverseColumn;
            this.reverseColumnName = mappedByConfiguration.reverseColumnName;
            this.foreignKeyColumnMapping.putAll(mappedByConfiguration.foreignKeyColumnMapping);
            this.foreignKeyNameMapping.putAll(mappedByConfiguration.foreignKeyNameMapping);
            if (mappedByConfiguration.reverseGetter != null) {
                AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(accessor);
                AccessorDefinition reverseSetterDefinition = AccessorDefinition.giveDefinition(mappedByConfiguration.reverseGetter);
                SlidedMutator<C> reverseSetter = new SlidedMutator<C>(accessor, new AccessorDefinition(accessorDefinition.getDeclaringClass(), accessorDefinition.getName() + "." + reverseSetterDefinition.getName(), reverseSetterDefinition.getMemberType()), mappedByConfiguration.reverseGetter.toMutator());
                this.effectiveReverseMutator = reverseSetter;
            } else if (mappedByConfiguration.reverseSetter != null) {
                AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(accessor);
                AccessorDefinition reverseSetterDefinition = AccessorDefinition.giveDefinition(mappedByConfiguration.reverseSetter);
                SlidedMutator<C> reverseSetter = new SlidedMutator<C>(accessor, new AccessorDefinition(accessorDefinition.getDeclaringClass(), accessorDefinition.getName() + "." + reverseSetterDefinition.getName(), reverseSetterDefinition.getMemberType()), mappedByConfiguration.reverseSetter);
                this.effectiveReverseMutator = reverseSetter;
            } else {
                this.effectiveReverseMutator = null;
            }
        }

        @Override
        public Mutator<TRGT, C> giveReverseSetter() {
            return this.effectiveReverseMutator;
        }

        @Override
        public boolean isNotEmpty() {
            return this.effectiveReverseMutator != null || super.isNotEmpty();
        }

        private class SlidedMutator<C>
        implements Mutator<TRGT, C>,
        AccessorDefinitionDefiner<TRGT> {
            private final Accessor<C, SRC> accessor;
            private final AccessorDefinition accessorDefinition;
            private final Mutator<TRGT, SRC> reverseSetter;

            public SlidedMutator(Accessor<C, SRC> accessor, AccessorDefinition accessorDefinition, Mutator<TRGT, SRC> reverseSetter) {
                this.accessor = accessor;
                this.accessorDefinition = accessorDefinition;
                this.reverseSetter = reverseSetter;
            }

            public void set(TRGT trgt, C c) {
                Object src = this.accessor.get(c);
                this.reverseSetter.set(trgt, src);
            }

            public AccessorDefinition asAccessorDefinition() {
                return this.accessorDefinition;
            }
        }
    }

    private static class MappedByConfiguration<TRGT, SRC> {
        protected ReversibleAccessor<TRGT, SRC> reverseGetter;
        protected Mutator<TRGT, SRC> reverseSetter;
        protected Column<Table<?>, Object> reverseColumn;
        protected String reverseColumnName;
        protected final ValueAccessPointMap<SRC, Column<Table<?>, Object>> foreignKeyColumnMapping = new ValueAccessPointMap();
        protected final ValueAccessPointMap<SRC, String> foreignKeyNameMapping = new ValueAccessPointMap();

        private MappedByConfiguration() {
        }

        <C> MappedByConfiguration<TRGT, C> embedInto(Accessor<C, SRC> accessor) {
            return new SlidedMappedByConfiguration(accessor, this);
        }

        public void setReverseGetter(SerializableFunction<TRGT, SRC> reverseGetter) {
            this.reverseGetter = Accessors.accessor(reverseGetter);
        }

        public void setReverseSetter(SerializableBiConsumer<TRGT, SRC> reverseSetter) {
            this.reverseSetter = Accessors.mutator(reverseSetter);
        }

        public Mutator<TRGT, SRC> giveReverseSetter() {
            if (this.reverseGetter != null) {
                return this.reverseGetter.toMutator();
            }
            if (this.reverseSetter != null) {
                return this.reverseSetter;
            }
            return null;
        }

        public String getReverseColumnName() {
            return this.reverseColumnName;
        }

        public void setReverseColumnName(String reverseColumnName) {
            this.reverseColumnName = reverseColumnName;
        }

        public Column<Table<?>, ?> getReverseColumn() {
            return this.reverseColumn;
        }

        public void setReverseColumn(Column<?, ?> reverseColumn) {
            this.reverseColumn = reverseColumn;
        }

        public ValueAccessPointMap<SRC, Column<Table<?>, Object>> getForeignKeyColumnMapping() {
            return this.foreignKeyColumnMapping;
        }

        public ValueAccessPointMap<SRC, String> getForeignKeyNameMapping() {
            return this.foreignKeyNameMapping;
        }

        public boolean isNotEmpty() {
            return this.reverseSetter != null || this.reverseGetter != null || this.reverseColumn != null || !this.foreignKeyColumnMapping.isEmpty() || !this.foreignKeyNameMapping.isEmpty();
        }
    }
}

