/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.Map;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.NamingConfigurationCollector;
import org.codefilarete.stalactite.engine.configurer.builder.AlreadyAssignedMarkerStep;
import org.codefilarete.stalactite.engine.configurer.builder.BuildLifeCycleListener;
import org.codefilarete.stalactite.engine.configurer.builder.IdentificationStep;
import org.codefilarete.stalactite.engine.configurer.builder.IdentifierManagerStep;
import org.codefilarete.stalactite.engine.configurer.builder.InheritanceMappingStep;
import org.codefilarete.stalactite.engine.configurer.builder.MainPersisterStep;
import org.codefilarete.stalactite.engine.configurer.builder.ParentPersistersStep;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.builder.PolymorphismStep;
import org.codefilarete.stalactite.engine.configurer.builder.PrimaryKeyPropagationStep;
import org.codefilarete.stalactite.engine.configurer.builder.PrimaryKeyStep;
import org.codefilarete.stalactite.engine.configurer.builder.RelationsStep;
import org.codefilarete.stalactite.engine.configurer.builder.TableLookupStep;
import org.codefilarete.stalactite.engine.configurer.builder.TableMappingStep;
import org.codefilarete.stalactite.engine.configurer.builder.VersioningStep;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;

public class PersisterBuilderPipeline<C, I> {
    private final TableLookupStep<C, I> tableLookupStep;
    private final TableMappingStep<C, I> tableMappingStep;
    private final IdentificationStep<C, I> identificationStep;
    private final InheritanceMappingStep<C, I> inheritanceMappingStep;
    private final PrimaryKeyStep<C, I> primaryKeyStep;
    private final PrimaryKeyPropagationStep<C, I> primaryKeyPropagationStep;
    private final IdentifierManagerStep<C, I> identifierManagerStep;
    private final MainPersisterStep<C, I> mainPersisterStep;
    private final RelationsStep<C, I> relationsStep;
    private final PolymorphismStep<C, I> polymorphismStep;
    private final AlreadyAssignedMarkerStep<C, I> alreadyAssignedMarkerStep;
    private final ParentPersistersStep<C, I> parentPersistersStep;
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final VersioningStep<C, I> versioningStep;
    private final PersisterRegistry persisterRegistry;
    private PersisterBuilderContext persisterBuilderContext;

    public PersisterBuilderPipeline(Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry) {
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.tableLookupStep = new TableLookupStep();
        this.tableMappingStep = new TableMappingStep();
        this.identificationStep = new IdentificationStep();
        this.inheritanceMappingStep = new InheritanceMappingStep();
        this.primaryKeyStep = new PrimaryKeyStep();
        this.primaryKeyPropagationStep = new PrimaryKeyPropagationStep();
        this.identifierManagerStep = new IdentifierManagerStep();
        this.mainPersisterStep = new MainPersisterStep();
        this.relationsStep = new RelationsStep();
        this.polymorphismStep = new PolymorphismStep();
        this.alreadyAssignedMarkerStep = new AlreadyAssignedMarkerStep();
        this.parentPersistersStep = new ParentPersistersStep();
        this.versioningStep = new VersioningStep();
        this.persisterRegistry = persisterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfiguredRelationalPersister<C, I> build(EntityMappingConfiguration<C, I> entityMappingConfiguration) {
        this.persisterBuilderContext = PersisterBuilderContext.CURRENT.get();
        boolean isInitiator = false;
        if (this.persisterBuilderContext == null) {
            this.persisterBuilderContext = new PersisterBuilderContext(this.persisterRegistry);
            PersisterBuilderContext.CURRENT.set(this.persisterBuilderContext);
            isInitiator = true;
        }
        try {
            ConfiguredRelationalPersister<C, I> result = this.doBuild(entityMappingConfiguration);
            this.persisterRegistry.addPersister(result);
            if (isInitiator) {
                this.persisterBuilderContext.getBuildLifeCycleListeners().forEach(BuildLifeCycleListener::afterBuild);
                this.persisterBuilderContext.getBuildLifeCycleListeners().forEach(BuildLifeCycleListener::afterAllBuild);
            }
            ConfiguredRelationalPersister<C, I> configuredRelationalPersister = result;
            return configuredRelationalPersister;
        }
        finally {
            if (isInitiator) {
                PersisterBuilderContext.CURRENT.remove();
            }
        }
    }

    private ConfiguredRelationalPersister<C, I> doBuild(EntityMappingConfiguration<C, I> entityMappingConfiguration) {
        NamingConfigurationCollector namingConfigurationCollector = new NamingConfigurationCollector(entityMappingConfiguration);
        NamingConfiguration namingConfiguration = namingConfigurationCollector.collect();
        Table table = this.tableLookupStep.lookupForTable(entityMappingConfiguration, namingConfiguration.getTableNamingStrategy());
        Map<EntityMappingConfiguration, Table> entityMappingConfigurationTables = this.tableMappingStep.mapEntityConfigurationToTable(entityMappingConfiguration, table, namingConfiguration.getTableNamingStrategy());
        AbstractIdentification<C, I> identification = this.identificationStep.determineIdentification(entityMappingConfiguration);
        InheritanceMappingStep.MappingPerTable<C> inheritanceMappingPerTable = this.inheritanceMappingStep.collectPropertiesMappingFromInheritance(entityMappingConfiguration, entityMappingConfigurationTables, this.dialect.getColumnBinderRegistry(), namingConfiguration.getColumnNamingStrategy(), namingConfiguration.getIndexNamingStrategy());
        PrimaryKey primaryKey = this.primaryKeyStep.addIdentifyingPrimarykey(identification, entityMappingConfigurationTables, this.dialect.getColumnBinderRegistry(), namingConfiguration.getColumnNamingStrategy(), namingConfiguration.getIndexNamingStrategy());
        this.primaryKeyPropagationStep.propagate(primaryKey, inheritanceMappingPerTable, namingConfiguration.getForeignKeyNamingStrategy());
        this.identifierManagerStep.applyIdentifierManager(identification, inheritanceMappingPerTable, identification.getIdAccessor(), this.dialect, this.connectionConfiguration);
        SimpleRelationalEntityPersister mainPersister = this.mainPersisterStep.buildMainPersister(entityMappingConfiguration, identification, inheritanceMappingPerTable, namingConfiguration, this.dialect, this.connectionConfiguration);
        this.relationsStep.configureRelations(mainPersister, inheritanceMappingPerTable, this.persisterBuilderContext, namingConfiguration, this.dialect, this.connectionConfiguration);
        ConfiguredRelationalPersister<C, I> result = this.polymorphismStep.eventuallyTransformToPolymorphicPersister(mainPersister, entityMappingConfiguration, identification, (InheritanceMappingStep.Mapping)Iterables.first(inheritanceMappingPerTable.getMappings()), namingConfiguration, this.dialect, this.connectionConfiguration, this.persisterBuilderContext);
        this.alreadyAssignedMarkerStep.handleAlreadyAssignedMarker(identification, result);
        this.parentPersistersStep.buildParentPersisters(mainPersister, identification, inheritanceMappingPerTable, this.dialect, this.connectionConfiguration);
        this.versioningStep.handleVersioningStrategy(entityMappingConfiguration.getOptimisticLockOption(), mainPersister);
        return result;
    }
}

