/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformer;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.test.DatabaseIntegrationTest;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.function.Functions;
import org.junit.jupiter.api.Test;

public abstract class PersistenceContextITTest
extends DatabaseIntegrationTest {
    protected abstract Dialect createDialect();

    @Test
    void select() throws SQLException {
        PersistenceContext testInstance = new PersistenceContext(this.connectionProvider, this.createDialect());
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", Integer.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        DDLDeployer ddlDeployer = new DDLDeployer(testInstance);
        ddlDeployer.getDdlGenerator().addTables(totoTable, new Table[0]);
        ddlDeployer.deployDDL();
        Connection connection = testInstance.getConnectionProvider().giveConnection();
        connection.prepareStatement("insert into Toto(id, name) values (1, 'Hello')").execute();
        connection.prepareStatement("insert into Toto(id, name) values (2, 'World')").execute();
        List records = testInstance.select(Toto::new, selectMapping -> selectMapping.add(name, Toto::setName));
        ((ListAssert)Assertions.assertThat((List)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(-1, "Hello"), new Toto(-1, "World")});
        records = testInstance.select(Toto::new, id);
        ((ListAssert)Assertions.assertThat((List)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(1), new Toto(2)});
        records = testInstance.select(Toto::new, id, name);
        ((ListAssert)Assertions.assertThat((List)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(1, "Hello"), new Toto(2, "World")});
        records = testInstance.select(Toto::new, id, select -> select.add(name, Toto::setName).add(name, Toto::setName2));
        Assertions.assertThat((List)records).extracting(Toto::getName2).containsExactlyInAnyOrder((Object[])new String[]{"Hello", "World"});
        records = testInstance.select(Toto::new, id, select -> select.add(name, Toto::setName), where -> where.and(id, (ConditionalOperator)Operators.eq((Object)1)));
        ((ListAssert)Assertions.assertThat((List)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(1, "Hello")});
        records = testInstance.select(Toto::new, id, select -> select.add(name, Toto::setName), where -> where.and(id, (ConditionalOperator)Operators.eq((Object)2)));
        ((ListAssert)Assertions.assertThat((List)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(2, "World")});
    }

    @Test
    void select_columnTypeIsRegisteredInDialect() throws SQLException {
        Dialect dialect = this.createDialect();
        PersistenceContext testInstance = new PersistenceContext(this.connectionProvider, dialect);
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", Integer.TYPE);
        Column dummyProp = totoTable.addColumn("dummyProp", Wrapper.class);
        dialect.getColumnBinderRegistry().register(Wrapper.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.STRING_BINDER, Wrapper::new, Wrapper::getDelegate)));
        dialect.getSqlTypeRegistry().put(Wrapper.class, "varchar(255)");
        DDLDeployer ddlDeployer = new DDLDeployer(testInstance);
        ddlDeployer.getDdlGenerator().addTables(totoTable, new Table[0]);
        ddlDeployer.deployDDL();
        Connection connection = this.connectionProvider.giveConnection();
        connection.prepareStatement("insert into Toto(id, dummyProp) values (1, 'Hello')").execute();
        connection.prepareStatement("insert into Toto(id, dummyProp) values (2, 'World')").execute();
        List records = testInstance.select(Toto::new, id, dummyProp);
        ((ListAssert)Assertions.assertThat((List)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(1, new Wrapper("Hello")), new Toto(2, new Wrapper("World"))});
        records = testInstance.select(Toto::new, id, select -> select.add(dummyProp, Toto::setDummyWrappedProp));
        Assertions.assertThat((List)records).extracting(Functions.chain(Toto::getDummyWrappedProp, Wrapper::getDelegate)).containsExactlyInAnyOrder((Object[])new String[]{"Hello", "World"});
    }

    @Test
    void select_columnIsRegisteredInDialect_butNotItsType() throws SQLException {
        Dialect dialect = this.createDialect();
        PersistenceContext testInstance = new PersistenceContext(this.connectionProvider, dialect);
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", Integer.TYPE);
        Column dummyProp = totoTable.addColumn("dummyProp", Wrapper.class);
        dialect.getColumnBinderRegistry().register(dummyProp, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.STRING_BINDER, Wrapper::new, Wrapper::getDelegate)));
        dialect.getSqlTypeRegistry().put(dummyProp, "varchar(255)");
        DDLDeployer ddlDeployer = new DDLDeployer(testInstance);
        ddlDeployer.getDdlGenerator().addTables(totoTable, new Table[0]);
        ddlDeployer.deployDDL();
        Connection connection = testInstance.getConnectionProvider().giveConnection();
        connection.prepareStatement("insert into Toto(id, dummyProp) values (1, 'Hello')").execute();
        connection.prepareStatement("insert into Toto(id, dummyProp) values (2, 'World')").execute();
        List records = testInstance.select(Toto::new, id, dummyProp);
        ((ListAssert)Assertions.assertThat((List)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(1, new Wrapper("Hello")), new Toto(2, new Wrapper("World"))});
        records = testInstance.select(Toto::new, id, select -> select.add(dummyProp, Toto::setDummyWrappedProp));
        Assertions.assertThat((List)records).extracting(Functions.chain(Toto::getDummyWrappedProp, Wrapper::getDelegate)).containsExactlyInAnyOrder((Object[])new String[]{"Hello", "World"});
    }

    @Test
    void newQuery() throws SQLException {
        PersistenceContext testInstance = new PersistenceContext(this.connectionProvider, this.createDialect());
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", Integer.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        DDLDeployer ddlDeployer = new DDLDeployer(testInstance);
        ddlDeployer.getDdlGenerator().addTables(totoTable, new Table[0]);
        ddlDeployer.deployDDL();
        Connection connection = testInstance.getConnectionProvider().giveConnection();
        connection.prepareStatement("insert into Toto(id, name) values (1, 'Hello')").execute();
        connection.prepareStatement("insert into Toto(id, name) values (2, 'World')").execute();
        Set records = (Set)testInstance.newQuery((QueryProvider)QueryEase.select((Selectable)id, (Selectable[])new Selectable[]{name}).from((Fromable)totoTable), Toto.class).mapKey(Toto::new, id, name).execute(Accumulators.toSet());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(1, "Hello"), new Toto(2, "World")});
    }

    @Test
    void newQuery_withToOneRelation() throws SQLException {
        PersistenceContext testInstance = new PersistenceContext(this.connectionProvider, this.createDialect());
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", Integer.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        Table tataTable = new Table("Tata");
        Column tataName = tataTable.addColumn("name", String.class);
        Column totoId = tataTable.addColumn("totoId", Integer.TYPE);
        DDLDeployer ddlDeployer = new DDLDeployer(testInstance);
        ddlDeployer.getDdlGenerator().addTables(totoTable, new Table[]{tataTable});
        ddlDeployer.deployDDL();
        Connection connection = this.connectionProvider.giveConnection();
        connection.prepareStatement("insert into Toto(id, name) values (1, 'Hello')").execute();
        connection.prepareStatement("insert into Tata(totoId, name) values (1, 'World')").execute();
        connection.prepareStatement("insert into Toto(id, name) values (2, 'Bonjour')").execute();
        connection.prepareStatement("insert into Tata(totoId, name) values (2, 'Tout le monde')").execute();
        Set records = (Set)testInstance.newQuery((QueryProvider)((Query.FluentSelectClause)QueryEase.select((Selectable)id, (Selectable[])new Selectable[]{name}).add((Selectable)tataName, "tataName")).from((Fromable)totoTable).innerJoin((JoinLink)id, (JoinLink)totoId), Toto.class).mapKey(Toto::new, id, name).map(Toto::setTata, new ResultSetRowTransformer(Tata.class, "tataName", DefaultResultSetReaders.STRING_READER, Tata::new)).execute(Accumulators.toSet());
        Toto expectedToto1 = new Toto(1, "Hello");
        expectedToto1.setTata(new Tata("World"));
        Toto expectedToto2 = new Toto(2, "Bonjour");
        expectedToto2.setTata(new Tata("Tout le monde"));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{expectedToto1, expectedToto2});
    }

    @Test
    void newQuery_withToManyRelation() throws SQLException {
        PersistenceContext testInstance = new PersistenceContext(this.connectionProvider, this.createDialect());
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", Integer.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        Table tataTable = new Table("Tata");
        Column tataName = tataTable.addColumn("name", String.class);
        Column totoId = tataTable.addColumn("totoId", Integer.TYPE);
        DDLDeployer ddlDeployer = new DDLDeployer(testInstance);
        ddlDeployer.getDdlGenerator().addTables(totoTable, new Table[]{tataTable});
        ddlDeployer.deployDDL();
        Connection connection = this.connectionProvider.giveConnection();
        connection.prepareStatement("insert into Toto(id, name) values (1, 'Hello')").execute();
        connection.prepareStatement("insert into Tata(totoId, name) values (1, 'World')").execute();
        connection.prepareStatement("insert into Tata(totoId, name) values (1, 'Tout le monde')").execute();
        connection.prepareStatement("insert into Toto(id, name) values (2, 'Bonjour')").execute();
        BeanRelationFixer tataCombiner = BeanRelationFixer.of(Toto::setTatas, Toto::getTatas, LinkedHashSet::new);
        Set records = (Set)testInstance.newQuery((QueryProvider)((Query.FluentSelectClause)QueryEase.select((Selectable)id, (Selectable[])new Selectable[]{name}).add((Selectable)tataName, "tataName")).from((Fromable)totoTable).leftOuterJoin((JoinLink)id, (JoinLink)totoId), Toto.class).mapKey(Toto::new, id, name).map(tataCombiner, new ResultSetRowTransformer(Tata.class, "tataName", DefaultResultSetReaders.STRING_READER, Tata::new)).execute(Accumulators.toSet());
        Toto expectedToto1 = new Toto(1, "Hello");
        expectedToto1.setTatas(Arrays.asHashSet((Object[])new Tata[]{new Tata("World"), new Tata("Tout le monde")}));
        Toto expectedToto2 = new Toto(2, "Bonjour");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{expectedToto1, expectedToto2});
    }

    private static class Tata {
        private String name;

        public Tata(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return Strings.footPrint((Object)this, (Function[])new Function[]{Tata::getName});
        }
    }

    private static class Wrapper {
        private final String delegate;

        public Wrapper(String delegate) {
            this.delegate = delegate;
        }

        public String getDelegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.footPrint((Object)this, (Function[])new Function[]{Wrapper::getDelegate});
        }
    }

    private static class Toto {
        private final int id;
        private String name;
        private String name2;
        private Wrapper dummyWrappedProp;
        private Tata tata;
        private Set<Tata> tatas;

        public Toto() {
            this(-1);
        }

        public Toto(int id) {
            this(id, (String)null);
        }

        public Toto(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public Toto(int id, Wrapper dummyProp) {
            this.id = id;
            this.dummyWrappedProp = dummyProp;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName2() {
            return this.name2;
        }

        public void setName2(String name2) {
            this.name2 = name2;
        }

        public Tata getTata() {
            return this.tata;
        }

        public Toto setTata(Tata tata) {
            this.tata = tata;
            return this;
        }

        public Set<Tata> getTatas() {
            return this.tatas;
        }

        public Toto setTatas(Set<Tata> tatas) {
            this.tatas = tatas;
            return this;
        }

        public String toString() {
            return Strings.footPrint((Object)this, (Function[])new Function[]{Toto::getId, Toto::getName, Toto::getDummyWrappedProp, Toto::getTata, Toto::getTatas});
        }

        public Wrapper getDummyWrappedProp() {
            return this.dummyWrappedProp;
        }

        public void setDummyWrappedProp(Wrapper dummyWrappedProp) {
            this.dummyWrappedProp = dummyWrappedProp;
        }
    }
}

