/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import org.codefilarete.stalactite.engine.VersioningStrategy;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.AbstractRevertOnRollbackMVCC;
import org.codefilarete.stalactite.engine.runtime.InsertExecutor;
import org.codefilarete.stalactite.engine.runtime.WriteExecutor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.RollbackObserver;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.PreparedUpdate;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.ArrayIterator;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.ReadOnlyIterator;
import org.codefilarete.tool.function.Predicates;

public class UpdateExecutor<C, I, T extends Table<T>>
extends WriteExecutor<C, I, T>
implements org.codefilarete.stalactite.engine.UpdateExecutor<C> {
    private OptimisticLockManager<C, T> optimisticLockManager = OptimisticLockManager.NOOP_OPTIMISTIC_LOCK_MANAGER;
    private SQLOperation.SQLOperationListener<Mapping.UpwhereColumn<T>> operationListener;

    public UpdateExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        super(mappingStrategy, connectionConfiguration, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
    }

    public <V> void setVersioningStrategy(VersioningStrategy<C, V> versioningStrategy) {
        if (!(this.getConnectionProvider() instanceof RollbackObserver)) {
            throw new UnsupportedOperationException("Version control is only supported for " + Reflections.toString(ConnectionProvider.class) + " that implements " + Reflections.toString(RollbackObserver.class));
        }
        Column versionColumn = this.getMapping().getPropertyToColumn().get(versioningStrategy.getVersionAccessor());
        this.setOptimisticLockManager(new RevertOnRollbackMVCC(versioningStrategy, versionColumn, (RollbackObserver)this.getConnectionProvider()));
    }

    public void setOptimisticLockManager(OptimisticLockManager<C, T> optimisticLockManager) {
        this.optimisticLockManager = optimisticLockManager;
    }

    public void setOperationListener(SQLOperation.SQLOperationListener<Mapping.UpwhereColumn<T>> listener) {
        this.operationListener = listener;
    }

    private WriteOperation<Mapping.UpwhereColumn<T>> newWriteOperation(SQLStatement<Mapping.UpwhereColumn<T>> statement, ConnectionProvider currentConnectionProvider, LongSupplier expectedRowCount) {
        WriteOperation<Mapping.UpwhereColumn<T>> writeOperation = this.getWriteOperationFactory().createInstance(statement, currentConnectionProvider, expectedRowCount);
        writeOperation.setListener(this.operationListener);
        return writeOperation;
    }

    private WriteOperation<Mapping.UpwhereColumn<T>> newWriteOperation(SQLStatement<Mapping.UpwhereColumn<T>> statement, ConnectionProvider currentConnectionProvider, long expectedRowCount) {
        WriteOperation<Mapping.UpwhereColumn<T>> writeOperation = this.getWriteOperationFactory().createInstance(statement, currentConnectionProvider, expectedRowCount);
        writeOperation.setListener(this.operationListener);
        return writeOperation;
    }

    @Override
    public void updateById(Iterable<? extends C> entities) {
        Set columnsToUpdate = this.getMapping().getUpdatableColumns();
        if (!columnsToUpdate.isEmpty()) {
            PreparedUpdate updateOperation = this.getDmlGenerator().buildUpdate(columnsToUpdate, this.getMapping().getVersionedKeys());
            List entitiesCopy = Iterables.copy(entities);
            WriteOperationFactory.ExpectedBatchedRowCountsSupplier expectedBatchedRowCountsSupplier = new WriteOperationFactory.ExpectedBatchedRowCountsSupplier(entitiesCopy.size(), this.getBatchSize());
            WriteOperation<Mapping.UpwhereColumn<T>> writeOperation = this.newWriteOperation(updateOperation, this.getConnectionProvider(), expectedBatchedRowCountsSupplier);
            WriteExecutor.JDBCBatchingIterator<? extends C> jdbcBatchingIterator = new WriteExecutor.JDBCBatchingIterator<C>(entities, writeOperation, this.getBatchSize());
            while (jdbcBatchingIterator.hasNext()) {
                Object c = jdbcBatchingIterator.next();
                Map updateValues = this.getMapping().getUpdateValues(c, null, true);
                writeOperation.addBatch(updateValues);
            }
        }
    }

    @Override
    public void update(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        Iterable<UpdateListener.UpdatePayload<C, T>> updatePayloads = this.computePayloads(differencesIterable, allColumnsStatement);
        if (!Iterables.isEmpty(updatePayloads)) {
            this.updateDifferences(updatePayloads, allColumnsStatement);
        }
    }

    protected Iterable<UpdateListener.UpdatePayload<C, T>> computePayloads(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        return UpdateListener.computePayloads(differencesIterable, allColumnsStatement, this.getMapping());
    }

    public void updateDifferences(Iterable<UpdateListener.UpdatePayload<C, T>> updatePayloads, boolean allColumnsStatement) {
        if (allColumnsStatement) {
            this.updateMappedColumns(updatePayloads);
        } else {
            this.updateVariousColumns(updatePayloads);
        }
    }

    public void updateVariousColumns(Iterable<? extends UpdateListener.UpdatePayload<C, T>> updatePayloads) {
        List<UpdateListener.UpdatePayload<C, T>> toUpdate = this.collectAndAssertNonNullValues(ReadOnlyIterator.wrap(updatePayloads));
        if (!Iterables.isEmpty(toUpdate)) {
            this.executeUpdate(toUpdate, new JDBCBatchingOperationCache(this.getConnectionProvider(), toUpdate.size()));
        }
    }

    public void updateMappedColumns(Iterable<UpdateListener.UpdatePayload<C, T>> updatePayloads) {
        List<UpdateListener.UpdatePayload<C, T>> toUpdate;
        Set columnsToUpdate = this.getMapping().getUpdatableColumns();
        if (!columnsToUpdate.isEmpty() && !Iterables.isEmpty(toUpdate = this.collectAndAssertNonNullValues(ReadOnlyIterator.wrap(updatePayloads)))) {
            PreparedUpdate preparedUpdate = this.getDmlGenerator().buildUpdate(columnsToUpdate, this.getMapping().getVersionedKeys());
            WriteOperationFactory.ExpectedBatchedRowCountsSupplier expectedBatchedRowCountsSupplier = new WriteOperationFactory.ExpectedBatchedRowCountsSupplier(toUpdate.size(), this.getBatchSize());
            WriteOperation<Mapping.UpwhereColumn<T>> writeOperation = this.newWriteOperation(preparedUpdate, this.getConnectionProvider(), expectedBatchedRowCountsSupplier);
            JDBCBatchingOperation jdbcBatchingOperation = new JDBCBatchingOperation(writeOperation, this.getBatchSize());
            this.executeUpdate(toUpdate, new SingleJDBCBatchingOperation(jdbcBatchingOperation));
        }
    }

    private void executeUpdate(Iterable<UpdateListener.UpdatePayload<C, T>> entitiesPayloads, JDBCBatchingOperationProvider<T> batchingOperationProvider) {
        try {
            DifferenceUpdater differenceUpdater = new DifferenceUpdater(batchingOperationProvider);
            differenceUpdater.update(entitiesPayloads);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error while updating values", e);
        }
    }

    private List<UpdateListener.UpdatePayload<C, T>> collectAndAssertNonNullValues(ReadOnlyIterator<? extends UpdateListener.UpdatePayload<C, T>> updatePayloads) {
        ArrayList result = new ArrayList(this.getBatchSize());
        updatePayloads.forEachRemaining(payload -> {
            if (!payload.getValues().isEmpty()) {
                payload.getValues().forEach((k, v) -> {
                    if (!k.getColumn().isNullable() && v == null) {
                        throw new IllegalArgumentException("Expected non null value for column " + k.getColumn() + " on instance " + payload.getEntities().getLeft());
                    }
                });
                result.add((UpdateListener.UpdatePayload)payload);
            }
        });
        return result;
    }

    private class RevertOnRollbackMVCC<E, V>
    extends AbstractRevertOnRollbackMVCC<E, V, T>
    implements OptimisticLockManager<E, T> {
        private RevertOnRollbackMVCC(VersioningStrategy<E, V> versioningStrategy, Column<T, V> versionColumn, RollbackObserver rollbackObserver) {
            super(versioningStrategy, versionColumn, rollbackObserver);
        }

        @Override
        public void manageLock(E modified, E unmodified, Map<Mapping.UpwhereColumn<T>, Object> updateValues) {
            Object modifiedVersion = this.versioningStrategy.getVersion(modified);
            Object unmodifiedVersion = this.versioningStrategy.getVersion(unmodified);
            if (!Predicates.equalOrNull(modifiedVersion, modifiedVersion)) {
                throw new IllegalStateException();
            }
            this.versioningStrategy.upgrade(modified);
            updateValues.put(new Mapping.UpwhereColumn(this.versionColumn, true), this.versioningStrategy.getVersion(modified));
            updateValues.put(new Mapping.UpwhereColumn(this.versionColumn, false), unmodifiedVersion);
            this.rollbackObserver.addRollbackListener(new InsertExecutor.VersioningStrategyRollbackListener(this.versioningStrategy, modified, modifiedVersion));
        }
    }

    public static interface OptimisticLockManager<E, T extends Table<T>> {
        public static final OptimisticLockManager<?, ?> NOOP_OPTIMISTIC_LOCK_MANAGER = (o1, o2, m) -> {};

        public void manageLock(E var1, E var2, Map<Mapping.UpwhereColumn<T>, Object> var3);
    }

    private class DifferenceUpdater {
        private final JDBCBatchingOperationProvider<T> batchingOperationProvider;

        DifferenceUpdater(JDBCBatchingOperationProvider<T> batchingOperationProvider) {
            this.batchingOperationProvider = batchingOperationProvider;
        }

        private void update(Iterable<UpdateListener.UpdatePayload<C, T>> toUpdate) {
            toUpdate.forEach(p -> {
                Map updateValues = p.getValues();
                UpdateExecutor.this.optimisticLockManager.manageLock(p.getEntities().getLeft(), p.getEntities().getRight(), updateValues);
                JDBCBatchingOperation writeOperation = this.batchingOperationProvider.getJdbcBatchingOperation(updateValues.keySet());
                writeOperation.setValues(updateValues);
            });
            for (JDBCBatchingOperation jdbcBatchingOperation : this.batchingOperationProvider.getJdbcBatchingOperations()) {
                if (jdbcBatchingOperation.stepCounter == 0L) continue;
                jdbcBatchingOperation.executeBatch();
            }
        }
    }

    private class JDBCBatchingOperationCache
    implements JDBCBatchingOperationProvider<T> {
        private final Map<Set<Mapping.UpwhereColumn<T>>, JDBCBatchingOperation<T>> updateOperationCache = new HashMap();
        private final ConnectionProvider connectionProvider;
        private final int expectedRowCount;

        private JDBCBatchingOperationCache(ConnectionProvider connectionProvider, int expectedRowCount) {
            this.connectionProvider = connectionProvider;
            this.expectedRowCount = expectedRowCount;
        }

        @Override
        public JDBCBatchingOperation<T> getJdbcBatchingOperation(Set<Mapping.UpwhereColumn<T>> upwhereColumns) {
            return this.updateOperationCache.computeIfAbsent(upwhereColumns, input -> {
                PreparedUpdate preparedUpdate = UpdateExecutor.this.getDmlGenerator().buildUpdate(Mapping.UpwhereColumn.getUpdateColumns(input), UpdateExecutor.this.getMapping().getVersionedKeys());
                return new JDBCBatchingOperation(UpdateExecutor.this.newWriteOperation(preparedUpdate, this.connectionProvider, this.expectedRowCount), UpdateExecutor.this.getBatchSize());
            });
        }

        @Override
        public Iterable<JDBCBatchingOperation<T>> getJdbcBatchingOperations() {
            return this.updateOperationCache.values();
        }
    }

    private class SingleJDBCBatchingOperation
    implements JDBCBatchingOperationProvider<T>,
    Iterable<JDBCBatchingOperation<T>> {
        private final JDBCBatchingOperation<T> jdbcBatchingOperation;
        private final ArrayIterator<JDBCBatchingOperation<T>> operationIterator;

        private SingleJDBCBatchingOperation(JDBCBatchingOperation<T> jdbcBatchingOperation) {
            this.jdbcBatchingOperation = jdbcBatchingOperation;
            this.operationIterator = new ArrayIterator((Object[])new JDBCBatchingOperation[]{this.jdbcBatchingOperation});
        }

        @Override
        public JDBCBatchingOperation<T> getJdbcBatchingOperation(Set<Mapping.UpwhereColumn<T>> upwhereColumns) {
            return this.jdbcBatchingOperation;
        }

        @Override
        public Iterable<JDBCBatchingOperation<T>> getJdbcBatchingOperations() {
            return this;
        }

        @Override
        public Iterator<JDBCBatchingOperation<T>> iterator() {
            return this.operationIterator;
        }
    }

    private static interface JDBCBatchingOperationProvider<T extends Table<T>> {
        public JDBCBatchingOperation<T> getJdbcBatchingOperation(Set<Mapping.UpwhereColumn<T>> var1);

        public Iterable<JDBCBatchingOperation<T>> getJdbcBatchingOperations();
    }

    private static class JDBCBatchingOperation<T extends Table<T>> {
        private final WriteOperation<Mapping.UpwhereColumn<T>> writeOperation;
        private final int batchSize;
        private long stepCounter = 0L;

        private JDBCBatchingOperation(WriteOperation<Mapping.UpwhereColumn<T>> writeOperation, int batchSize) {
            this.writeOperation = writeOperation;
            this.batchSize = batchSize;
        }

        private void setValues(Map<Mapping.UpwhereColumn<T>, ?> values) {
            this.writeOperation.addBatch(values);
            ++this.stepCounter;
            this.executeBatchIfNecessary();
        }

        private void executeBatchIfNecessary() {
            if (this.stepCounter == (long)this.batchSize) {
                this.executeBatch();
                this.stepCounter = 0L;
            }
        }

        private void executeBatch() {
            this.writeOperation.executeBatch();
        }
    }
}

