/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMapping;
import org.codefilarete.stalactite.engine.configurer.map.RecordId;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.AlreadyAssignedIdentifierPersistExecutor;
import org.codefilarete.stalactite.engine.runtime.BeanPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.DeleteExecutor;
import org.codefilarete.stalactite.engine.runtime.FirstPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.InsertExecutor;
import org.codefilarete.stalactite.engine.runtime.PersisterListenerWrapper;
import org.codefilarete.stalactite.engine.runtime.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.RelationIds;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityFinder;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SecondPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.UpdateExecutor;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.ComposedIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.query.EntityFinder;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.operator.In;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRelationalEntityPersister<C, I, T extends Table<T>>
extends PersisterListenerWrapper<C, I>
implements ConfiguredRelationalPersister<C, I>,
AdvancedEntityPersister<C, I> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<Queue<Set<RelationIds<Object, Object, Object>>>> CURRENT_2PHASES_LOAD_CONTEXT = new ThreadLocal();
    private final BeanPersister<C, I, T> persister;
    private final EntityFinder<C, I> entityFinder;
    private final EntityCriteriaSupport<C> criteriaSupport;
    private final PersistExecutor<C> persistExecutor;
    private final EntityJoinTree<C, I> entityJoinTree;
    protected final Dialect dialect;

    public SimpleRelationalEntityPersister(DefaultEntityMapping<C, I, T> mainMappingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this.persister = new BeanPersister(mainMappingStrategy, dialect, connectionConfiguration);
        this.entityJoinTree = new EntityJoinTree(new EntityInflater.EntityMappingAdapter(this.persister.getMapping()), (Fromable)this.persister.getMapping().getTargetTable());
        this.dialect = dialect;
        this.entityFinder = new RelationalEntityFinder(this.entityJoinTree, this, this.persister.getConnectionProvider(), dialect);
        this.criteriaSupport = new EntityCriteriaSupport<C>(this.entityJoinTree);
        this.persistExecutor = this.persister.getMapping().getIdMapping().getIdentifierInsertionManager() instanceof AlreadyAssignedIdentifierManager ? new AlreadyAssignedIdentifierPersistExecutor((ConfiguredPersister)this) : new PersistExecutor.DefaultPersistExecutor((EntityPersister)this);
    }

    public I getId(C entity) {
        return (I)this.persister.getId(entity);
    }

    @Override
    public T getMainTable() {
        return (T)this.persister.getMainTable();
    }

    public InsertExecutor<C, I, T> getInsertExecutor() {
        return this.persister.getInsertExecutor();
    }

    public UpdateExecutor<C, I, T> getUpdateExecutor() {
        return this.persister.getUpdateExecutor();
    }

    @Override
    public EntityFinder<C, I> getEntityFinder() {
        return this.entityFinder;
    }

    public DeleteExecutor<C, I, T> getDeleteExecutor() {
        return this.persister.getDeleteExecutor();
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.entityJoinTree;
    }

    public EntityMapping<C, I, T> getMapping() {
        return this.persister.getMapping();
    }

    public Set<Table<?>> giveImpliedTables() {
        return this.getEntityJoinTree().giveTables();
    }

    @Override
    public RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ?> selectWhere() {
        return this.newCriteriaSupport().wrapIntoExecutable();
    }

    @Override
    public EntityQueryCriteriaSupport<C, I> newCriteriaSupport() {
        return new EntityQueryCriteriaSupport<C, I>(this.entityFinder, this.criteriaSupport.copy());
    }

    @Override
    public ProjectionQueryCriteriaSupport<C, I> newProjectionCriteriaSupport(Consumer<Select> selectAdapter) {
        return new ProjectionQueryCriteriaSupport<C, I>(this.entityFinder, this.newCriteriaSupport().getEntityCriteriaSupport(), selectAdapter);
    }

    public EntityPersister.ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter) {
        ProjectionQueryCriteriaSupport<C, I> projectionSupport = new ProjectionQueryCriteriaSupport<C, I>(this.entityFinder, selectAdapter);
        return projectionSupport.wrapIntoExecutable();
    }

    public Set<C> selectAll() {
        return (Set)this.selectWhere().execute(Accumulators.toSet());
    }

    public boolean isNew(C entity) {
        return this.persister.isNew(entity);
    }

    public Class<C> getClassToPersist() {
        return this.persister.getClassToPersist();
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsOne(RelationalEntityPersister<SRC, SRCID> sourcePersister, Accessor<SRC, C> propertyAccessor, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, @Nullable String rightTableAlias, BeanRelationFixer<SRC, C> beanRelationFixer, boolean optional, boolean loadSeparately) {
        if (loadSeparately) {
            String mainTableJoinName = sourcePersister.getEntityJoinTree().addMergeJoin("ROOT", new FirstPhaseRelationLoader(this.getMapping().getIdMapping(), this, CURRENT_2PHASES_LOAD_CONTEXT), leftColumn, rightColumn, EntityJoinTree.JoinType.OUTER);
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, CURRENT_2PHASES_LOAD_CONTEXT));
            return mainTableJoinName;
        }
        EntityInflater.EntityMappingAdapter<C, I, T> strategy = new EntityInflater.EntityMappingAdapter<C, I, T>(this.getMapping());
        String createdJoinNodeName = sourcePersister.getEntityJoinTree().addRelationJoin("ROOT", strategy, propertyAccessor, leftColumn, rightColumn, rightTableAlias, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, beanRelationFixer, Collections.emptySet());
        this.copyRootJoinsTo(sourcePersister.getEntityJoinTree(), createdJoinNodeName);
        return createdJoinNodeName;
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsMany(String joinName, RelationalEntityPersister<SRC, SRCID> sourcePersister, Accessor<SRC, ?> propertyAccessor, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, BeanRelationFixer<SRC, C> beanRelationFixer, @Nullable Function<ColumnedRow, Object> relationIdentifierProvider, Set<? extends Column<T2, ?>> selectableColumns, boolean optional, boolean loadSeparately) {
        if (loadSeparately) {
            String mainTableJoinName = sourcePersister.getEntityJoinTree().addMergeJoin("ROOT", new FirstPhaseRelationLoader(this.getMapping().getIdMapping(), this, CURRENT_2PHASES_LOAD_CONTEXT), leftColumn, rightColumn, EntityJoinTree.JoinType.OUTER);
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, CURRENT_2PHASES_LOAD_CONTEXT));
            return mainTableJoinName;
        }
        String createdJoinNodeName = sourcePersister.getEntityJoinTree().addRelationJoin(joinName, new EntityInflater.EntityMappingAdapter<C, I, T>(this.getMapping()), propertyAccessor, leftColumn, rightColumn, null, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, beanRelationFixer, selectableColumns, relationIdentifierProvider);
        this.copyRootJoinsTo(sourcePersister.getEntityJoinTree(), createdJoinNodeName);
        return createdJoinNodeName;
    }

    @Override
    public <E, ID> void copyRootJoinsTo(EntityJoinTree<E, ID> entityJoinTree, String joinName) {
        this.getEntityJoinTree().projectTo(entityJoinTree, joinName);
    }

    protected void doPersist(Iterable<? extends C> entities) {
        this.persistExecutor.persist(entities);
    }

    protected Set<C> doSelect(Iterable<I> ids) {
        ReversibleAccessor criteriaAccessor;
        this.LOGGER.debug("selecting entities {}", ids);
        IdMapping idMapping = this.persister.getMapping().getIdMapping();
        if (idMapping.getIdentifierAssembler() instanceof ComposedIdentifierAssembler) {
            Map columnValues = ((ComposedIdentifierAssembler)idMapping.getIdentifierAssembler()).getColumnValues(ids);
            TupleIn tupleIn = TupleIn.transformBeanColumnValuesToTupleInValues((int)Iterables.size(ids), (Map)columnValues);
            EntityQueryCriteriaSupport<C, I> newCriteriaSupport = this.newCriteriaSupport();
            newCriteriaSupport.getEntityCriteriaSupport().getCriteria().and(new Object[]{tupleIn});
            return (Set)newCriteriaSupport.wrapIntoExecutable().execute(Accumulators.toSet());
        }
        if (idMapping.getIdAccessor() instanceof AccessorWrapperIdAccessor) {
            criteriaAccessor = ((AccessorWrapperIdAccessor)idMapping.getIdAccessor()).getIdAccessor();
        } else if (idMapping.getIdAccessor() instanceof KeyValueRecordMapping.KeyValueRecordIdMapping.KeyValueRecordIdAccessor) {
            PropertyAccessor accessor = Accessors.accessor(RecordId::getId);
            criteriaAccessor = accessor;
        } else {
            throw new UnsupportedOperationException("Unsupported id accessor type: " + idMapping.getIdAccessor().getClass());
        }
        In in = new In();
        HashSet result = new HashSet();
        EntityPersister.ExecutableEntityQuery executableEntityQuery = (EntityPersister.ExecutableEntityQuery)this.selectWhere().and((ValueAccessPoint)criteriaAccessor, (ConditionalOperator)in);
        Iterables.forEachChunk(ids, (int)this.dialect.getInOperatorMaxSize(), chunks -> {}, chunkSize -> null, (context, chunk) -> {
            in.setValue(chunk);
            result.addAll((Collection)executableEntityQuery.execute(Accumulators.toSet()));
        }, context -> {});
        return result;
    }

    public void doDelete(Iterable<? extends C> entities) {
        this.persister.delete(entities);
    }

    public void doDeleteById(Iterable<? extends C> entities) {
        this.persister.deleteById(entities);
    }

    public void doInsert(Iterable<? extends C> entities) {
        this.persister.insert(entities);
    }

    public void doUpdateById(Iterable<? extends C> entities) {
        this.persister.updateById(entities);
    }

    public void doUpdate(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        this.persister.update(differencesIterable, allColumnsStatement);
    }
}

