/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.Comparator;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilderOneToOneOptions;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.device.Address;
import org.codefilarete.stalactite.engine.model.device.Device;
import org.codefilarete.stalactite.engine.model.device.Location;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FluentEmbeddableWithRelationMappingConfigurationSupportTest {
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void initTest() {
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Nested
    class Embedded {
        Embedded() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingBuilderOneToOneOptions addressMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory());
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)addressMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ConfiguredPersister addressPersister = (ConfiguredPersister)devicePersister;
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Device_location_cityId_City_id", "Device", "location_cityId", "City", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)addressPersister.getMapping().getTargetTable().getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
        }

        @Test
        void crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory();
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)cityConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL)).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            EntityPersister cityPersister = cityConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Device dummyDevice = new Device(13L);
            dummyDevice.setName("UPS");
            Address address = new Address();
            address.setStreet("221B Baker Street");
            City city = new City(111L);
            city.setName("France");
            address.setCity(city);
            dummyDevice.setLocation(address);
            devicePersister.insert((Object)dummyDevice);
            Device loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().isEqualTo((Object)dummyDevice);
            City city1 = new City(22L);
            city1.setName("Spain");
            address.setCity(city1);
            devicePersister.update((Object)dummyDevice);
            loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().isEqualTo((Object)dummyDevice);
            devicePersister.delete((Object)dummyDevice);
            Assertions.assertThat((Object)devicePersister.select(dummyDevice.getId())).isNull();
            Assertions.assertThat((Object)cityPersister.select(city1.getId())).isNull();
        }
    }

    @Nested
    class MappedSuperClass {
        MappedSuperClass() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingBuilderOneToOneOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToOne(Location::getCountry, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mandatory());
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            ConfiguredPersister addressPersister = (ConfiguredPersister)addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Address_cityId_City_id", "Address", "cityId", "City", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_Address_countryId_Country_id", "Address", "countryId", "Country", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)addressPersister.getMapping().getTargetTable().getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
        }

        @Test
        void crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions countryConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mandatory();
            FluentEmbeddableMappingBuilderOneToOneOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToOne(Location::getCountry, (EntityMappingConfigurationProvider)countryConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL);
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            EntityPersister countryPersister = countryConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ConfiguredPersister addressPersister = (ConfiguredPersister)addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Address address = new Address(42L);
            address.setStreet("221B Baker Street");
            Country country = new Country(11L);
            country.setName("France");
            address.setCountry(country);
            City city = new City(111L);
            city.setName("Grenoble");
            address.setCity(city);
            addressPersister.insert((Object)address);
            Address loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().isEqualTo((Object)address);
            Country country1 = new Country(22L);
            country1.setName("France");
            address.setCountry(country1);
            addressPersister.update((Object)address);
            loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().isEqualTo((Object)address);
            addressPersister.delete((Object)address);
            Assertions.assertThat((Object)addressPersister.select(address.getId())).isNull();
            Assertions.assertThat((Object)countryPersister.select(country1.getId())).isNull();
        }
    }
}

