/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.mapping.PersistentFieldHarvester;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class PersistentFieldHarvesterTest {
    public static Object[][] testNextMethodsData() {
        return new Object[][]{{X.class, Arrays.asList((Object[])new String[]{"f1"})}, {Y.class, Arrays.asList((Object[])new String[]{"f2", "f1"})}, {Z.class, Arrays.asList((Object[])new String[]{"f2", "f2", "f1"})}};
    }

    @ParameterizedTest
    @MethodSource(value={"testNextMethodsData"})
    public void testGetFields(Class clazz, List<String> expectedFields) {
        PersistentFieldHarvester testInstance = new PersistentFieldHarvester();
        List fields = testInstance.getFields(clazz);
        Iterator fieldsIterator = fields.iterator();
        Assertions.assertThat((boolean)fieldsIterator.hasNext()).isTrue();
        for (String expectedField : expectedFields) {
            Assertions.assertThat((String)((Field)fieldsIterator.next()).getName()).isEqualTo(expectedField);
        }
        Assertions.assertThat((boolean)fieldsIterator.hasNext()).isFalse();
    }

    static class Z
    extends Y {
        private String f2;

        Z() {
        }
    }

    static class Y
    extends X {
        private String f2;

        Y() {
        }
    }

    static class X {
        private String f1;

        X() {
        }
    }
}

