/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.MapBasedColumnedRow;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;

public class ColumnedRowIterator
extends ResultSetIterator<ColumnedRow> {
    private final Iterable<Decoder> decoders;
    private final Map<Selectable<?>, String> aliases;

    public ColumnedRowIterator(Map<? extends Selectable<?>, ? extends ResultSetReader<?>> columnNameBinders, Map<? extends Selectable<?>, String> aliases) {
        this(null, columnNameBinders, aliases);
    }

    public ColumnedRowIterator(@Nullable ResultSet rs, Map<? extends Selectable<?>, ? extends ResultSetReader<?>> columnNameBinders, Map<? extends Selectable<?>, String> aliases) {
        super(rs);
        this.decoders = Decoder.decoders(columnNameBinders.entrySet());
        this.aliases = aliases;
    }

    public ColumnedRowIterator(ResultSet rs, ParameterBinderIndex<? extends Selectable, ? extends ResultSetReader> columnNameBinders, Map<? extends Selectable<?>, String> aliases) {
        super(rs);
        this.decoders = Decoder.decoders(columnNameBinders.all());
        this.aliases = aliases;
    }

    public ColumnedRow convert(ResultSet rs) throws SQLException {
        MapBasedColumnedRow toReturn = new MapBasedColumnedRow();
        for (Decoder columnEntry : this.decoders) {
            Selectable column = columnEntry.getColumn();
            Object columnValue = columnEntry.getReader().get(rs, this.aliases.get(column));
            toReturn.put(column, columnValue);
        }
        return toReturn;
    }

    private static class Decoder {
        private final Selectable<?> column;
        private final ResultSetReader<?> reader;

        private static Iterable<Decoder> decoders(Iterable<? extends Map.Entry<? extends Selectable, ? extends ResultSetReader>> input) {
            LinkedHashSet<Decoder> result = new LinkedHashSet<Decoder>();
            input.forEach(e -> result.add(new Decoder((Selectable)e.getKey(), (ResultSetReader)e.getValue())));
            return result;
        }

        private Decoder(Selectable<?> column, ResultSetReader<?> reader) {
            this.column = column;
            this.reader = reader;
        }

        private Selectable<?> getColumn() {
            return this.column;
        }

        private ResultSetReader<?> getReader() {
            return this.reader;
        }
    }
}

