/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.engine.cascade.AfterDeleteByIdSupport;
import org.codefilarete.stalactite.engine.cascade.AfterDeleteSupport;
import org.codefilarete.stalactite.engine.cascade.AfterUpdateSupport;
import org.codefilarete.stalactite.engine.cascade.BeforeInsertSupport;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.builder.InheritanceMappingStep;
import org.codefilarete.stalactite.engine.configurer.builder.MainPersisterStep;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.ReadOnlyIterator;
import org.codefilarete.tool.function.Hanger;

public class ParentPersistersStep<C, I> {
    void buildParentPersisters(SimpleRelationalEntityPersister<C, I, ?> mainPersister, AbstractIdentification<C, I> identification, InheritanceMappingStep.MappingPerTable<C> inheritanceMappingPerTable, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        InheritanceMappingStep.Mapping mainMapping = (InheritanceMappingStep.Mapping)Iterables.first(inheritanceMappingPerTable.getMappings());
        ReadOnlyIterator inheritedMappingIterator = Iterables.reverseIterator((AbstractCollection)inheritanceMappingPerTable.getMappings().getDelegate());
        Iterator mappings = Iterables.filter((Iterator)inheritedMappingIterator, m -> !mainMapping.equals(m) && !m.isMappedSuperClass());
        KeepOrderSet<SimpleRelationalEntityPersister<C, I, ?>> parentPersisters = this.buildParentPersisters(() -> mappings, identification, mainPersister, dialect, connectionConfiguration);
        this.addCascadesBetweenChildAndParentTable(mainPersister, parentPersisters);
    }

    private <T extends Table<T>, TT extends Table<TT>> KeepOrderSet<SimpleRelationalEntityPersister<C, I, ?>> buildParentPersisters(Iterable<InheritanceMappingStep.Mapping<C, ?>> mappings, AbstractIdentification<C, I> identification, SimpleRelationalEntityPersister<C, I, T> mainPersister, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        KeepOrderSet result = new KeepOrderSet();
        PrimaryKey superclassPK = mainPersister.getMainTable().getPrimaryKey();
        Hanger.Holder currentTable = new Hanger.Holder(mainPersister.getMainTable());
        mappings.forEach(mapping -> {
            if (mapping.getMappingConfiguration() instanceof EmbeddableMappingConfiguration) {
                Class entityType = ((EmbeddableMappingConfiguration)mapping.getMappingConfiguration()).getBeanType();
                if (PersisterBuilderContext.CURRENT.get().getPersisterRegistry().getPersister(entityType) != null) {
                    return;
                }
            }
            InheritanceMappingStep.Mapping castedMapping = mapping;
            PrimaryKey subclassPK = castedMapping.getTargetTable().getPrimaryKey();
            boolean isIdentifyingConfiguration = identification.getIdentificationDefiner().getPropertiesMapping() == mapping.giveEmbeddableConfiguration();
            DefaultEntityMapping currentMappingStrategy = MainPersisterStep.createEntityMapping(isIdentifyingConfiguration, castedMapping.getTargetTable(), castedMapping.getMapping(), castedMapping.getReadonlyMapping(), castedMapping.getReadConverters(), castedMapping.getWriteConverters(), castedMapping.getPropertiesSetByConstructor(), identification, mapping.giveEmbeddableConfiguration().getBeanType(), null);
            SimpleRelationalEntityPersister currentPersister = new SimpleRelationalEntityPersister(currentMappingStrategy, dialect, connectionConfiguration);
            result.add(currentPersister);
            if (!currentPersister.getMainTable().equals(currentTable.get())) {
                mainPersister.getEntityJoinTree().addMergeJoin("ROOT", new EntityMerger.EntityMergerAdapter(currentMappingStrategy), superclassPK, subclassPK);
                currentTable.set(currentPersister.getMainTable());
            }
        });
        return result;
    }

    private <T extends Table<T>> void addCascadesBetweenChildAndParentTable(SimpleRelationalEntityPersister<C, I, T> mainPersister, KeepOrderSet<SimpleRelationalEntityPersister<C, I, ?>> superPersisters) {
        KeepOrderSet superPersistersWithChangingTable = new KeepOrderSet();
        Hanger.Holder lastTable = new Hanger.Holder(mainPersister.getMainTable());
        superPersisters.forEach(p -> {
            if (!p.getMainTable().equals(lastTable.get())) {
                superPersistersWithChangingTable.add(p);
            }
            lastTable.set(p.getMainTable());
        });
        PersisterListenerCollection persisterListener = mainPersister.getPersisterListener();
        superPersistersWithChangingTable.forEach(superPersister -> {
            persisterListener.addInsertListener(new BeforeInsertSupport(arg_0 -> ((SimpleRelationalEntityPersister)superPersister).insert(arg_0), Function.identity()));
            persisterListener.addUpdateListener(new AfterUpdateSupport((arg_0, arg_1) -> ((SimpleRelationalEntityPersister)superPersister).update(arg_0, arg_1), Function.identity()));
            persisterListener.addUpdateByIdListener(new UpdateByIdListener<C>((SimpleRelationalEntityPersister)superPersister){
                final /* synthetic */ SimpleRelationalEntityPersister val$superPersister;
                {
                    this.val$superPersister = simpleRelationalEntityPersister;
                }

                public void afterUpdateById(Iterable<? extends C> entities) {
                    this.val$superPersister.updateById(entities);
                }
            });
        });
        List copy = Iterables.copy((Iterable)superPersistersWithChangingTable);
        Collections.reverse(copy);
        copy.forEach(superPersister -> {
            persisterListener.addDeleteListener(new AfterDeleteSupport(arg_0 -> ((SimpleRelationalEntityPersister)superPersister).delete(arg_0), Function.identity()));
            persisterListener.addDeleteByIdListener(new AfterDeleteByIdSupport(arg_0 -> ((SimpleRelationalEntityPersister)superPersister).deleteById(arg_0), Function.identity()));
        });
    }
}

