/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.codefilarete.stalactite.sql.statement.binder.NullAwarePreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;

public class NullAwareParameterBinder<T>
implements ParameterBinder<T> {
    public static final ParameterBinder ALWAYS_SET_NULL_INSTANCE = new ParameterBinder(){

        @Override
        public void set(PreparedStatement preparedStatement, int valueIndex, Object value) throws SQLException {
            preparedStatement.setObject(valueIndex, null);
        }

        @Override
        public Object doGet(ResultSet resultSet, String columnName) {
            throw new UnsupportedOperationException("This code should never be called because it's only aimed at writing parameters, not reading");
        }

        @Override
        public Class getType() {
            return Object.class;
        }
    };
    private final NullAwareResultSetReader<T> nullAwareResultSetReader;
    private final NullAwarePreparedStatementWriter<T> nullAwarePreparedStatementWriter;

    public NullAwareParameterBinder(ParameterBinder<T> delegate) {
        this(new NullAwareResultSetReader<T>(delegate), new NullAwarePreparedStatementWriter<T>(delegate));
    }

    public NullAwareParameterBinder(ResultSetReader<T> resultSetReader, PreparedStatementWriter<T> preparedStatementWriter) {
        this(new NullAwareResultSetReader<T>(resultSetReader), new NullAwarePreparedStatementWriter<T>(preparedStatementWriter));
    }

    public NullAwareParameterBinder(NullAwareResultSetReader<T> nullAwareResultSetReader, NullAwarePreparedStatementWriter<T> nullAwarePreparedStatementWriter) {
        this.nullAwareResultSetReader = nullAwareResultSetReader;
        this.nullAwarePreparedStatementWriter = nullAwarePreparedStatementWriter;
    }

    @Override
    public Class<T> getType() {
        return this.nullAwareResultSetReader.getType();
    }

    @Override
    public <O> Class<O> getColumnType() {
        return this.nullAwareResultSetReader.getColumnType();
    }

    @Override
    public T doGet(ResultSet resultSet, String columnName) {
        return (T)this.nullAwareResultSetReader.get(resultSet, columnName);
    }

    @Override
    public void set(PreparedStatement statement, int valueIndex, T value) throws SQLException {
        this.nullAwarePreparedStatementWriter.set(statement, valueIndex, value);
    }
}

