/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.MethodReferences;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointComparator;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.key.CompositeKeyMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.IndexNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.FluentCompositeKeyMappingConfigurationSupport;
import org.codefilarete.stalactite.engine.configurer.FluentEmbeddableMappingConfigurationSupport;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.ReadOnlyIterator;
import org.codefilarete.tool.exception.NotImplementedException;
import org.codefilarete.tool.function.Converter;
import org.codefilarete.tool.function.Hanger;

public class BeanMappingBuilder<C, T extends Table<T>> {
    private final BeanMappingConfiguration<C> mainMappingConfiguration;
    private final T targetTable;
    private final ColumnBinderRegistry columnBinderRegistry;
    private final ColumnNameProvider columnNameProvider;
    private final IndexNamingStrategy indexNamingStrategy;

    public static Table giveTargetTable(EmbeddableMappingConfiguration<?> mappingConfiguration) {
        Hanger.Holder result = new Hanger.Holder();
        ArrayDeque stack = new ArrayDeque(BeanMappingConfiguration.fromEmbeddableMappingConfiguration(mappingConfiguration).getInsets());
        while (!stack.isEmpty()) {
            BeanMappingConfiguration.Inset inset = (BeanMappingConfiguration.Inset)stack.poll();
            inset.getOverriddenColumns().forEach((valueAccessPoint, targetColumn) -> BeanMappingBuilder.assertHolderIsFilledWithTargetTable((Hanger.Holder<Table>)result, targetColumn, valueAccessPoint));
            BeanMappingConfiguration configuration = inset.getConfiguration();
            stack.addAll(configuration.getInsets());
        }
        return (Table)result.get();
    }

    public static Table giveTargetTable(EmbeddableMappingConfiguration<?> mappingConfiguration, Table mainTable) {
        Hanger.Holder result = new Hanger.Holder((Object)mainTable);
        ArrayDeque stack = new ArrayDeque(BeanMappingConfiguration.fromEmbeddableMappingConfiguration(mappingConfiguration).getInsets());
        while (!stack.isEmpty()) {
            BeanMappingConfiguration.Inset inset = (BeanMappingConfiguration.Inset)stack.poll();
            inset.getOverriddenColumns().forEach((valueAccessPoint, targetColumn) -> BeanMappingBuilder.assertHolderIsFilledWithTargetTable((Hanger.Holder<Table>)result, targetColumn, valueAccessPoint));
            BeanMappingConfiguration configuration = inset.getConfiguration();
            stack.addAll(configuration.getInsets());
        }
        return (Table)result.get();
    }

    private static void assertHolderIsFilledWithTargetTable(Hanger.Holder<Table> result, Column targetColumn, ValueAccessPoint<?> valueAccessPoint) {
        if (targetColumn != null) {
            if (result.get() != null && result.get() != targetColumn.getTable()) {
                throw new MappingConfigurationException("Property " + valueAccessPoint + " overrides column with " + targetColumn.getAbsoluteName() + " but it is not part of main table " + ((Table)result.get()).getAbsoluteName());
            }
            result.set((Object)targetColumn.getTable());
        }
    }

    private static <SRC, TRGT> AccessorChain<SRC, TRGT> newAccessorChain(List<? extends ValueAccessPoint<?>> rootAccessors, ValueAccessPoint<?> terminalAccessor, Class<TRGT> beanType) {
        ArrayList accessorsTmp = new ArrayList(rootAccessors);
        accessorsTmp.add(terminalAccessor);
        ArrayList finalAccessors = new ArrayList();
        accessorsTmp.forEach(valueAccessPoint -> {
            if (valueAccessPoint instanceof Accessor) {
                finalAccessors.add((Accessor)valueAccessPoint);
            } else if (valueAccessPoint instanceof ReversibleMutator) {
                finalAccessors.add(((ReversibleMutator)valueAccessPoint).toAccessor());
            } else {
                throw new NotImplementedException(Reflections.toString(valueAccessPoint.getClass()) + " is unknown from chain creation algorithm");
            }
        });
        return AccessorChain.fromAccessorsWithNullSafe(finalAccessors, (accessor, aClass) -> Reflections.newInstance((Class)beanType));
    }

    public BeanMappingBuilder(EmbeddableMappingConfiguration<C> mappingConfiguration, T targetTable, ColumnBinderRegistry columnBinderRegistry, ColumnNameProvider columnNameProvider, IndexNamingStrategy indexNamingStrategy) {
        this(BeanMappingConfiguration.fromEmbeddableMappingConfiguration(mappingConfiguration), targetTable, columnBinderRegistry, columnNameProvider, indexNamingStrategy);
    }

    public BeanMappingBuilder(EmbeddableMappingConfiguration<C> mappingConfiguration, T targetTable, ColumnBinderRegistry columnBinderRegistry, ColumnNamingStrategy columnNamingStrategy, IndexNamingStrategy indexNamingStrategy) {
        this(BeanMappingConfiguration.fromEmbeddableMappingConfiguration(mappingConfiguration), targetTable, columnBinderRegistry, new ColumnNameProvider(columnNamingStrategy), indexNamingStrategy);
    }

    public BeanMappingBuilder(CompositeKeyMappingConfiguration<C> mappingConfiguration, T targetTable, ColumnBinderRegistry columnBinderRegistry, ColumnNamingStrategy columnNamingStrategy, IndexNamingStrategy indexNamingStrategy) {
        this(BeanMappingConfiguration.fromCompositeKeyMappingConfiguration(mappingConfiguration), targetTable, columnBinderRegistry, new ColumnNameProvider(columnNamingStrategy), indexNamingStrategy);
    }

    @VisibleForTesting
    BeanMappingBuilder(BeanMappingConfiguration<C> mappingConfiguration, T targetTable, ColumnBinderRegistry columnBinderRegistry, ColumnNameProvider columnNameProvider, IndexNamingStrategy indexNamingStrategy) {
        this.mainMappingConfiguration = mappingConfiguration;
        this.targetTable = targetTable;
        this.columnNameProvider = columnNameProvider;
        this.columnBinderRegistry = columnBinderRegistry;
        this.indexNamingStrategy = indexNamingStrategy;
    }

    public BeanMapping<C, T> build() {
        return this.build(false);
    }

    public BeanMapping<C, T> build(boolean onlyExtraTableLinkages) {
        InternalProcessor internalProcessor = new InternalProcessor(onlyExtraTableLinkages);
        internalProcessor.includeDirectMapping(this.mainMappingConfiguration, null, new ValueAccessPointMap(), new ValueAccessPointMap(), new ValueAccessPointMap(), new ValueAccessPointSet());
        internalProcessor.includeEmbeddedMapping();
        return internalProcessor.result;
    }

    protected T getTargetTable() {
        return this.targetTable;
    }

    public static interface BeanMappingConfiguration<C> {
        public static <C> BeanMappingConfiguration<C> fromCompositeKeyMappingConfiguration(final CompositeKeyMappingConfiguration<C> compositeKeyMappingConfiguration) {
            return new BeanMappingConfiguration<C>(){
                private final List<Linkage> linkages;
                {
                    this.linkages = Iterables.collectToList(compositeKeyMappingConfiguration.getPropertiesMapping(), embeddableLinkage -> new Linkage((CompositeKeyMappingConfiguration.CompositeKeyLinkage)embeddableLinkage){
                        final /* synthetic */ CompositeKeyMappingConfiguration.CompositeKeyLinkage val$embeddableLinkage;
                        {
                            this.val$embeddableLinkage = compositeKeyLinkage;
                        }

                        public ReversibleAccessor getAccessor() {
                            return this.val$embeddableLinkage.getAccessor();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public Field getField() {
                            return this.val$embeddableLinkage.getField();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public String getColumnName() {
                            return this.val$embeddableLinkage.getColumnName();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public Size getColumnSize() {
                            return this.val$embeddableLinkage.getColumnSize();
                        }

                        public Class getColumnType() {
                            return this.val$embeddableLinkage.getColumnType();
                        }

                        @Override
                        public String getExtraTableName() {
                            return null;
                        }

                        @Override
                        @javax.annotation.Nullable
                        public ParameterBinder<Object> getParameterBinder() {
                            return this.val$embeddableLinkage.getParameterBinder();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public ParameterBinderRegistry.EnumBindType getEnumBindType() {
                            return this.val$embeddableLinkage.getEnumBindType();
                        }

                        @Override
                        public boolean isNullable() {
                            return false;
                        }

                        @Override
                        public boolean isReadonly() {
                            return false;
                        }

                        @Override
                        public boolean isUnique() {
                            return false;
                        }

                        @javax.annotation.Nullable
                        public Converter getReadConverter() {
                            return null;
                        }

                        @javax.annotation.Nullable
                        public Converter getWriteConverter() {
                            return null;
                        }
                    });
                }

                @Override
                public Class<C> getBeanType() {
                    return compositeKeyMappingConfiguration.getBeanType();
                }

                @Override
                @javax.annotation.Nullable
                public BeanMappingConfiguration<? super C> getMappedSuperClassConfiguration() {
                    return (BeanMappingConfiguration)Nullable.nullable(compositeKeyMappingConfiguration.getMappedSuperClassConfiguration()).map(BeanMappingConfiguration::fromCompositeKeyMappingConfiguration).get();
                }

                @Override
                public List<Linkage> getPropertiesMapping() {
                    return this.linkages;
                }

                @Override
                public Collection<Inset<C, Object>> getInsets() {
                    return Iterables.collectToList(compositeKeyMappingConfiguration.getInsets(), compositeInset -> new Inset<C, Object>((FluentCompositeKeyMappingConfigurationSupport.Inset)compositeInset){
                        final /* synthetic */ FluentCompositeKeyMappingConfigurationSupport.Inset val$compositeInset;
                        {
                            this.val$compositeInset = inset;
                        }

                        @Override
                        public PropertyAccessor<C, Object> getAccessor() {
                            return this.val$compositeInset.getAccessor();
                        }

                        @Override
                        public Method getInsetAccessor() {
                            return this.val$compositeInset.getInsetAccessor();
                        }

                        @Override
                        public Class<Object> getEmbeddedClass() {
                            return this.val$compositeInset.getEmbeddedClass();
                        }

                        @Override
                        public ValueAccessPointSet<C> getExcludedProperties() {
                            return this.val$compositeInset.getExcludedProperties();
                        }

                        @Override
                        public ValueAccessPointMap<C, String> getOverriddenColumnNames() {
                            return this.val$compositeInset.getOverriddenColumnNames();
                        }

                        @Override
                        public ValueAccessPointMap<C, Size> getOverriddenColumnSizes() {
                            return this.val$compositeInset.getOverriddenColumnSizes();
                        }

                        @Override
                        public ValueAccessPointMap<C, Column> getOverriddenColumns() {
                            return this.val$compositeInset.getOverriddenColumns();
                        }

                        @Override
                        public BeanMappingConfiguration<Object> getConfiguration() {
                            return BeanMappingConfiguration.fromCompositeKeyMappingConfiguration(this.val$compositeInset.getConfigurationProvider().getConfiguration());
                        }
                    });
                }

                @Override
                public IndexNamingStrategy getIndexNamingStrategy() {
                    return null;
                }
            };
        }

        public static <C> BeanMappingConfiguration<C> fromEmbeddableMappingConfiguration(final EmbeddableMappingConfiguration<C> embeddableMappingConfiguration) {
            return new BeanMappingConfiguration<C>(){
                private final List<Linkage> linkages;
                {
                    this.linkages = Iterables.collectToList(embeddableMappingConfiguration.getPropertiesMapping(), embeddableLinkage -> new Linkage((EmbeddableMappingConfiguration.Linkage)embeddableLinkage){
                        final /* synthetic */ EmbeddableMappingConfiguration.Linkage val$embeddableLinkage;
                        {
                            this.val$embeddableLinkage = linkage;
                        }

                        public ReversibleAccessor getAccessor() {
                            return this.val$embeddableLinkage.getAccessor();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public Field getField() {
                            return this.val$embeddableLinkage.getField();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public String getColumnName() {
                            return this.val$embeddableLinkage.getColumnName();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public Size getColumnSize() {
                            return this.val$embeddableLinkage.getColumnSize();
                        }

                        public Class getColumnType() {
                            return this.val$embeddableLinkage.getColumnType();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public String getExtraTableName() {
                            return this.val$embeddableLinkage.getExtraTableName();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public ParameterBinder<Object> getParameterBinder() {
                            return this.val$embeddableLinkage.getParameterBinder();
                        }

                        @Override
                        @javax.annotation.Nullable
                        public ParameterBinderRegistry.EnumBindType getEnumBindType() {
                            return this.val$embeddableLinkage.getEnumBindType();
                        }

                        @Override
                        public boolean isNullable() {
                            return this.val$embeddableLinkage.isNullable();
                        }

                        @Override
                        public boolean isReadonly() {
                            return this.val$embeddableLinkage.isReadonly();
                        }

                        @Override
                        public boolean isUnique() {
                            return this.val$embeddableLinkage.isUnique();
                        }

                        @javax.annotation.Nullable
                        public Converter getReadConverter() {
                            return this.val$embeddableLinkage.getReadConverter();
                        }

                        @javax.annotation.Nullable
                        public Converter getWriteConverter() {
                            return this.val$embeddableLinkage.getWriteConverter();
                        }
                    });
                }

                @Override
                public Class<C> getBeanType() {
                    return embeddableMappingConfiguration.getBeanType();
                }

                @Override
                @javax.annotation.Nullable
                public BeanMappingConfiguration<? super C> getMappedSuperClassConfiguration() {
                    return (BeanMappingConfiguration)Nullable.nullable(embeddableMappingConfiguration.getMappedSuperClassConfiguration()).map(BeanMappingConfiguration::fromEmbeddableMappingConfiguration).get();
                }

                @Override
                public List<Linkage> getPropertiesMapping() {
                    return this.linkages;
                }

                @Override
                public Collection<Inset<C, Object>> getInsets() {
                    return Iterables.collectToList(embeddableMappingConfiguration.getInsets(), embeddableInset -> new Inset<C, Object>((FluentEmbeddableMappingConfigurationSupport.Inset)embeddableInset){
                        final /* synthetic */ FluentEmbeddableMappingConfigurationSupport.Inset val$embeddableInset;
                        {
                            this.val$embeddableInset = inset;
                        }

                        @Override
                        public Accessor<C, Object> getAccessor() {
                            return this.val$embeddableInset.getAccessor();
                        }

                        @Override
                        public Method getInsetAccessor() {
                            return this.val$embeddableInset.getInsetAccessor();
                        }

                        @Override
                        public Class<Object> getEmbeddedClass() {
                            return this.val$embeddableInset.getEmbeddedClass();
                        }

                        @Override
                        public ValueAccessPointSet<C> getExcludedProperties() {
                            return this.val$embeddableInset.getExcludedProperties();
                        }

                        @Override
                        public ValueAccessPointMap<C, String> getOverriddenColumnNames() {
                            return this.val$embeddableInset.getOverriddenColumnNames();
                        }

                        @Override
                        public ValueAccessPointMap<C, Size> getOverriddenColumnSizes() {
                            return this.val$embeddableInset.getOverriddenColumnSizes();
                        }

                        @Override
                        public ValueAccessPointMap<C, Column> getOverriddenColumns() {
                            return this.val$embeddableInset.getOverriddenColumns();
                        }

                        @Override
                        public BeanMappingConfiguration<Object> getConfiguration() {
                            return BeanMappingConfiguration.fromEmbeddableMappingConfiguration(this.val$embeddableInset.getConfigurationProvider().getConfiguration());
                        }
                    });
                }

                @Override
                public IndexNamingStrategy getIndexNamingStrategy() {
                    return embeddableMappingConfiguration.getIndexNamingStrategy();
                }
            };
        }

        public Class<C> getBeanType();

        @javax.annotation.Nullable
        public BeanMappingConfiguration<? super C> getMappedSuperClassConfiguration();

        public List<Linkage> getPropertiesMapping();

        public Collection<Inset<C, Object>> getInsets();

        public IndexNamingStrategy getIndexNamingStrategy();

        default public Iterable<BeanMappingConfiguration> inheritanceIterable() {
            return () -> new ReadOnlyIterator<BeanMappingConfiguration>(){
                private BeanMappingConfiguration next;
                {
                    this.next = this;
                }

                public boolean hasNext() {
                    return this.next != null;
                }

                public BeanMappingConfiguration next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    BeanMappingConfiguration result = this.next;
                    this.next = this.next.getMappedSuperClassConfiguration();
                    return result;
                }
            };
        }

        public static interface Linkage<C, O> {
            public ReversibleAccessor<C, O> getAccessor();

            @javax.annotation.Nullable
            public Field getField();

            @javax.annotation.Nullable
            public String getColumnName();

            @javax.annotation.Nullable
            public Size getColumnSize();

            public Class<O> getColumnType();

            @javax.annotation.Nullable
            public String getExtraTableName();

            @javax.annotation.Nullable
            public ParameterBinder<Object> getParameterBinder();

            @javax.annotation.Nullable
            public ParameterBinderRegistry.EnumBindType getEnumBindType();

            public boolean isNullable();

            public boolean isReadonly();

            public boolean isUnique();

            @javax.annotation.Nullable
            public Converter<O, O> getReadConverter();

            @javax.annotation.Nullable
            public Converter<O, O> getWriteConverter();
        }

        public static interface Inset<SRC, TRGT> {
            public Accessor<SRC, TRGT> getAccessor();

            public Method getInsetAccessor();

            public Class<TRGT> getEmbeddedClass();

            public ValueAccessPointSet<SRC> getExcludedProperties();

            public ValueAccessPointMap<SRC, String> getOverriddenColumnNames();

            public ValueAccessPointMap<SRC, Size> getOverriddenColumnSizes();

            public ValueAccessPointMap<SRC, Column> getOverriddenColumns();

            public BeanMappingConfiguration<TRGT> getConfiguration();
        }
    }

    static class DuplicateDefinitionChecker
    implements Consumer<BeanMappingConfiguration.Linkage> {
        private final String columnNameToCheck;
        private final ReversibleAccessor propertyAccessor;
        private final ColumnNameProvider columnNameProvider;
        private static final ValueAccessPointComparator VALUE_ACCESS_POINT_COMPARATOR = new ValueAccessPointComparator();

        DuplicateDefinitionChecker(ReversibleAccessor propertyAccessor, String columnNameToCheck, ColumnNameProvider columnNameProvider) {
            this.columnNameToCheck = columnNameToCheck;
            this.propertyAccessor = propertyAccessor;
            this.columnNameProvider = columnNameProvider;
        }

        @Override
        public void accept(BeanMappingConfiguration.Linkage pawn) {
            ReversibleAccessor accessor = pawn.getAccessor();
            if (VALUE_ACCESS_POINT_COMPARATOR.compare(accessor, (ValueAccessPoint)this.propertyAccessor) == 0) {
                throw new MappingConfigurationException("Mapping is already defined by method " + AccessorDefinition.toString((ValueAccessPoint)this.propertyAccessor));
            }
            if (this.columnNameToCheck.equals(Nullable.nullable((Object)pawn.getColumnName()).getOr(() -> this.columnNameProvider.giveColumnName(pawn)))) {
                throw new MappingConfigurationException("Column '" + this.columnNameToCheck + "' of mapping '" + AccessorDefinition.toString((ValueAccessPoint)this.propertyAccessor) + "' is already targeted by '" + AccessorDefinition.toString(pawn.getAccessor()) + "'");
            }
        }
    }

    public static class ColumnNameProvider {
        private final ColumnNamingStrategy columnNamingStrategy;

        public ColumnNameProvider(@javax.annotation.Nullable ColumnNamingStrategy columnNamingStrategy) {
            this.columnNamingStrategy = (ColumnNamingStrategy)Nullable.nullable((Object)columnNamingStrategy).getOr((Object)ColumnNamingStrategy.DEFAULT);
        }

        protected String giveColumnName(BeanMappingConfiguration.Linkage linkage) {
            return (String)Nullable.nullable((Object)linkage.getColumnName()).elseSet((Supplier)Nullable.nullable((Object)linkage.getField()).map(Field::getName)).getOr(() -> this.giveColumnName(AccessorDefinition.giveDefinition(linkage.getAccessor())));
        }

        protected String giveColumnName(AccessorDefinition accessorDefinition) {
            return this.columnNamingStrategy.giveName(accessorDefinition);
        }
    }

    public static class BeanMapping<C, T extends Table<T>> {
        private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> mapping = new HashMap<ReversibleAccessor<C, Object>, Column<T, Object>>();
        private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> readonlyMapping = new HashMap<ReversibleAccessor<C, Object>, Column<T, Object>>();
        private final ValueAccessPointMap<C, Converter<Object, Object>> readConverters = new ValueAccessPointMap();
        private final ValueAccessPointMap<C, Converter<Object, Object>> writeConverters = new ValueAccessPointMap();

        public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getMapping() {
            return this.mapping;
        }

        public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getReadonlyMapping() {
            return this.readonlyMapping;
        }

        public ValueAccessPointMap<C, Converter<Object, Object>> getReadConverters() {
            return this.readConverters;
        }

        public ValueAccessPointMap<C, Converter<Object, Object>> getWriteConverters() {
            return this.writeConverters;
        }
    }

    protected class InternalProcessor {
        private final BeanMapping<C, T> result = new BeanMapping();
        private final boolean onlyExtraTableLinkages;

        protected InternalProcessor(boolean onlyExtraTableLinkages) {
            this.onlyExtraTableLinkages = onlyExtraTableLinkages;
        }

        protected void includeDirectMapping(BeanMappingConfiguration<?> mappingConfiguration, @javax.annotation.Nullable ValueAccessPoint<C> accessorPrefix, ValueAccessPointMap<C, String> overriddenColumnNames, ValueAccessPointMap<C, Size> overriddenColumnSizes, ValueAccessPointMap<C, Column<T, ?>> overriddenColumns, ValueAccessPointSet<C> excludedProperties) {
            Stream<BeanMappingConfiguration.Linkage> linkageStream = mappingConfiguration.getPropertiesMapping().stream().filter(linkage -> !excludedProperties.contains(linkage.getAccessor()));
            if (!this.onlyExtraTableLinkages) {
                linkageStream = linkageStream.filter(linkage -> linkage.getExtraTableName() == null);
            }
            linkageStream.forEach(linkage -> {
                Column overriddenColumn = (Column)overriddenColumns.get(linkage.getAccessor());
                String columnName = (String)Nullable.nullable((Object)overriddenColumn).map(Column::getName).getOr(() -> this.determineColumnName((BeanMappingConfiguration.Linkage)linkage, (String)overriddenColumnNames.get(linkage.getAccessor())));
                Size columnSize = (Size)Nullable.nullable((Object)overriddenColumn).map(Column::getSize).getOr(() -> this.determineColumnSize((BeanMappingConfiguration.Linkage)linkage, (Size)overriddenColumnSizes.get(linkage.getAccessor())));
                this.assertMappingIsNotAlreadyDefinedByInheritance((BeanMappingConfiguration.Linkage)linkage, columnName, (BeanMappingConfiguration)mappingConfiguration);
                Duo mapping = this.includeMapping((BeanMappingConfiguration.Linkage)linkage, accessorPrefix, columnName, columnSize, (Column)overriddenColumn, mappingConfiguration);
                Converter readConverter = linkage.getReadConverter();
                this.result.readConverters.put(mapping.getLeft(), readConverter);
                if (!linkage.isReadonly()) {
                    this.result.mapping.put(mapping.getLeft(), mapping.getRight());
                    Converter writeConverter = linkage.getWriteConverter();
                    this.result.writeConverters.put(mapping.getLeft(), writeConverter);
                } else {
                    this.result.readonlyMapping.put(mapping.getLeft(), mapping.getRight());
                }
            });
        }

        protected <O> Duo<ReversibleAccessor<C, ?>, Column<T, Object>> includeMapping(BeanMappingConfiguration.Linkage<C, O> linkage, @javax.annotation.Nullable ValueAccessPoint<C> accessorPrefix, String columnName, @javax.annotation.Nullable Size columnSize, @javax.annotation.Nullable Column<T, O> overriddenColumn, BeanMappingConfiguration<?> beanMappingConfiguration) {
            Column column = (Column)Nullable.nullable(overriddenColumn).getOr(() -> this.addColumnToTable(linkage, columnName, columnSize));
            if (linkage.isUnique()) {
                BeanMappingBuilder.this.targetTable.addIndex(((IndexNamingStrategy)Objects.preventNull((Object)beanMappingConfiguration.getIndexNamingStrategy(), (Object)BeanMappingBuilder.this.indexNamingStrategy)).giveName(linkage), column, new Column[0]).setUnique();
            }
            this.ensureColumnBindingInRegistry(linkage, column);
            AccessorChain accessor = accessorPrefix != null ? BeanMappingBuilder.newAccessorChain(Collections.singletonList(accessorPrefix), linkage.getAccessor(), beanMappingConfiguration.getBeanType()) : linkage.getAccessor();
            return new Duo((Object)accessor, (Object)column);
        }

        protected <O> void assertMappingIsNotAlreadyDefinedByInheritance(BeanMappingConfiguration.Linkage<C, O> linkage, String columnNameToCheck, BeanMappingConfiguration<O> mappingConfiguration) {
            DuplicateDefinitionChecker duplicateDefinitionChecker = new DuplicateDefinitionChecker(linkage.getAccessor(), columnNameToCheck, BeanMappingBuilder.this.columnNameProvider);
            Iterables.stream(mappingConfiguration.inheritanceIterable()).flatMap(configuration -> configuration.getPropertiesMapping().stream()).filter(pawn -> linkage != pawn && !pawn.isReadonly() && !linkage.isReadonly()).forEach(duplicateDefinitionChecker);
        }

        protected <O> Column<T, O> addColumnToTable(BeanMappingConfiguration.Linkage<C, O> linkage, String columnName, @javax.annotation.Nullable Size columnSize) {
            Class columnType;
            if (linkage.getColumnType().isEnum()) {
                if (linkage.getEnumBindType() == null) {
                    columnType = Integer.class;
                } else {
                    switch (linkage.getEnumBindType()) {
                        case NAME: {
                            columnType = String.class;
                            break;
                        }
                        case ORDINAL: {
                            columnType = Integer.class;
                            break;
                        }
                        default: {
                            columnType = Integer.class;
                            break;
                        }
                    }
                }
            } else {
                columnType = linkage.getParameterBinder() != null ? linkage.getParameterBinder().getColumnType() : linkage.getColumnType();
            }
            Column addedColumn = BeanMappingBuilder.this.targetTable.addColumn(columnName, columnType, columnSize);
            addedColumn.setNullable(linkage.isNullable());
            return addedColumn;
        }

        private <O> String determineColumnName(BeanMappingConfiguration.Linkage<C, O> linkage, @javax.annotation.Nullable String overriddenColumName) {
            return (String)Nullable.nullable((Object)overriddenColumName).elseSet((Object)linkage.getColumnName()).getOr(() -> BeanMappingBuilder.this.columnNameProvider.giveColumnName(linkage));
        }

        private <O> Size determineColumnSize(BeanMappingConfiguration.Linkage<C, O> linkage, @javax.annotation.Nullable Size overriddenColumSize) {
            return (Size)Nullable.nullable((Object)overriddenColumSize).elseSet((Object)linkage.getColumnSize()).get();
        }

        protected <O> void ensureColumnBindingInRegistry(BeanMappingConfiguration.Linkage<C, O> linkage, Column<?, O> column) {
            if (linkage.getColumnType().isEnum()) {
                ParameterBinderRegistry.EnumBindType enumBindType = (ParameterBinderRegistry.EnumBindType)Objects.preventNull((Object)linkage.getEnumBindType(), (Object)ParameterBinderRegistry.EnumBindType.ORDINAL);
                BeanMappingBuilder.this.columnBinderRegistry.register(column, enumBindType.newParameterBinder(linkage.getColumnType()));
            } else if (linkage.getParameterBinder() != null) {
                BeanMappingBuilder.this.columnBinderRegistry.register(column, linkage.getParameterBinder());
            } else {
                try {
                    BeanMappingBuilder.this.columnBinderRegistry.getBinder(column);
                }
                catch (SQLStatement.BindingException e) {
                    throw new MappingConfigurationException("No binder found for property " + AccessorDefinition.toString(linkage.getAccessor()) + " : neither its column nor its type are registered (" + column.getAbsoluteName() + ", type " + Reflections.toString((Class)column.getJavaType()) + ")", e);
                }
            }
        }

        private void includeEmbeddedMapping() {
            HashSet treatedInsets = new HashSet();
            Queue<BeanMappingConfiguration.Inset<Object, Object>> stack = Collections.asLifoQueue(new ArrayDeque());
            stack.addAll(BeanMappingBuilder.this.mainMappingConfiguration.getInsets());
            ArrayDeque accessorPath = new ArrayDeque();
            while (!stack.isEmpty()) {
                BeanMappingConfiguration superClassConfiguration;
                BeanMappingConfiguration.Inset inset = (BeanMappingConfiguration.Inset)stack.poll();
                this.assertNotAlreadyDeclared(inset, treatedInsets);
                BeanMappingConfiguration configuration = inset.getConfiguration();
                Object mappingPrefix = null;
                if (inset.getAccessor() != null) {
                    accessorPath.add(inset.getAccessor());
                    mappingPrefix = accessorPath.size() == 1 ? (ValueAccessPoint)accessorPath.peek() : AccessorChain.fromAccessorsWithNullSafe(new ArrayList(accessorPath));
                }
                if ((superClassConfiguration = configuration.getMappedSuperClassConfiguration()) != null) {
                    this.includeMappedSuperClassMapping(inset, accessorPath, superClassConfiguration);
                }
                this.includeDirectMapping(configuration, (ValueAccessPoint)mappingPrefix, (ValueAccessPointMap)inset.getOverriddenColumnNames(), (ValueAccessPointMap)inset.getOverriddenColumnSizes(), (ValueAccessPointMap)inset.getOverriddenColumns(), (ValueAccessPointSet)inset.getExcludedProperties());
                if (configuration.getInsets().isEmpty()) {
                    accessorPath.remove();
                } else {
                    stack.addAll(configuration.getInsets());
                }
                treatedInsets.add(inset);
            }
        }

        private void includeMappedSuperClassMapping(BeanMappingConfiguration.Inset<C, ?> inset, Collection<Accessor<C, ?>> accessorPath, BeanMappingConfiguration<?> superClassConfiguration) {
            BeanMapping<?, Table> superMapping = new BeanMappingBuilder(superClassConfiguration, BeanMappingBuilder.this.targetTable, BeanMappingBuilder.this.columnBinderRegistry, BeanMappingBuilder.this.columnNameProvider, (IndexNamingStrategy)Objects.preventNull((Object)superClassConfiguration.getIndexNamingStrategy(), (Object)BeanMappingBuilder.this.indexNamingStrategy)).build();
            Class<?> insetBeanType = inset.getConfiguration().getBeanType();
            ((BeanMapping)superMapping).mapping.forEach((accessor, column) -> {
                List<Object> accessors;
                if (accessorPath.size() == 1) {
                    accessors = Arrays.asList((Object[])new Accessor[]{(Accessor)Iterables.first((Iterable)accessorPath), accessor});
                } else {
                    accessors = new ArrayList<ReversibleAccessor>(accessorPath);
                    accessors.add(accessor);
                }
                AccessorChain prefix = AccessorChain.fromAccessorsWithNullSafe(accessors, (localAccessor, accessorInputType) -> Reflections.newInstance((Class)insetBeanType));
                Column finalColumn = inset.getOverriddenColumns().containsKey(accessor) ? (Column)inset.getOverriddenColumns().get(accessor) : (inset.getOverriddenColumnNames().containsKey(accessor) ? BeanMappingBuilder.this.targetTable.addColumn((String)inset.getOverriddenColumnNames().get(accessor), column.getJavaType()) : BeanMappingBuilder.this.targetTable.addColumn(column.getName(), column.getJavaType()));
                this.result.mapping.put(prefix, finalColumn);
            });
        }

        private void assertNotAlreadyDeclared(BeanMappingConfiguration.Inset<C, ?> inset, Set<BeanMappingConfiguration.Inset<C, ?>> treatedInsets) {
            Optional<BeanMappingConfiguration.Inset> alreadyMappedType = treatedInsets.stream().filter(i -> i.getEmbeddedClass() == inset.getEmbeddedClass()).findFirst();
            if (alreadyMappedType.isPresent()) {
                if (alreadyMappedType.get().getInsetAccessor().equals(inset.getInsetAccessor())) {
                    Method currentMethod = inset.getInsetAccessor();
                    String currentMethodReference = MethodReferences.toMethodReferenceString((Method)currentMethod);
                    throw new MappingConfigurationException(currentMethodReference + " is already mapped");
                }
                HashMap columNamePerAccessPoint = new HashMap();
                BeanMappingConfiguration<?> insetConfiguration = inset.getConfiguration();
                insetConfiguration.getPropertiesMapping().forEach(linkage -> {
                    if (!inset.getExcludedProperties().contains(linkage.getAccessor())) {
                        String columnName = this.determineColumnName((BeanMappingConfiguration.Linkage)linkage, (String)inset.getOverriddenColumnNames().get(linkage.getAccessor()));
                        columNamePerAccessPoint.put(columnName, linkage.getAccessor());
                    }
                });
                BeanMappingConfiguration.Inset abstractInset = alreadyMappedType.get();
                HashMap columNamePerAccessPoint2 = new HashMap();
                insetConfiguration.getPropertiesMapping().forEach(linkage -> {
                    if (!abstractInset.getExcludedProperties().contains(linkage.getAccessor())) {
                        String columnName = this.determineColumnName((BeanMappingConfiguration.Linkage)linkage, (String)abstractInset.getOverriddenColumnNames().get(linkage.getAccessor()));
                        columNamePerAccessPoint2.put(columnName, linkage.getAccessor());
                    }
                });
                Map join = Maps.innerJoin(columNamePerAccessPoint, columNamePerAccessPoint2);
                if (!join.isEmpty()) {
                    String currentMethodReference = MethodReferences.toMethodReferenceString((Method)inset.getInsetAccessor());
                    String conflictingDeclaration = MethodReferences.toMethodReferenceString((Method)abstractInset.getInsetAccessor());
                    throw new MappingConfigurationException(currentMethodReference + " conflicts with " + conflictingDeclaration + " while embedding a " + Reflections.toString(inset.getEmbeddedClass()) + ", column names should be overridden : " + join.keySet().stream().map(AccessorDefinition::toString).collect(Collectors.joining(", ")));
                }
            }
        }
    }
}

