/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.IndexNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.MapEntryTableNamingStrategy;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.cascade.AfterInsertCollectionCascader;
import org.codefilarete.stalactite.engine.configurer.builder.BeanMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecord;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMapping;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.map.MapRelation;
import org.codefilarete.stalactite.engine.configurer.map.RecordId;
import org.codefilarete.stalactite.engine.runtime.CollectionUpdater;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.PairIterator;

public class MapRelationConfigurer<SRC, ID, K, V, M extends Map<K, V>> {
    private static final AccessorDefinition KEY_VALUE_RECORD_ID_ACCESSOR_DEFINITION = AccessorDefinition.giveDefinition((ValueAccessPoint)new AccessorByMethodReference(KeyValueRecord::getId));
    private static final AccessorDefinition ENTRY_KEY_ACCESSOR_DEFINITION = AccessorDefinition.giveDefinition((ValueAccessPoint)new AccessorByMethodReference(Map.Entry::getKey));
    private static final AccessorDefinition ENTRY_VALUE_ACCESSOR_DEFINITION = AccessorDefinition.giveDefinition((ValueAccessPoint)new AccessorByMethodReference(Map.Entry::getValue));
    protected final MapRelation<SRC, K, V, M> mapRelation;
    protected final ConfiguredRelationalPersister<SRC, ID> sourcePersister;
    protected final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    protected final ColumnNamingStrategy columnNamingStrategy;
    protected final MapEntryTableNamingStrategy tableNamingStrategy;
    protected final Dialect dialect;
    protected final ConnectionConfiguration connectionConfiguration;
    private final IndexNamingStrategy indexNamingStrategy;

    public MapRelationConfigurer(MapRelation<SRC, K, V, M> mapRelation, ConfiguredRelationalPersister<SRC, ID> sourcePersister, ForeignKeyNamingStrategy foreignKeyNamingStrategy, ColumnNamingStrategy columnNamingStrategy, MapEntryTableNamingStrategy tableNamingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration, IndexNamingStrategy indexNamingStrategy) {
        this.mapRelation = mapRelation;
        this.sourcePersister = sourcePersister;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.columnNamingStrategy = columnNamingStrategy;
        this.tableNamingStrategy = tableNamingStrategy;
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.indexNamingStrategy = indexNamingStrategy;
    }

    public <T extends Table<T>, TARGETTABLE extends Table<TARGETTABLE>> void configure() {
        AccessorDefinition mapProviderDefinition = AccessorDefinition.giveDefinition(this.mapRelation.getMapProvider());
        PrimaryKey sourcePK = this.sourcePersister.getMapping().getTargetTable().getPrimaryKey();
        String tableName = (String)Nullable.nullable((Object)this.mapRelation.getTargetTableName()).getOr(() -> this.tableNamingStrategy.giveTableName(mapProviderDefinition, this.mapRelation.getKeyType(), this.mapRelation.getValueType()));
        Table targetTable = (Table)Nullable.nullable((Object)this.mapRelation.getTargetTable()).getOr(() -> new Table(tableName));
        HashMap primaryKeyForeignColumnMapping = new HashMap();
        Key reverseKey = (Key)Nullable.nullable(this.mapRelation.getReverseColumn()).map(Key::ofSingleColumn).getOr(() -> {
            Key.KeyBuilder result = Key.from((Fromable)targetTable);
            sourcePK.getColumns().forEach(col -> {
                String reverseColumnName = (String)Nullable.nullable((Object)this.mapRelation.getReverseColumnName()).getOr(() -> this.columnNamingStrategy.giveName(KEY_VALUE_RECORD_ID_ACCESSOR_DEFINITION));
                Column reverseCol = targetTable.addColumn(reverseColumnName, col.getJavaType()).primaryKey();
                primaryKeyForeignColumnMapping.put((Column)col, (Column)reverseCol);
                result.addColumn((JoinLink)reverseCol);
            });
            return result.build();
        });
        ForeignKey reverseForeignKey = targetTable.addForeignKey(this.foreignKeyNamingStrategy::giveName, reverseKey, (Key)sourcePK);
        this.registerColumnBinder(reverseForeignKey, sourcePK);
        EmbeddableMappingConfiguration keyEmbeddableConfiguration = (EmbeddableMappingConfiguration)Nullable.nullable(this.mapRelation.getKeyEmbeddableConfigurationProvider()).map(EmbeddableMappingConfigurationProvider::getConfiguration).get();
        EmbeddableMappingConfiguration valueEmbeddableConfiguration = (EmbeddableMappingConfiguration)Nullable.nullable(this.mapRelation.getValueEmbeddableConfigurationProvider()).map(EmbeddableMappingConfigurationProvider::getConfiguration).get();
        IdentifierAssembler sourceIdentifierAssembler = this.sourcePersister.getMapping().getIdMapping().getIdentifierAssembler();
        DefaultEntityMapping<KeyValueRecord<K, V, ID>, RecordId<K, ID>, Table> relationRecordMapping = this.buildKeyValueRecordMapping(targetTable, sourceIdentifierAssembler, primaryKeyForeignColumnMapping, keyEmbeddableConfiguration, valueEmbeddableConfiguration);
        SimpleRelationalEntityPersister<KeyValueRecord<K, V, ID>, RecordId<K, ID>, Table> relationRecordPersister = new SimpleRelationalEntityPersister<KeyValueRecord<K, V, ID>, RecordId<K, ID>, Table>(relationRecordMapping, this.dialect, this.connectionConfiguration);
        ReversibleAccessor<SRC, M> collectionAccessor = this.mapRelation.getMapProvider();
        this.addInsertCascade(this.sourcePersister, (EntityPersister<KeyValueRecord<K, V, ID>, RecordId<K, ID>>)relationRecordPersister, (Accessor<SRC, M>)collectionAccessor);
        this.addUpdateCascade(this.sourcePersister, relationRecordPersister);
        this.addDeleteCascade(this.sourcePersister, relationRecordPersister);
        Supplier collectionFactory = (Supplier)Objects.preventNull(this.mapRelation.getMapFactory(), (Object)BeanRelationFixer.giveMapFactory((Class)mapProviderDefinition.getMemberType()));
        this.addSelectCascade(this.sourcePersister, relationRecordPersister, (PrimaryKey<?, ID>)sourcePK, (ForeignKey<?, ?, ID>)reverseForeignKey, (BiConsumer<SRC, M>)((BiConsumer<Object, Map>)(arg_0, arg_1) -> ((Mutator)this.mapRelation.getMapProvider().toMutator()).set(arg_0, arg_1)), (Accessor<SRC, M>)collectionAccessor, collectionFactory);
    }

    <T extends Table<T>, TARGETTABLE extends Table<TARGETTABLE>> DefaultEntityMapping<KeyValueRecord<K, V, ID>, RecordId<K, ID>, TARGETTABLE> buildKeyValueRecordMapping(TARGETTABLE targetTable, IdentifierAssembler<ID, T> sourceIdentifierAssembler, Map<Column<T, ?>, Column<TARGETTABLE, ?>> primaryKeyForeignColumnMapping, EmbeddableMappingConfiguration<K> keyEmbeddableConfiguration, EmbeddableMappingConfiguration<V> valueEmbeddableConfiguration) {
        KeyValueRecordMappingBuilder builder = new KeyValueRecordMappingBuilder(targetTable, sourceIdentifierAssembler, primaryKeyForeignColumnMapping);
        return this.buildKeyValueRecordMapping(keyEmbeddableConfiguration, targetTable, builder, valueEmbeddableConfiguration);
    }

    <T extends Table<T>, TARGETTABLE extends Table<TARGETTABLE>> DefaultEntityMapping<KeyValueRecord<K, V, ID>, RecordId<K, ID>, TARGETTABLE> buildKeyValueRecordMapping(EmbeddableMappingConfiguration<K> keyEmbeddableConfiguration, TARGETTABLE targetTable, KeyValueRecordMappingBuilder<K, V, ID, TARGETTABLE, T> builder, EmbeddableMappingConfiguration<V> valueEmbeddableConfiguration) {
        Map<Object, Column<TARGETTABLE, Object>> columnMapping;
        if (keyEmbeddableConfiguration == null) {
            String keyColumnName = (String)Nullable.nullable((Object)this.mapRelation.getKeyColumnName()).getOr(() -> this.columnNamingStrategy.giveName(ENTRY_KEY_ACCESSOR_DEFINITION));
            Column keyColumn = targetTable.addColumn(keyColumnName, this.mapRelation.getKeyType()).primaryKey();
            builder.withEntryKeyIsSingleProperty(keyColumn);
        } else {
            BeanMappingBuilder<K, TARGETTABLE> entryKeyMappingBuilder = new BeanMappingBuilder<K, TARGETTABLE>(keyEmbeddableConfiguration, targetTable, this.dialect.getColumnBinderRegistry(), new BeanMappingBuilder.ColumnNameProvider(this.columnNamingStrategy){

                @Override
                protected String giveColumnName(BeanMappingBuilder.BeanMappingConfiguration.Linkage pawn) {
                    return (String)Nullable.nullable((Object)MapRelationConfigurer.this.mapRelation.getOverriddenKeyColumnNames().get(pawn.getAccessor())).getOr(() -> super.giveColumnName(pawn));
                }
            }, this.indexNamingStrategy);
            BeanMappingBuilder.BeanMapping<K, TARGETTABLE> entryKeyMapping = entryKeyMappingBuilder.build();
            columnMapping = entryKeyMapping.getMapping();
            columnMapping.forEach((propertyAccessor, column) -> column.primaryKey());
            builder.withEntryKeyIsComplexType(new EmbeddedClassMapping(keyEmbeddableConfiguration.getBeanType(), targetTable, columnMapping));
        }
        if (valueEmbeddableConfiguration == null) {
            String valueColumnName = (String)Nullable.nullable((Object)this.mapRelation.getValueColumnName()).getOr(() -> this.columnNamingStrategy.giveName(ENTRY_VALUE_ACCESSOR_DEFINITION));
            Column valueColumn = targetTable.addColumn(valueColumnName, this.mapRelation.getValueType());
            builder.withEntryValueIsSingleProperty(valueColumn);
        } else {
            BeanMappingBuilder<V, TARGETTABLE> recordKeyMappingBuilder = new BeanMappingBuilder<V, TARGETTABLE>(valueEmbeddableConfiguration, targetTable, this.dialect.getColumnBinderRegistry(), new BeanMappingBuilder.ColumnNameProvider(this.columnNamingStrategy){

                @Override
                protected String giveColumnName(BeanMappingBuilder.BeanMappingConfiguration.Linkage pawn) {
                    return (String)Nullable.nullable((Object)MapRelationConfigurer.this.mapRelation.getOverriddenValueColumnNames().get(pawn.getAccessor())).getOr(() -> super.giveColumnName(pawn));
                }
            }, this.indexNamingStrategy);
            BeanMappingBuilder.BeanMapping<V, TARGETTABLE> entryValueMapping = recordKeyMappingBuilder.build();
            columnMapping = entryValueMapping.getMapping();
            builder.withEntryValueIsComplexType(new EmbeddedClassMapping(valueEmbeddableConfiguration.getBeanType(), targetTable, columnMapping));
        }
        KeyValueRecordMapping<K, V, ID, TARGETTABLE> relationRecordMapping = builder.build();
        return relationRecordMapping;
    }

    private void registerColumnBinder(ForeignKey<?, ?, ID> reverseColumn, PrimaryKey<?, ID> sourcePK) {
        PairIterator pairIterator = new PairIterator((Iterable)reverseColumn.getColumns(), (Iterable)sourcePK.getColumns());
        pairIterator.forEachRemaining(col -> {
            this.dialect.getColumnBinderRegistry().register((Column)col.getLeft(), this.dialect.getColumnBinderRegistry().getBinder(col.getRight()));
            this.dialect.getSqlTypeRegistry().put((Column)col.getLeft(), this.dialect.getSqlTypeRegistry().getTypeName((Column)col.getRight()));
        });
    }

    protected void addInsertCascade(ConfiguredRelationalPersister<SRC, ID> sourcePersister, EntityPersister<KeyValueRecord<K, V, ID>, RecordId<K, ID>> relationRecordPersister, Accessor<SRC, M> collectionAccessor) {
        Function<SRC, Collection<KeyValueRecord<K, V, ID>>> collectionProviderForInsert = this.toRecordCollectionProvider((IdAccessor<SRC, ID>)sourcePersister.getMapping(), false);
        sourcePersister.addInsertListener(new TargetInstancesInsertCascader<SRC, K, V, ID>(relationRecordPersister, collectionProviderForInsert));
    }

    protected void addUpdateCascade(ConfiguredRelationalPersister<SRC, ID> sourcePersister, final EntityPersister<KeyValueRecord<K, V, ID>, RecordId<K, ID>> relationRecordPersister) {
        Function<SRC, Collection<KeyValueRecord<K, V, ID>>> collectionProviderAsPersistedInstances = this.toRecordCollectionProvider((IdAccessor<SRC, ID>)sourcePersister.getMapping(), true);
        CollectionUpdater collectionUpdater = new CollectionUpdater<SRC, KeyValueRecord<K, V, ID>, Collection<KeyValueRecord<K, V, ID>>>(collectionProviderAsPersistedInstances, relationRecordPersister, (o, i) -> {}, true, KeyValueRecord::footprint){

            @Override
            protected void insertTargets(CollectionUpdater.UpdateContext updateContext) {
                relationRecordPersister.insert(updateContext.getAddedElements());
            }
        };
        sourcePersister.addUpdateListener(new OneToManyWithMappedAssociationEngine.AfterUpdateTrigger(collectionUpdater));
    }

    protected void addDeleteCascade(ConfiguredRelationalPersister<SRC, ID> sourcePersister, EntityPersister<KeyValueRecord<K, V, ID>, RecordId<K, ID>> relationRecordPersister) {
        Function<SRC, Collection<KeyValueRecord<K, V, ID>>> recordsProviderAsPersistedInstances = this.toRecordCollectionProvider((IdAccessor<SRC, ID>)sourcePersister.getMapping(), true);
        sourcePersister.addDeleteListener(new OneToManyWithMappedAssociationEngine.DeleteTargetEntitiesBeforeDeleteCascader<SRC, KeyValueRecord<K, V, ID>>(relationRecordPersister, recordsProviderAsPersistedInstances));
    }

    protected void addSelectCascade(ConfiguredRelationalPersister<SRC, ID> sourcePersister, SimpleRelationalEntityPersister<KeyValueRecord<K, V, ID>, RecordId<K, ID>, ?> relationRecordPersister, PrimaryKey<?, ID> sourcePK, ForeignKey<?, ?, ID> keyValueRecordToSourceForeignKey, BiConsumer<SRC, M> mapSetter, Accessor<SRC, M> mapGetter, Supplier<M> mapFactory) {
        BeanRelationFixer relationFixer = BeanRelationFixer.ofMapAdapter(mapSetter, arg_0 -> mapGetter.get(arg_0), mapFactory, (bean, input, map) -> map.put(input.getKey(), input.getValue()));
        relationRecordPersister.joinAsMany("ROOT", sourcePersister, (Accessor)mapGetter, (Key)sourcePK, (Key)keyValueRecordToSourceForeignKey, relationFixer, null, true, this.mapRelation.isFetchSeparately());
    }

    protected Function<SRC, Collection<KeyValueRecord<K, V, ID>>> toRecordCollectionProvider(IdAccessor<SRC, ID> idAccessor, boolean markAsPersisted) {
        return src -> (HashSet)Iterables.collect(((Map)Nullable.nullable((Object)this.mapRelation.getMapProvider().get(src)).getOr(() -> Collections.emptyMap())).entrySet(), entry -> new KeyValueRecord(idAccessor.getId(src), entry.getKey(), entry.getValue()).setPersisted(markAsPersisted), HashSet::new);
    }

    protected static class TargetInstancesInsertCascader<SRC, K, V, ID>
    extends AfterInsertCollectionCascader<SRC, KeyValueRecord<K, V, ID>> {
        private final Function<SRC, ? extends Collection<KeyValueRecord<K, V, ID>>> mapGetter;

        public TargetInstancesInsertCascader(EntityPersister<KeyValueRecord<K, V, ID>, RecordId<K, ID>> targetPersister, Function<SRC, ? extends Collection<KeyValueRecord<K, V, ID>>> mapGetter) {
            super(targetPersister);
            this.mapGetter = mapGetter;
        }

        @Override
        protected void postTargetInsert(Iterable<? extends KeyValueRecord<K, V, ID>> entities) {
        }

        @Override
        protected Collection<KeyValueRecord<K, V, ID>> getTargets(SRC source) {
            return this.mapGetter.apply(source);
        }
    }
}

