/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetomany;

import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointByMethodReference;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class OneToManyRelation<SRC, TRGT, TRGTID, C extends Collection<TRGT>> {
    private final ReversibleAccessor<SRC, C> collectionProvider;
    private final ValueAccessPointByMethodReference<SRC> methodReference;
    private final BooleanSupplier sourceTablePerClassPolymorphic;
    private final EntityMappingConfigurationProvider<TRGT, TRGTID> targetMappingConfiguration;
    private final MappedByConfiguration mappedByConfiguration = new MappedByConfiguration();
    private SerializableBiConsumer<TRGT, SRC> reverseLink;
    private CascadeOptions.RelationMode relationMode = CascadeOptions.RelationMode.ALL;
    private Supplier<C> collectionFactory;
    private boolean fetchSeparately;
    @Nullable
    private Column indexingColumn;
    @Nullable
    private String indexingColumnName;
    private boolean ordered = false;

    public OneToManyRelation(ReversibleAccessor<SRC, C> collectionProvider, ValueAccessPointByMethodReference<SRC> methodReference, BooleanSupplier sourceTablePerClassPolymorphic, EntityMappingConfigurationProvider<? super TRGT, TRGTID> targetMappingConfiguration) {
        this.collectionProvider = collectionProvider;
        this.methodReference = methodReference;
        this.sourceTablePerClassPolymorphic = sourceTablePerClassPolymorphic;
        this.targetMappingConfiguration = targetMappingConfiguration;
    }

    public ReversibleAccessor<SRC, C> getCollectionProvider() {
        return this.collectionProvider;
    }

    public ValueAccessPointByMethodReference<SRC> getMethodReference() {
        return this.methodReference;
    }

    public boolean isSourceTablePerClassPolymorphic() {
        return this.sourceTablePerClassPolymorphic.getAsBoolean();
    }

    public EntityMappingConfiguration<TRGT, TRGTID> getTargetMappingConfiguration() {
        return this.targetMappingConfiguration.getConfiguration();
    }

    public boolean isTargetTablePerClassPolymorphic() {
        return this.getTargetMappingConfiguration().getPolymorphismPolicy() instanceof PolymorphismPolicy.TablePerClassPolymorphism;
    }

    @Nullable
    public SerializableFunction<TRGT, SRC> getReverseGetter() {
        return this.mappedByConfiguration.reverseGetter;
    }

    public void setReverseGetter(SerializableFunction<TRGT, ? super SRC> reverseGetter) {
        this.mappedByConfiguration.reverseGetter = reverseGetter;
    }

    @Nullable
    public SerializableBiConsumer<TRGT, SRC> getReverseSetter() {
        return this.mappedByConfiguration.reverseSetter;
    }

    public void setReverseSetter(SerializableBiConsumer<TRGT, ? super SRC> reverseSetter) {
        this.mappedByConfiguration.reverseSetter = reverseSetter;
    }

    @Nullable
    public <O> Column<Table<?>, O> getReverseColumn() {
        return this.mappedByConfiguration.reverseColumn;
    }

    public void setReverseColumn(Column<?, ?> reverseColumn) {
        this.mappedByConfiguration.reverseColumn = reverseColumn;
    }

    @Nullable
    public String getReverseColumnName() {
        return this.mappedByConfiguration.reverseColumnName;
    }

    public void setReverseColumn(@Nullable String reverseColumnName) {
        this.mappedByConfiguration.reverseColumnName = reverseColumnName;
    }

    public ValueAccessPointMap<SRC, Column<Table<?>, Object>> getForeignKeyColumnMapping() {
        return this.mappedByConfiguration.getForeignKeyColumnMapping();
    }

    public ValueAccessPointMap<SRC, String> getForeignKeyNameMapping() {
        return this.mappedByConfiguration.getForeignKeyNameMapping();
    }

    @Nullable
    public SerializableBiConsumer<TRGT, SRC> getReverseLink() {
        return this.reverseLink;
    }

    public void setReverseLink(SerializableBiConsumer<TRGT, SRC> reverseLink) {
        this.reverseLink = reverseLink;
    }

    public CascadeOptions.RelationMode getRelationMode() {
        return this.relationMode;
    }

    public void setRelationMode(CascadeOptions.RelationMode relationMode) {
        this.relationMode = relationMode;
    }

    public boolean isOwnedByReverseSide() {
        return this.mappedByConfiguration.isNotEmpty();
    }

    @Nullable
    public Supplier<C> getCollectionFactory() {
        return this.collectionFactory;
    }

    public void setCollectionFactory(Supplier<C> collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    public boolean isFetchSeparately() {
        return this.fetchSeparately;
    }

    public void setFetchSeparately(boolean fetchSeparately) {
        this.fetchSeparately = fetchSeparately;
    }

    public void fetchSeparately() {
        this.setFetchSeparately(true);
    }

    public void setIndexingColumn(Column<? extends Table, Integer> indexingColumn) {
        this.ordered();
        this.indexingColumn = indexingColumn;
    }

    @Nullable
    public <T extends Table, O> Column<T, O> getIndexingColumn() {
        return this.indexingColumn;
    }

    public void setIndexingColumnName(String columnName) {
        this.ordered();
        this.indexingColumnName = columnName;
    }

    @Nullable
    public String getIndexingColumnName() {
        return this.indexingColumnName;
    }

    public void ordered() {
        this.ordered = true;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    private class MappedByConfiguration {
        private SerializableFunction<TRGT, SRC> reverseGetter;
        private SerializableBiConsumer<TRGT, SRC> reverseSetter;
        private Column<Table<?>, Object> reverseColumn;
        private String reverseColumnName;
        private final ValueAccessPointMap<SRC, Column<Table<?>, Object>> foreignKeyColumnMapping = new ValueAccessPointMap();
        private final ValueAccessPointMap<SRC, String> foreignKeyNameMapping = new ValueAccessPointMap();

        private MappedByConfiguration() {
        }

        public SerializableFunction<TRGT, SRC> getReverseGetter() {
            return this.reverseGetter;
        }

        public void setReverseGetter(SerializableFunction<TRGT, SRC> reverseGetter) {
            this.reverseGetter = reverseGetter;
        }

        public SerializableBiConsumer<TRGT, SRC> getReverseSetter() {
            return this.reverseSetter;
        }

        public void setReverseSetter(SerializableBiConsumer<TRGT, SRC> reverseSetter) {
            this.reverseSetter = reverseSetter;
        }

        public Column<Table<?>, ?> getReverseColumn() {
            return this.reverseColumn;
        }

        public void setReverseColumn(Column<?, ?> reverseColumn) {
            this.reverseColumn = reverseColumn;
        }

        public ValueAccessPointMap<SRC, Column<Table<?>, Object>> getForeignKeyColumnMapping() {
            return this.foreignKeyColumnMapping;
        }

        public ValueAccessPointMap<SRC, String> getForeignKeyNameMapping() {
            return this.foreignKeyNameMapping;
        }

        public boolean isNotEmpty() {
            return this.reverseSetter != null || this.reverseGetter != null || this.reverseColumn != null || !this.foreignKeyColumnMapping.isEmpty() || !this.foreignKeyNameMapping.isEmpty();
        }
    }
}

