/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.builder.BeanMappingBuilder;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Converter;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.function.Hanger;

public class InheritanceMappingStep<C, I> {
    @VisibleForTesting
    <T extends Table<T>> MappingPerTable<C> collectPropertiesMappingFromInheritance(EntityMappingConfiguration<C, I> entityMappingConfiguration, final Map<EntityMappingConfiguration, Table> tableMap, ColumnBinderRegistry columnBinderRegistry, ColumnNamingStrategy columnNamingStrategy) {
        MappingPerTable result = new MappingPerTable();
        final InheritanceMappingCollector mappingCollector = new InheritanceMappingCollector(result, columnBinderRegistry, columnNamingStrategy);
        this.visitInheritedEmbeddableMappingConfigurations(entityMappingConfiguration, new Consumer<EntityMappingConfiguration>(){
            private boolean initMapping = false;

            @Override
            public void accept(EntityMappingConfiguration entityMappingConfiguration) {
                mappingCollector.currentKey = entityMappingConfiguration;
                if (this.initMapping) {
                    mappingCollector.init();
                }
                mappingCollector.currentTable = (Table)tableMap.get(entityMappingConfiguration);
                mappingCollector.accept(entityMappingConfiguration);
                this.initMapping = (Boolean)Nullable.nullable(entityMappingConfiguration.getInheritanceConfiguration()).map(EntityMappingConfiguration.InheritanceConfiguration::isJoinTable).getOr((Object)false);
            }
        }, embeddableMappingConfiguration -> {
            mappingCollector.mappedSuperClass = true;
            mappingCollector.accept(embeddableMappingConfiguration);
        });
        return result;
    }

    void visitInheritedEmbeddableMappingConfigurations(EntityMappingConfiguration<C, I> entityMappingConfiguration, Consumer<EntityMappingConfiguration> entityConfigurationConsumer, Consumer<EmbeddableMappingConfiguration> mappedSuperClassConfigurationConsumer) {
        Hanger.Holder lastMapping = new Hanger.Holder();
        entityMappingConfiguration.inheritanceIterable().forEach(configuration -> {
            entityConfigurationConsumer.accept((EntityMappingConfiguration)configuration);
            lastMapping.set(configuration);
        });
        if (((EntityMappingConfiguration)lastMapping.get()).getPropertiesMapping().getMappedSuperClassConfiguration() != null) {
            ((EntityMappingConfiguration)lastMapping.get()).getPropertiesMapping().getMappedSuperClassConfiguration().inheritanceIterable().forEach(mappedSuperClassConfigurationConsumer);
        }
    }

    private static class InheritanceMappingCollector<C, I, T extends Table<T>>
    implements Consumer<EmbeddableMappingConfiguration<C>> {
        private final MappingPerTable<C> result;
        private T currentTable;
        private Map<ReversibleAccessor<C, Object>, Column<T, Object>> currentColumnMap;
        private Map<ReversibleAccessor<C, Object>, Column<T, Object>> currentReadonlyColumnMap;
        private final ValueAccessPointMap<C, Converter<Object, Object>> readConverters;
        private final ValueAccessPointMap<C, Converter<Object, Object>> writeConverters;
        private Mapping<C, T> currentMapping;
        private Object currentKey;
        private boolean mappedSuperClass;
        private ColumnBinderRegistry columnBinderRegistry;
        private ColumnNamingStrategy columnNamingStrategy;

        InheritanceMappingCollector(MappingPerTable<C> result, ColumnBinderRegistry columnBinderRegistry, ColumnNamingStrategy columnNamingStrategy) {
            this.result = result;
            this.currentColumnMap = new HashMap<ReversibleAccessor<C, Object>, Column<T, Object>>();
            this.currentReadonlyColumnMap = new HashMap<ReversibleAccessor<C, Object>, Column<T, Object>>();
            this.readConverters = new ValueAccessPointMap();
            this.writeConverters = new ValueAccessPointMap();
            this.mappedSuperClass = false;
            this.columnBinderRegistry = columnBinderRegistry;
            this.columnNamingStrategy = columnNamingStrategy;
        }

        public void init() {
            this.currentColumnMap = new HashMap<ReversibleAccessor<C, Object>, Column<T, Object>>();
            this.currentReadonlyColumnMap = new HashMap<ReversibleAccessor<C, Object>, Column<T, Object>>();
            this.readConverters.clear();
            this.writeConverters.clear();
            this.currentMapping = null;
        }

        @Override
        public void accept(EntityMappingConfiguration<C, I> entityMappingConfiguration) {
            this.accept(entityMappingConfiguration.getPropertiesMapping());
        }

        @Override
        public void accept(EmbeddableMappingConfiguration<C> embeddableMappingConfiguration) {
            BeanMappingBuilder<C, T> beanMappingBuilder = new BeanMappingBuilder<C, T>(embeddableMappingConfiguration, this.currentTable, this.columnBinderRegistry, this.columnNamingStrategy);
            BeanMappingBuilder.BeanMapping<C, T> propertiesMapping = beanMappingBuilder.build();
            ValueAccessPointSet localMapping = new ValueAccessPointSet(this.currentColumnMap.keySet());
            propertiesMapping.getMapping().keySet().forEach(propertyAccessor -> {
                if (localMapping.contains(propertyAccessor)) {
                    throw new MappingConfigurationException(AccessorDefinition.toString((ValueAccessPoint)propertyAccessor) + " is mapped twice");
                }
            });
            propertiesMapping.getReadonlyMapping().keySet().forEach(propertyAccessor -> {
                if (localMapping.contains(propertyAccessor)) {
                    throw new MappingConfigurationException(AccessorDefinition.toString((ValueAccessPoint)propertyAccessor) + " is mapped twice");
                }
            });
            this.currentColumnMap.putAll(propertiesMapping.getMapping());
            this.currentReadonlyColumnMap.putAll(propertiesMapping.getReadonlyMapping());
            this.readConverters.putAll(propertiesMapping.getReadConverters());
            this.writeConverters.putAll(propertiesMapping.getWriteConverters());
            if (this.currentMapping == null) {
                this.currentMapping = this.result.add(Objects.preventNull((Object)this.currentKey, embeddableMappingConfiguration), this.currentTable, this.currentColumnMap, this.currentReadonlyColumnMap, (ValueAccessPointMap<C, Converter<Object, Object>>)new ValueAccessPointMap(this.readConverters), (ValueAccessPointMap<C, Converter<Object, Object>>)new ValueAccessPointMap(this.writeConverters), this.mappedSuperClass);
            } else {
                this.currentMapping = this.result.add(embeddableMappingConfiguration, this.currentTable, this.currentColumnMap, this.currentReadonlyColumnMap, (ValueAccessPointMap<C, Converter<Object, Object>>)new ValueAccessPointMap(this.readConverters), (ValueAccessPointMap<C, Converter<Object, Object>>)new ValueAccessPointMap(this.writeConverters), this.mappedSuperClass);
                this.currentMapping.getMapping().putAll(this.currentColumnMap);
            }
            embeddableMappingConfiguration.getPropertiesMapping().stream().filter(EmbeddableMappingConfiguration.Linkage::isSetByConstructor).map(EmbeddableMappingConfiguration.Linkage::getAccessor).forEach(arg_0 -> ((Mapping)this.currentMapping).propertiesSetByConstructor.add(arg_0));
        }
    }

    public static class MappingPerTable<C> {
        private final KeepOrderSet<Mapping<C, ?>> mappings = new KeepOrderSet();

        <T extends Table<T>> Mapping<C, T> add(Object mappingConfiguration, T table, Map<ReversibleAccessor<C, Object>, Column<T, Object>> mapping, Map<ReversibleAccessor<C, Object>, Column<T, Object>> readonlyMapping, ValueAccessPointMap<C, ? extends Converter<Object, Object>> readConverters, ValueAccessPointMap<C, ? extends Converter<Object, Object>> writeConverters, boolean mappedSuperClass) {
            Mapping<C, T> newMapping = new Mapping<C, T>(mappingConfiguration, table, mapping, readonlyMapping, readConverters, writeConverters, mappedSuperClass);
            this.mappings.add(newMapping);
            return newMapping;
        }

        <T extends Table<T>> Map<ReversibleAccessor<C, Object>, Column<T, Object>> giveMapping(T table) {
            Mapping foundMapping = (Mapping)Iterables.find(this.mappings, m -> m.getTargetTable().equals(table));
            if (foundMapping == null) {
                throw new IllegalArgumentException("Can't find table '" + table.getAbsoluteName() + "' in " + Iterables.collectToList(this.mappings, (Function)Functions.chain(Mapping::getTargetTable, Table::getAbsoluteName)).toString());
            }
            return foundMapping.mapping;
        }

        KeepOrderSet<Table> giveTables() {
            return (KeepOrderSet)Iterables.collect(this.mappings, Mapping::getTargetTable, KeepOrderSet::new);
        }

        public KeepOrderSet<Mapping<C, ?>> getMappings() {
            return this.mappings;
        }
    }

    public static class Mapping<C, T extends Table<T>> {
        private final Object mappingConfiguration;
        private final T targetTable;
        private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> mapping;
        private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> readonlyMapping;
        private final ValueAccessPointSet<C> propertiesSetByConstructor = new ValueAccessPointSet();
        private final boolean mappedSuperClass;
        private Duo<ReversibleAccessor<C, ?>, PrimaryKey<T, ?>> identifier;
        private final ValueAccessPointMap<C, Converter<Object, Object>> readConverters;
        private final ValueAccessPointMap<C, Converter<Object, Object>> writeConverters;

        public Mapping(Object mappingConfiguration, T targetTable, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> mapping, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> readonlyMapping, ValueAccessPointMap<C, ? extends Converter<Object, Object>> readConverters, ValueAccessPointMap<C, ? extends Converter<Object, Object>> writeConverters, boolean mappedSuperClass) {
            this.mappingConfiguration = mappingConfiguration;
            this.targetTable = targetTable;
            this.mapping = mapping;
            this.readonlyMapping = readonlyMapping;
            this.readConverters = readConverters;
            this.writeConverters = writeConverters;
            this.mappedSuperClass = mappedSuperClass;
        }

        public Object getMappingConfiguration() {
            return this.mappingConfiguration;
        }

        public boolean isMappedSuperClass() {
            return this.mappedSuperClass;
        }

        public EmbeddableMappingConfiguration<C> giveEmbeddableConfiguration() {
            return this.mappingConfiguration instanceof EmbeddableMappingConfiguration ? this.mappingConfiguration : (this.mappingConfiguration instanceof EntityMappingConfiguration ? ((EntityMappingConfiguration)this.mappingConfiguration).getPropertiesMapping() : null);
        }

        public T getTargetTable() {
            return this.targetTable;
        }

        public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getMapping() {
            return this.mapping;
        }

        public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getReadonlyMapping() {
            return this.readonlyMapping;
        }

        public ValueAccessPointMap<C, Converter<Object, Object>> getReadConverters() {
            return this.readConverters;
        }

        public ValueAccessPointMap<C, Converter<Object, Object>> getWriteConverters() {
            return this.writeConverters;
        }

        void registerIdentifier(ReversibleAccessor<C, ?> identifierAccessor) {
            this.identifier = new Duo(identifierAccessor, (Object)this.getTargetTable().getPrimaryKey());
        }

        public Duo<ReversibleAccessor<C, ?>, PrimaryKey<T, ?>> getIdentifier() {
            return this.identifier;
        }

        public ValueAccessPointSet<C> getPropertiesSetByConstructor() {
            return this.propertiesSetByConstructor;
        }
    }
}

