/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.OperatorSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.PreparedSQLBuilder;
import org.codefilarete.stalactite.query.builder.PreparedSQLWrapper;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringAppenderWrapper;
import org.codefilarete.stalactite.query.model.AbstractCriterion;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.RawCriterion;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;

public class WhereSQLBuilderFactory {
    public static final String AND = "and";
    public static final String OR = "or";
    private final ColumnBinderRegistry parameterBinderRegistry;
    private final OperatorSQLBuilderFactory operatorSqlBuilderFactory;
    private final FunctionSQLBuilderFactory functionSQLBuilderFactory;

    public WhereSQLBuilderFactory(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping, ColumnBinderRegistry parameterBinderRegistry) {
        this(parameterBinderRegistry, new OperatorSQLBuilderFactory(), new FunctionSQLBuilderFactory(javaTypeToSqlTypeMapping));
    }

    public WhereSQLBuilderFactory(ColumnBinderRegistry parameterBinderRegistry, OperatorSQLBuilderFactory operatorSqlBuilderFactory, FunctionSQLBuilderFactory functionSQLBuilderFactory) {
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.operatorSqlBuilderFactory = operatorSqlBuilderFactory;
        this.functionSQLBuilderFactory = functionSQLBuilderFactory;
    }

    public WhereSQLBuilder whereBuilder(CriteriaChain where, DMLNameProvider dmlNameProvider) {
        return new WhereSQLBuilder(where, dmlNameProvider, this.parameterBinderRegistry, this.operatorSqlBuilderFactory.operatorSQLBuilder(), this.functionSQLBuilderFactory.functionSQLBuilder(dmlNameProvider));
    }

    public static class WhereSQLBuilder
    implements SQLBuilder,
    PreparedSQLBuilder {
        private final CriteriaChain where;
        private final DMLNameProvider dmlNameProvider;
        private final ColumnBinderRegistry parameterBinderRegistry;
        private final OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSqlBuilder;
        private final FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder;

        public WhereSQLBuilder(CriteriaChain where, DMLNameProvider dmlNameProvider, ColumnBinderRegistry parameterBinderRegistry, OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSqlBuilder, FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
            this.where = where;
            this.dmlNameProvider = dmlNameProvider;
            this.parameterBinderRegistry = parameterBinderRegistry;
            this.operatorSqlBuilder = operatorSqlBuilder;
            this.functionSQLBuilder = functionSQLBuilder;
        }

        @Override
        public String toSQL() {
            return this.appendSQL(new StringAppender());
        }

        public String appendSQL(StringAppender sql) {
            return this.appendSQL(new StringAppenderWrapper(sql, this.dmlNameProvider));
        }

        public String appendSQL(SQLAppender sql) {
            WhereAppender whereAppender = new WhereAppender(sql, this.dmlNameProvider, this.operatorSqlBuilder, this.functionSQLBuilder);
            whereAppender.cat(this.where);
            return sql.getSQL();
        }

        @Override
        public PreparedSQL toPreparedSQL() {
            return this.toPreparedSQL(new StringAppender(), this.parameterBinderRegistry);
        }

        public PreparedSQL toPreparedSQL(StringAppender sql, ColumnBinderRegistry parameterBinderRegistry) {
            PreparedSQLWrapper preparedSQLWrapper = new PreparedSQLWrapper(new StringAppenderWrapper(sql, this.dmlNameProvider), parameterBinderRegistry, this.dmlNameProvider);
            return this.toPreparedSQL(preparedSQLWrapper);
        }

        public PreparedSQL toPreparedSQL(PreparedSQLWrapper preparedSQLWrapper) {
            WhereAppender whereAppender = new WhereAppender(preparedSQLWrapper, this.dmlNameProvider, this.operatorSqlBuilder, this.functionSQLBuilder);
            whereAppender.cat(this.where);
            PreparedSQL result = new PreparedSQL(preparedSQLWrapper.getSQL(), preparedSQLWrapper.getParameterBinders());
            result.setValues(preparedSQLWrapper.getValues());
            return result;
        }

        public class WhereAppender {
            private final SQLAppender sql;
            private final OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSqlBuilder;
            private final FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder;
            private final DMLNameProvider dmlNameProvider;

            public WhereAppender(SQLAppender sql, DMLNameProvider dmlNameProvider, OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSqlBuilder, FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
                this.sql = sql;
                this.operatorSqlBuilder = operatorSqlBuilder;
                this.functionSQLBuilder = functionSQLBuilder;
                this.dmlNameProvider = dmlNameProvider;
            }

            public void cat(Object o) {
                if (o instanceof CharSequence) {
                    this.sql.cat(o.toString(), new String[0]);
                } else if (o instanceof CriteriaChain) {
                    this.sql.cat("(", new String[0]);
                    this.cat((CriteriaChain)o);
                    this.sql.cat(")", new String[0]);
                } else if (o instanceof RawCriterion) {
                    this.cat((RawCriterion)o);
                } else if (o instanceof ColumnCriterion) {
                    this.cat((ColumnCriterion)o);
                }
            }

            public void cat(CriteriaChain criteria) {
                boolean isNotFirst = false;
                for (Object criterion : criteria) {
                    if (isNotFirst) {
                        this.cat(((AbstractCriterion)criterion).getOperator());
                    } else {
                        isNotFirst = true;
                    }
                    this.cat(criterion);
                }
            }

            public void cat(RawCriterion criterion) {
                for (Object o : criterion.getCondition()) {
                    if (o instanceof ColumnCriterion) {
                        this.cat((ColumnCriterion)o);
                        continue;
                    }
                    if (o instanceof CharSequence) {
                        this.sql.cat(o.toString(), new String[0]);
                        continue;
                    }
                    if (o instanceof CriteriaChain) {
                        this.sql.cat("(", new String[0]);
                        this.cat((CriteriaChain)o);
                        this.sql.cat(")", new String[0]);
                        continue;
                    }
                    if (o instanceof SQLFunction) {
                        this.cat((SQLFunction)o);
                        continue;
                    }
                    if (o instanceof Selectable) {
                        this.cat((Selectable)o);
                        continue;
                    }
                    if (o instanceof TupleIn) {
                        this.catTupledIn((TupleIn)o);
                        continue;
                    }
                    if (o instanceof ConditionalOperator) {
                        this.cat((ConditionalOperator)o);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unknown criterion type " + Reflections.toString(o.getClass()));
                }
            }

            public void cat(ColumnCriterion criterion) {
                this.cat(criterion.getColumn());
                this.sql.cat(" ", new String[0]);
                Object o = criterion.getCondition();
                if (o instanceof CharSequence) {
                    this.sql.cat(o.toString(), new String[0]);
                } else if (o instanceof ConditionalOperator) {
                    this.cat(criterion.getColumn(), (ConditionalOperator)o);
                } else {
                    try {
                        WhereSQLBuilder.this.parameterBinderRegistry.getBinder(o.getClass());
                    }
                    catch (SQLStatement.BindingException e) {
                        throw new IllegalArgumentException("Unknown criterion type " + Reflections.toString(o.getClass()));
                    }
                    this.sql.catValue(o);
                }
            }

            public void cat(Selectable column) {
                this.sql.cat(this.dmlNameProvider.getName(column), new String[0]);
            }

            public void cat(AbstractCriterion.LogicalOperator operator) {
                if (operator != null) {
                    this.sql.cat(" ", this.getName(operator), " ");
                }
            }

            public void cat(ConditionalOperator operator) {
                this.operatorSqlBuilder.cat(operator, this.sql);
            }

            public void catTupledIn(TupleIn operator) {
                this.operatorSqlBuilder.catTupledIn(operator, this.sql);
            }

            public void cat(SQLFunction sqlFunction) {
                this.functionSQLBuilder.cat(sqlFunction, this.sql);
            }

            public void cat(Selectable column, ConditionalOperator operator) {
                this.operatorSqlBuilder.cat(column, operator, this.sql);
            }

            public String getName(AbstractCriterion.LogicalOperator operator) {
                switch (operator) {
                    case AND: {
                        return WhereSQLBuilderFactory.AND;
                    }
                    case OR: {
                        return WhereSQLBuilderFactory.OR;
                    }
                }
                throw new IllegalArgumentException("Operator " + (Object)((Object)operator) + " is unknown");
            }
        }
    }
}

