/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.spring.repository.query;

import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.spring.repository.query.AbstractQuery;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;

public class PartTreeStalactiteQuery<C, R>
implements RepositoryQuery {
    private final QueryMethod method;
    private final Query<C> query;
    private final Accumulator<C, ?, R> accumulator;

    public PartTreeStalactiteQuery(QueryMethod method, EntityPersister<C, ?> entityPersister, PartTree tree, Accumulator<C, ?, R> accumulator) {
        this.method = method;
        this.accumulator = accumulator;
        Parameters parameters = method.getParameters();
        boolean recreationRequired = parameters.potentiallySortsDynamically();
        try {
            this.query = new Query<C>(entityPersister, tree);
        }
        catch (RuntimeException o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s! %s", method, o_O.getMessage()), o_O);
        }
    }

    @Nullable
    public R execute(Object[] parameters) {
        this.query.criteriaChain.consume(parameters);
        Object result = ((Query)this.query).executableEntityQuery.execute(this.accumulator);
        if (this.method.getResultProcessor().getReturnedType().isProjecting() || this.method.getParameters().hasDynamicProjection()) {
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.method.getParameters(), parameters);
            return (R)this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor).processResult(result);
        }
        return (R)result;
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    class Query<T>
    extends AbstractQuery<T> {
        private final EntityPersister.ExecutableEntityQuery<T> executableEntityQuery;

        Query(EntityPersister<T, ?> entityPersister, PartTree tree) {
            super(entityPersister);
            this.executableEntityQuery = entityPersister.selectWhere();
            tree.forEach(orPart -> orPart.forEach(this::append));
        }

        private void append(Part part) {
            AbstractQuery.Criterion criterion = this.convertToOperator(part.getType());
            this.executableEntityQuery.and(this.convertToAccessorChain(part.getProperty()), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }
}

