/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.test;

import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.UrlAwareDataSource;
import org.codefilarete.tool.exception.Exceptions;
import org.mariadb.jdbc.MariaDbDataSource;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MariaDBEmbeddableDataSource
extends UrlAwareDataSource
implements Closeable {
    public static final int MARIADB_DEFAULT_PORT = 3306;
    public static final int DEFAULT_PORT = 3406;
    private static final Map<Integer, MariaDBContainer> USED_PORTS = new HashMap<Integer, MariaDBContainer>();
    private MariaDBContainer container;
    private final int port;

    public MariaDBEmbeddableDataSource() {
        this(3406);
    }

    public MariaDBEmbeddableDataSource(int port) {
        this(port, "test" + Integer.toHexString(new Random().nextInt()));
    }

    private MariaDBEmbeddableDataSource(int port, String databaseName) {
        super("jdbc:mariadb://localhost:" + port + "/" + databaseName);
        MariaDbDataSource delegate;
        this.port = port;
        this.start(databaseName);
        try {
            delegate = new MariaDbDataSource(this.getUrl());
            delegate.setUser(this.container.getUsername());
            delegate.setPassword(this.container.getPassword());
        }
        catch (SQLException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
        this.setDelegate((DataSource)delegate);
    }

    private void start(String databaseName) {
        this.container = USED_PORTS.get(this.port);
        if (this.container == null) {
            MariaDBContainer mariaDBContainer = new MariaDBContainer(DockerImageName.parse((String)"mariadb:10.4"));
            mariaDBContainer.withUsername("root").withPassword("").setPortBindings(Arrays.asList(this.port + ":" + 3306));
            mariaDBContainer.start();
            USED_PORTS.put(this.port, mariaDBContainer);
            this.container = mariaDBContainer;
        }
        try {
            this.container.createConnection("").prepareStatement("create schema " + databaseName).execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.container.stop();
        USED_PORTS.remove(this.port);
    }
}

