/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.assembly;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;

public abstract class ComposedIdentifierAssembler<I, T extends Table<T>>
implements IdentifierAssembler<I, T> {
    private final PrimaryKey<T, I> primaryKey;

    protected ComposedIdentifierAssembler(T table) {
        this(((Table)table).getPrimaryKey());
    }

    protected ComposedIdentifierAssembler(PrimaryKey<T, I> primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public Set<Column<T, ?>> getColumns() {
        return this.primaryKey.getColumns();
    }

    @Override
    public Map<Column<T, ?>, ?> getColumnValues(Iterable<I> ids) {
        HashMap pkValues = new HashMap();
        List idsAsList = Iterables.asList(ids);
        if (idsAsList.size() == 1) {
            Map localPkValues = this.getColumnValues(idsAsList.get(0));
            this.primaryKey.getColumns().forEach(pkColumn -> pkValues.put(pkColumn, localPkValues.get(pkColumn)));
        } else {
            ids.forEach(id -> {
                Map localPkValues = this.getColumnValues(id);
                this.primaryKey.getColumns().forEach(pkColumn -> ((List)pkValues.computeIfAbsent(pkColumn, k -> new ArrayList())).add(localPkValues.get(pkColumn)));
            });
        }
        return pkValues;
    }
}

