/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.tool.Reflections;

public interface PersisterRegistry {
    public <C, I> EntityPersister<C, I> getPersister(Class<C> var1);

    public <C> void addPersister(EntityPersister<C, ?> var1);

    public static class DefaultPersisterRegistry
    implements PersisterRegistry {
        private final Map<Class<?>, EntityPersister> persisterCache = new HashMap();

        @Override
        public <C, I> EntityPersister<C, I> getPersister(Class<C> clazz) {
            return this.persisterCache.get(clazz);
        }

        @Override
        public <C> void addPersister(EntityPersister<C, ?> persister) {
            EntityPersister existingPersister = this.persisterCache.get(persister.getClassToPersist());
            if (existingPersister != null && existingPersister != persister) {
                throw new UnsupportedOperationException("Persister already exists for class " + Reflections.toString(persister.getClassToPersist()));
            }
            this.persisterCache.put(persister.getClassToPersist(), persister);
        }

        public Set<EntityPersister> getPersisters() {
            return new HashSet<EntityPersister>(this.persisterCache.values());
        }
    }
}

