/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.stalactite.engine.BeanKeyQueryMapper;
import org.codefilarete.stalactite.engine.BeanPropertyQueryMapper;
import org.codefilarete.stalactite.engine.CurrentThreadTransactionalConnectionProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.QueryMapper;
import org.codefilarete.stalactite.engine.crud.BatchDelete;
import org.codefilarete.stalactite.engine.crud.BatchInsert;
import org.codefilarete.stalactite.engine.crud.BatchUpdate;
import org.codefilarete.stalactite.engine.crud.DatabaseCrudOperations;
import org.codefilarete.stalactite.engine.crud.DefaultBatchDelete;
import org.codefilarete.stalactite.engine.crud.DefaultBatchInsert;
import org.codefilarete.stalactite.engine.crud.DefaultBatchUpdate;
import org.codefilarete.stalactite.engine.crud.DefaultExecutableDelete;
import org.codefilarete.stalactite.engine.crud.DefaultExecutableInsert;
import org.codefilarete.stalactite.engine.crud.DefaultExecutableUpdate;
import org.codefilarete.stalactite.engine.crud.ExecutableDelete;
import org.codefilarete.stalactite.engine.crud.ExecutableInsert;
import org.codefilarete.stalactite.engine.crud.ExecutableUpdate;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.DialectResolver;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Delete;
import org.codefilarete.stalactite.sql.order.Update;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ResultSetRowAssembler;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformer;
import org.codefilarete.stalactite.sql.result.WholeResultSetTransformer;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.bean.ClassIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Converter;
import org.codefilarete.tool.function.SerializableTriFunction;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableBiFunction;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public class PersistenceContext
implements DatabaseCrudOperations {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private final ConnectionConfiguration configuration;
    private final Dialect dialect;
    private final PersisterRegistry.DefaultPersisterRegistry persisterRegistry = new PersisterRegistry.DefaultPersisterRegistry();

    public PersistenceContext(DataSource dataSource) {
        this(new CurrentThreadTransactionalConnectionProvider(dataSource));
    }

    public PersistenceContext(DataSource dataSource, Dialect dialect) {
        this((ConnectionProvider)new CurrentThreadTransactionalConnectionProvider(dataSource), dialect);
    }

    public PersistenceContext(ConnectionProvider connectionProvider) {
        this((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProvider, 100), (DialectResolver)new ServiceLoaderDialectResolver());
    }

    public PersistenceContext(ConnectionConfiguration connectionConfiguration) {
        this(connectionConfiguration, (DialectResolver)new ServiceLoaderDialectResolver());
    }

    public PersistenceContext(ConnectionProvider connectionProvider, DialectResolver dialectResolver) {
        this((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProvider, 100), dialectResolver);
    }

    public PersistenceContext(ConnectionConfiguration connectionConfiguration, DialectResolver dialectResolver) {
        this(connectionConfiguration, dialectResolver.determineDialect(connectionConfiguration.getConnectionProvider().giveConnection()));
    }

    public PersistenceContext(ConnectionProvider connectionProvider, Dialect dialect) {
        this((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProvider, 100), dialect);
    }

    public PersistenceContext(ConnectionConfiguration connectionConfiguration, Dialect dialect) {
        this.configuration = connectionConfiguration;
        this.dialect = dialect;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.configuration.getConnectionProvider();
    }

    public int getJDBCBatchSize() {
        return this.getConnectionConfiguration().getBatchSize();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public <C, I> EntityPersister<C, I> findPersister(Class<C> clazz) {
        Class pawn;
        EntityPersister result;
        if (this.persisterRegistry.getPersister(clazz) != null) {
            return this.persisterRegistry.getPersister(clazz);
        }
        ClassIterator classIterator = new ClassIterator(clazz);
        while ((result = this.persisterRegistry.getPersister(pawn = classIterator.next())) == null && classIterator.hasNext()) {
        }
        return result;
    }

    public void addPersister(EntityPersister<?, ?> persister) {
        this.persisterRegistry.addPersister(persister);
    }

    public Set<EntityPersister> getPersisters() {
        return this.persisterRegistry.getPersisters();
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.configuration;
    }

    @Override
    public <C> ExecutableBeanPropertyKeyQueryMapper<C> newQuery(QueryProvider<Query> queryProvider, Class<C> beanType) {
        return this.newQuery(queryProvider.getQuery(), beanType);
    }

    @Override
    public <C> ExecutableBeanPropertyKeyQueryMapper<C> newQuery(Query query, Class<C> beanType) {
        return this.newQuery(this.dialect.getQuerySQLBuilderFactory().queryBuilder(query), beanType);
    }

    @Override
    public <C> ExecutableBeanPropertyKeyQueryMapper<C> newQuery(CharSequence sql, Class<C> beanType) {
        return this.newQuery(() -> sql, beanType);
    }

    @Override
    public <C> ExecutableBeanPropertyKeyQueryMapper<C> newQuery(SQLBuilder sql, Class<C> beanType) {
        return this.wrapIntoExecutable(this.newTransformableQuery(sql, beanType));
    }

    private <C> ExecutableBeanPropertyKeyQueryMapper<C> wrapIntoExecutable(QueryMapper<C> queryMapperSupport) {
        ExecutableBeanPropertyQueryMapper beanPropertyMappingHandler = (ExecutableBeanPropertyQueryMapper)new MethodReferenceDispatcher().redirect(ExecutableQuery::execute, accumulator -> this.execute(queryMapperSupport, (Accumulator)accumulator)).redirect(BeanPropertyQueryMapper.class, queryMapperSupport, true).build(ExecutableBeanPropertyQueryMapper.class);
        return (ExecutableBeanPropertyKeyQueryMapper)new MethodReferenceDispatcher().redirect(BeanKeyQueryMapper.class, queryMapperSupport, (Object)beanPropertyMappingHandler).redirect(ExecutableQuery::execute, accumulator -> this.execute(queryMapperSupport, (Accumulator)accumulator)).build(ExecutableBeanPropertyKeyQueryMapper.class);
    }

    private <C> QueryMapper<C> newTransformableQuery(SQLBuilder sql, Class<C> beanType) {
        return new QueryMapper<C>(beanType, sql, this.getDialect().getColumnBinderRegistry(), this.getDialect().getReadOperationFactory());
    }

    @Override
    public <C, I, T extends Table> List<C> select(SerializableFunction<I, C> factory, Column<T, I> column) {
        Executable constructor = new MethodReferenceCapturer().findExecutable(factory);
        return (List)this.newQuery(QueryEase.select(column, new Selectable[0]).from((Fromable)column.getTable()), constructor.getDeclaringClass()).mapKey((SerializableFunction)factory, column).execute(Accumulators.toList());
    }

    @Override
    public <C, I, J, T extends Table> List<C> select(SerializableBiFunction<I, J, C> factory, Column<T, I> column1, Column<T, J> column2) {
        Constructor constructor = new MethodReferenceCapturer().findConstructor(factory);
        return (List)this.newQuery(QueryEase.select(column1, column2).from((Fromable)column1.getTable()), constructor.getDeclaringClass()).mapKey((SerializableBiFunction)factory, column1, column2).execute(Accumulators.toList());
    }

    @Override
    public <C, I, J, K, T extends Table> List<C> select(SerializableTriFunction<I, J, K, C> factory, Column<T, I> column1, Column<T, J> column2, Column<T, K> column3) {
        Constructor constructor = new MethodReferenceCapturer().findConstructor(factory);
        return (List)this.newQuery(QueryEase.select(column1, column2, column3).from((Fromable)column1.getTable()), constructor.getDeclaringClass()).mapKey((SerializableTriFunction)factory, column1, column2, column3).execute(Accumulators.toList());
    }

    @Override
    public <C, T extends Table> List<C> select(SerializableSupplier<C> factory, Consumer<SelectMapping<C, T>> selectMapping) {
        return this.select(factory, selectMapping, (CriteriaChain where) -> {});
    }

    @Override
    public <C, I, T extends Table> List<C> select(SerializableFunction<I, C> factory, Column<T, I> column, Consumer<SelectMapping<C, T>> selectMapping) {
        return this.select(factory, column, selectMapping, (CriteriaChain where) -> {});
    }

    @Override
    public <C, I, J, T extends Table> List<C> select(SerializableBiFunction<I, J, C> factory, Column<T, I> column1, Column<T, J> column2, Consumer<SelectMapping<C, T>> selectMapping) {
        return this.select(factory, column1, column2, selectMapping, (CriteriaChain where) -> {});
    }

    @Override
    public <C, T extends Table> List<C> select(SerializableSupplier<C> factory, Consumer<SelectMapping<C, T>> selectMapping, Consumer<CriteriaChain> where) {
        Constructor constructor = new MethodReferenceCapturer().findConstructor(factory);
        return this.select(constructor.getDeclaringClass(), (BeanKeyQueryMapper<C> queryMapper) -> queryMapper.mapKey(factory), Collections.emptySet(), selectMapping, where);
    }

    @Override
    public <C, I, T extends Table> List<C> select(SerializableFunction<I, C> factory, Column<T, I> column, Consumer<SelectMapping<C, T>> selectMapping, Consumer<CriteriaChain> where) {
        Constructor constructor = new MethodReferenceCapturer().findConstructor(factory);
        return this.select(constructor.getDeclaringClass(), (BeanKeyQueryMapper<C> queryMapper) -> queryMapper.mapKey(factory, column), Arrays.asHashSet((Object[])new Column[]{column}), selectMapping, where);
    }

    @Override
    public <C, I, J, T extends Table> List<C> select(SerializableBiFunction<I, J, C> factory, Column<T, I> column1, Column<T, J> column2, Consumer<SelectMapping<C, T>> selectMapping, Consumer<CriteriaChain> where) {
        Constructor constructor = new MethodReferenceCapturer().findConstructor(factory);
        return this.select(constructor.getDeclaringClass(), (BeanKeyQueryMapper<C> queryMapper) -> queryMapper.mapKey(factory, column1, column2), Arrays.asHashSet((Object[])new Column[]{column1, column2}), selectMapping, where);
    }

    private <C, T extends Table> List<C> select(Class<C> beanType, Consumer<BeanKeyQueryMapper<C>> keyMapper, Set<? extends Column<?, ?>> selectableKeys, Consumer<SelectMapping<C, T>> selectMapping, Consumer<CriteriaChain> where) {
        SelectMapping selectMappingSupport = new SelectMapping();
        selectMapping.accept(selectMappingSupport);
        Table table = selectMappingSupport.getTable();
        if (table == null) {
            throw new IllegalArgumentException("Table is not defined, please add some columns to query so it can be deduced from them");
        }
        Query query = (Query)QueryEase.select(selectableKeys).from(table).getQuery();
        where.accept(query.getWhere());
        QueryMapper<C> queryMapper = this.newTransformableQuery(this.dialect.getQuerySQLBuilderFactory().queryBuilder(query), beanType);
        keyMapper.accept(queryMapper);
        selectMappingSupport.appendTo(query, queryMapper);
        return this.execute(queryMapper);
    }

    private <C> List<C> execute(QueryMapper<C> queryMapper) {
        return (List)this.execute(queryMapper, Accumulators.toList());
    }

    private <C, R> R execute(QueryMapper<C> queryMapper, Accumulator<C, ?, R> accumulator) {
        return queryMapper.execute(this.getConnectionProvider(), accumulator);
    }

    @Override
    public <T extends Table<T>> ExecutableInsert<T> insert(T table) {
        return new DefaultExecutableInsert<T>(table, this.dialect, this.getConnectionProvider());
    }

    @Override
    public <T extends Table<T>> BatchInsert<T> batchInsert(T table) {
        return new DefaultBatchInsert<T>(table, this.dialect, this.getConnectionProvider());
    }

    @Override
    public <T extends Table<T>> ExecutableUpdate<T> update(T table, Where<?> where) {
        return new DefaultExecutableUpdate<T>(table, where, this.dialect, this.getConnectionProvider());
    }

    @Override
    public <T extends Table<T>> BatchUpdate<T> batchUpdate(T table, Set<? extends Column<T, ?>> columns, Where<?> where) {
        return new DefaultBatchUpdate<T>(new Update<T>(table, columns, where), this.dialect, this.getConnectionProvider());
    }

    @Override
    public <T extends Table<T>> ExecutableDelete<T> delete(T table, Where<?> where) {
        return new DefaultExecutableDelete<T>(table, where, this.dialect, this.getConnectionProvider());
    }

    @Override
    public <T extends Table<T>> BatchDelete<T> batchDelete(T table, Where<?> where) {
        return new DefaultBatchDelete<T>(new Delete<T>(table, where), this.dialect, this.getConnectionProvider());
    }

    public static interface ExecutableBeanPropertyQueryMapper<C>
    extends ExecutableQuery<C>,
    BeanPropertyQueryMapper<C> {
        @Override
        public <I> ExecutableBeanPropertyQueryMapper<C> map(String var1, BiConsumer<C, I> var2, Class<I> var3);

        @Override
        public <I, J> ExecutableBeanPropertyQueryMapper<C> map(String var1, SerializableBiConsumer<C, J> var2, Class<I> var3, Converter<I, J> var4);

        @Override
        public <I> ExecutableBeanPropertyQueryMapper<C> map(String var1, SerializableBiConsumer<C, I> var2);

        @Override
        public <I, J> ExecutableBeanPropertyQueryMapper<C> map(String var1, SerializableBiConsumer<C, J> var2, Converter<I, J> var3);

        @Override
        public <I> ExecutableBeanPropertyQueryMapper<C> map(Column<? extends Table, I> var1, BiConsumer<C, I> var2);

        @Override
        public <I, J> ExecutableBeanPropertyQueryMapper<C> map(Column<? extends Table, I> var1, BiConsumer<C, J> var2, Converter<I, J> var3);

        @Override
        public <K, V> ExecutableBeanPropertyQueryMapper<C> map(BeanRelationFixer<C, V> var1, ResultSetRowTransformer<V, K> var2);

        @Override
        default public ExecutableBeanPropertyQueryMapper<C> map(ResultSetRowAssembler<C> assembler) {
            return this.map((ResultSetRowAssembler)assembler, WholeResultSetTransformer.AssemblyPolicy.ON_EACH_ROW);
        }

        @Override
        public ExecutableBeanPropertyQueryMapper<C> map(ResultSetRowAssembler<C> var1, WholeResultSetTransformer.AssemblyPolicy var2);

        @Override
        public ExecutableBeanPropertyQueryMapper<C> set(String var1, Object var2);

        @Override
        public <O> ExecutableBeanPropertyQueryMapper<C> set(String var1, O var2, Class<? super O> var3);

        @Override
        public <O> ExecutableBeanPropertyQueryMapper<C> set(String var1, Iterable<O> var2, Class<? super O> var3);
    }

    public static interface ExecutableBeanPropertyKeyQueryMapper<C>
    extends BeanKeyQueryMapper<C>,
    ExecutableQuery<C> {
        @Override
        public <I> ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableFunction<I, C> var1, String var2);

        @Override
        public <I, J> ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableBiFunction<I, J, C> var1, String var2, String var3);

        @Override
        public <I, J, K> ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableTriFunction<I, J, K, C> var1, String var2, String var3, String var4);

        @Override
        public ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableSupplier<C> var1);

        @Override
        public <I> ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableFunction<I, C> var1, String var2, Class<I> var3);

        @Override
        public <I, J> ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableBiFunction<I, J, C> var1, String var2, Class<I> var3, String var4, Class<J> var5);

        @Override
        public <I, J, K> ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableTriFunction<I, J, K, C> var1, String var2, Class<I> var3, String var4, Class<J> var5, String var6, Class<K> var7);

        @Override
        public <I> ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableFunction<I, C> var1, Column<? extends Table, I> var2);

        @Override
        public <I, J> ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableBiFunction<I, J, C> var1, Column<? extends Table, I> var2, Column<? extends Table, J> var3);

        @Override
        public <I, J, K> ExecutableBeanPropertyQueryMapper<C> mapKey(SerializableTriFunction<I, J, K, C> var1, Column<? extends Table, I> var2, Column<? extends Table, J> var3, Column<? extends Table, K> var4);

        @Override
        public <I> ExecutableBeanPropertyQueryMapper<I> mapKey(String var1, Class<I> var2);
    }

    public static interface CriteriaAware<T extends Table<T>, O> {
        public O where(Column<T, ?> var1, String var2);

        public O where(Column<T, ?> var1, ConditionalOperator var2);
    }

    public static interface ExecutableCriteria
    extends CriteriaChain<ExecutableCriteria>,
    ExecutableSQL {
    }

    public static interface ExecutableSQL {
        public long execute();
    }

    public static class SelectMapping<C, T extends Table> {
        private final Map<Column<Table, ?>, SerializableBiConsumer<C, ?>> mapping = new HashMap();

        public <O> SelectMapping<C, T> add(Column<T, O> column, SerializableBiConsumer<C, O> setter) {
            this.mapping.put(column, setter);
            return this;
        }

        private void appendTo(Query query, BeanPropertyQueryMapper<C> queryMapper) {
            query.select(this.mapping.keySet());
            this.mapping.forEach((k, v) -> queryMapper.map(k, v));
        }

        @javax.annotation.Nullable
        private T getTable() {
            return (T)((Table)Nullable.nullable((Object)Iterables.first(this.mapping.keySet())).map(Column::getTable).get());
        }
    }
}

