/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manyToOne;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.RuntimeMappingException;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneRelation;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetoone.FirstPhaseCycleLoadListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.SelectListenerCollection;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.PassiveJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.manytoone.ManyToOneOwnedBySourceEngine;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.bean.InstanceFieldIterator;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;

public class ManyToOneOwnedBySourceConfigurer<SRC, TRGT, SRCID, TRGTID, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>, JOINID> {
    private final ConfiguredRelationalPersister<SRC, SRCID> sourcePersister;
    private final ManyToOneRelation<SRC, TRGT, TRGTID, Collection<SRC>> manyToOneRelation;
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final Map<Column<LEFTTABLE, ?>, Column<RIGHTTABLE, ?>> keyColumnsMapping = new HashMap();
    private ManyToOneOwnedBySourceEngine<SRC, TRGT, SRCID, TRGTID, LEFTTABLE, RIGHTTABLE> engine;

    public ManyToOneOwnedBySourceConfigurer(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, ManyToOneRelation<SRC, TRGT, TRGTID, ? extends Collection<SRC>> manyToOneRelation, JoinColumnNamingStrategy joinColumnNamingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy) {
        this.sourcePersister = sourcePersister;
        this.manyToOneRelation = manyToOneRelation;
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
    }

    public String configure(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, boolean loadSeparately) {
        this.assertConfigurationIsSupported();
        EntityMapping targetMappingStrategy = targetPersister.getMapping();
        Duo<Key<LEFTTABLE, JOINID>, Key<RIGHTTABLE, JOINID>> foreignKeyColumns = this.determineForeignKeyColumns(this.sourcePersister.getMapping(), targetMappingStrategy);
        BeanRelationFixer<SRC, TRGT> beanRelationFixer = this.determineRelationFixer(targetPersister);
        String relationJoinNodeName = this.addSelectJoin(tableAlias, targetPersister, (Key)foreignKeyColumns.getLeft(), (Key)foreignKeyColumns.getRight(), beanRelationFixer, loadSeparately);
        this.addWriteCascades(targetPersister);
        return relationJoinNodeName;
    }

    public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        this.assertConfigurationIsSupported();
        EntityMapping targetMappingStrategy = targetPersister.getMapping();
        Duo<Key<LEFTTABLE, JOINID>, Key<RIGHTTABLE, JOINID>> foreignKeyColumns = this.determineForeignKeyColumns(this.sourcePersister.getMapping(), targetMappingStrategy);
        BeanRelationFixer<SRC, TRGT> beanRelationFixer = this.determineRelationFixer(targetPersister);
        this.addSelectIn2Phases(tableAlias, targetPersister, (Key)foreignKeyColumns.getLeft(), (Key)foreignKeyColumns.getRight(), firstPhaseCycleLoadListener);
        this.addWriteCascades(targetPersister);
        return new CascadeConfigurationResult<SRC, TRGT>(beanRelationFixer, this.sourcePersister);
    }

    private void assertConfigurationIsSupported() {
        CascadeOptions.RelationMode maintenanceMode = this.manyToOneRelation.getRelationMode();
        if (maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY) {
            throw new MappingConfigurationException((Object)((Object)CascadeOptions.RelationMode.ASSOCIATION_ONLY) + " is only relevant for one-to-many association");
        }
    }

    private SerializableBiConsumer<TRGT, SRC> buildReverseCombiner(Class<TRGT> targetClass) {
        Class sourceEntityType;
        InstanceFieldIterator targetFields;
        Field reverseField;
        ManyToManyRelation.MappedByConfiguration mappedByConfiguration = this.manyToOneRelation.getMappedByConfiguration();
        if (mappedByConfiguration.isEmpty()) {
            return null;
        }
        PropertyAccessor collectionAccessor = this.manyToOneRelation.buildReversePropertyAccessor();
        if (collectionAccessor == null && (reverseField = (Field)Iterables.find((Iterator)(targetFields = new InstanceFieldIterator(targetClass)), arg_0 -> ManyToOneOwnedBySourceConfigurer.lambda$buildReverseCombiner$0(sourceEntityType = this.sourcePersister.getClassToPersist(), arg_0))) != null) {
            Nullable reverseGetterMethod = Nullable.nullable((Object)Accessors.accessorByMethod((Field)reverseField));
            if (reverseGetterMethod.isPresent()) {
                collectionAccessor = new PropertyAccessor((ReversibleAccessor)reverseGetterMethod.get());
            } else {
                Nullable reverseSetterMethod = Nullable.nullable((Object)Accessors.mutatorByMethod((Field)reverseField));
                if (reverseSetterMethod.isPresent()) {
                    collectionAccessor = new PropertyAccessor((ReversibleMutator)reverseSetterMethod.get());
                }
            }
        }
        Nullable configuredCombiner = Nullable.nullable(mappedByConfiguration.getReverseCombiner());
        if (collectionAccessor == null) {
            return (SerializableBiConsumer)configuredCombiner.get();
        }
        Supplier reverseCollectionFactory = mappedByConfiguration.getReverseCollectionFactory();
        if (reverseCollectionFactory == null) {
            Class collectionType = AccessorDefinition.giveDefinition(collectionAccessor).getMemberType();
            reverseCollectionFactory = BeanRelationFixer.giveCollectionFactory((Class)collectionType);
        }
        PropertyAccessor finalCollectionAccessor = collectionAccessor;
        SerializableBiConsumer combiner = (SerializableBiConsumer)configuredCombiner.getOr((SerializableBiConsumer & Serializable)(trgt, src) -> ((Collection)finalCollectionAccessor.get(trgt)).add(src));
        Supplier effectiveCollectionFactory = reverseCollectionFactory;
        return (arg_0, arg_1) -> ManyToOneOwnedBySourceConfigurer.lambda$buildReverseCombiner$59f2ca7e$1(finalCollectionAccessor, (Supplier)effectiveCollectionFactory, combiner, arg_0, arg_1);
    }

    protected Duo<Key<LEFTTABLE, JOINID>, Key<RIGHTTABLE, JOINID>> determineForeignKeyColumns(EntityMapping<SRC, SRCID, LEFTTABLE> mappingStrategy, EntityMapping<TRGT, TRGTID, RIGHTTABLE> targetMappingStrategy) {
        boolean createForeignKey;
        PrimaryKey rightKey = targetMappingStrategy.getTargetTable().getPrimaryKey();
        Key.KeyBuilder leftKeyBuilder = Key.from((Fromable)mappingStrategy.getTargetTable());
        AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(this.manyToOneRelation.getTargetProvider());
        targetMappingStrategy.getTargetTable().getPrimaryKey().getColumns().forEach(column -> {
            String leftColumnName = this.joinColumnNamingStrategy.giveName(accessorDefinition, (Column<?, ?>)column);
            Column foreignKeyColumn = mappingStrategy.getTargetTable().addColumn(leftColumnName, column.getJavaType());
            leftKeyBuilder.addColumn((JoinLink)foreignKeyColumn);
            this.keyColumnsMapping.put((Column<LEFTTABLE, ?>)foreignKeyColumn, (Column<RIGHTTABLE, ?>)column);
        });
        Key leftKey = leftKeyBuilder.build();
        leftKey.getColumns().forEach(c -> ((Column)c).nullable(this.manyToOneRelation.isNullable()));
        boolean bl = createForeignKey = !this.manyToOneRelation.isTargetTablePerClassPolymorphic();
        if (createForeignKey) {
            String foreignKeyName = this.foreignKeyNamingStrategy.giveName(leftKey, rightKey);
            this.sourcePersister.getMapping().getTargetTable().addForeignKey(foreignKeyName, leftKey, (Key)rightKey);
        }
        return new Duo((Object)leftKey, (Object)rightKey);
    }

    protected BeanRelationFixer<SRC, TRGT> determineRelationFixer(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        Mutator targetSetter = this.manyToOneRelation.getTargetProvider().toMutator();
        SerializableBiConsumer reverseCombiner = this.buildReverseCombiner(targetPersister.getClassToPersist());
        if (reverseCombiner == null) {
            return BeanRelationFixer.of((arg_0, arg_1) -> ((Mutator)targetSetter).set(arg_0, arg_1));
        }
        return (target, input) -> {
            targetSetter.set(target, input);
            if (reverseCombiner != null) {
                reverseCombiner.accept(input, target);
            }
        };
    }

    protected void addWriteCascades(ConfiguredPersister<TRGT, TRGTID> targetPersister) {
        boolean writeAuthorized;
        this.engine = new ManyToOneOwnedBySourceEngine<SRC, TRGT, SRCID, TRGTID, LEFTTABLE, RIGHTTABLE>(this.sourcePersister, targetPersister, this.manyToOneRelation.getTargetProvider(), this.keyColumnsMapping);
        boolean orphanRemoval = this.manyToOneRelation.getRelationMode() == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL;
        boolean bl = writeAuthorized = this.manyToOneRelation.getRelationMode() != CascadeOptions.RelationMode.READ_ONLY;
        if (writeAuthorized) {
            this.addInsertCascade(targetPersister);
            this.addUpdateCascade(targetPersister, orphanRemoval);
            this.addDeleteCascade(targetPersister, orphanRemoval);
        } else {
            this.engine.addForeignKeyMaintainer();
        }
    }

    protected void addInsertCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister) {
        if (!this.manyToOneRelation.isNullable()) {
            this.sourcePersister.addInsertListener(new MandatoryRelationAssertBeforeInsertListener<SRC>(this.manyToOneRelation.getTargetProvider()));
        }
        this.engine.addInsertCascade();
    }

    protected void addUpdateCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister, boolean orphanRemoval) {
        if (!this.manyToOneRelation.isNullable()) {
            this.sourcePersister.addUpdateListener(new MandatoryRelationAssertBeforeUpdateListener<SRC>(this.manyToOneRelation.getTargetProvider()));
        }
        this.engine.addUpdateCascade(orphanRemoval);
    }

    protected void addDeleteCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister, boolean orphanRemoval) {
        this.engine.addDeleteCascade(orphanRemoval);
    }

    protected String addSelectJoin(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, Key<LEFTTABLE, JOINID> leftKey, Key<RIGHTTABLE, JOINID> rightKey, BeanRelationFixer<SRC, TRGT> beanRelationFixer, boolean loadSeparately) {
        String joinNodeName = targetPersister.joinAsOne(this.sourcePersister, (Accessor)this.manyToOneRelation.getTargetProvider(), (Key)leftKey, (Key)rightKey, tableAlias, (BeanRelationFixer)beanRelationFixer, this.manyToOneRelation.isNullable(), loadSeparately);
        SelectListenerCollection targetSelectListener = targetPersister.getPersisterListener().getSelectListener();
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>((SelectListener)targetSelectListener){
            final /* synthetic */ SelectListener val$targetSelectListener;
            {
                this.val$targetSelectListener = selectListener;
            }

            public void beforeSelect(Iterable<SRCID> ids) {
                this.val$targetSelectListener.beforeSelect(Collections.emptyList());
            }

            public void afterSelect(Set<? extends SRC> result) {
                Set collect = (Set)Iterables.collect(result, arg_0 -> ManyToOneOwnedBySourceConfigurer.this.manyToOneRelation.getTargetProvider().get(arg_0), HashSet::new);
                collect.removeIf(Objects::isNull);
                this.val$targetSelectListener.afterSelect(collect);
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.val$targetSelectListener.onSelectError(Collections.emptyList(), exception);
            }
        });
        return joinNodeName;
    }

    protected void addSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, Key<LEFTTABLE, JOINID> leftKey, Key<RIGHTTABLE, JOINID> rightKey, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        Table targetTableClone = new Table(targetPersister.getMapping().getTargetTable().getName());
        KeepOrderSet columns = rightKey.getColumns();
        columns.forEach(column -> targetTableClone.addColumn(column.getExpression(), column.getJavaType()).primaryKey());
        String joinName = this.sourcePersister.getEntityJoinTree().addPassiveJoin("ROOT", leftKey, targetTableClone.getPrimaryKey(), tableAlias, this.manyToOneRelation.isNullable() ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, (Set<? extends Selectable<?>>)targetTableClone.getPrimaryKey().getColumns(), (src, columnValueProvider) -> firstPhaseCycleLoadListener.onFirstPhaseRowRead(src, targetPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(columnValueProvider)), true);
        PassiveJoinNode passiveJoin = (PassiveJoinNode)this.sourcePersister.getEntityJoinTree().getJoin(joinName);
        targetPersister.getEntityJoinTree().foreachJoin(joinNode -> {
            if (joinNode instanceof RelationJoinNode && ((RelationJoinNode)joinNode).getEntityInflater().getEntityType() == this.sourcePersister.getClassToPersist()) {
                EntityJoinTree.cloneNodeForParent(passiveJoin, joinNode, leftKey);
            }
        });
    }

    public static RuntimeMappingException newRuntimeMappingException(Object pawn, ValueAccessPoint<?> accessor) {
        return new RuntimeMappingException("Non null value expected for relation " + AccessorDefinition.toString(accessor) + " on object " + pawn);
    }

    private static /* synthetic */ void lambda$buildReverseCombiner$59f2ca7e$1(PropertyAccessor finalCollectionAccessor, Supplier effectiveCollectionFactory, SerializableBiConsumer combiner, Object trgt, Object src) {
        if (finalCollectionAccessor.get(trgt) == null) {
            finalCollectionAccessor.set(trgt, effectiveCollectionFactory.get());
        }
        combiner.accept(trgt, src);
    }

    private static /* synthetic */ boolean lambda$buildReverseCombiner$0(Class sourceEntityType, Field field) {
        return Collection.class.isAssignableFrom(field.getType()) && ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0].equals(sourceEntityType);
    }

    public static class MandatoryRelationAssertBeforeUpdateListener<C>
    implements UpdateListener<C> {
        private final Accessor<C, ?> targetAccessor;

        public MandatoryRelationAssertBeforeUpdateListener(Accessor<C, ?> targetAccessor) {
            this.targetAccessor = targetAccessor;
        }

        public void beforeUpdate(Iterable<? extends Duo<C, C>> payloads, boolean allColumnsStatement) {
            for (Duo<C, C> payload : payloads) {
                Object modifiedEntity = payload.getLeft();
                Object modifiedTarget = this.targetAccessor.get(modifiedEntity);
                if (modifiedTarget != null) continue;
                throw ManyToOneOwnedBySourceConfigurer.newRuntimeMappingException(modifiedEntity, this.targetAccessor);
            }
        }
    }

    public static class MandatoryRelationAssertBeforeInsertListener<C>
    implements InsertListener<C> {
        private final Accessor<C, ?> targetAccessor;

        public MandatoryRelationAssertBeforeInsertListener(Accessor<C, ?> targetAccessor) {
            this.targetAccessor = targetAccessor;
        }

        public void beforeInsert(Iterable<? extends C> entities) {
            for (C pawn : entities) {
                Object modifiedTarget = this.targetAccessor.get(pawn);
                if (modifiedTarget != null) continue;
                throw ManyToOneOwnedBySourceConfigurer.newRuntimeMappingException(pawn, this.targetAccessor);
            }
        }
    }
}

