/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.statement.binder.DefaultPreparedStatementWriters;
import org.codefilarete.stalactite.sql.statement.binder.NullSafeguardPreparedStatementWriter;
import org.codefilarete.tool.function.SerializableThrowingTriConsumer;
import org.codefilarete.tool.trace.MutableBoolean;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class NullSafeguardPreparedStatementWriterTest {
    NullSafeguardPreparedStatementWriterTest() {
    }

    @Test
    void cc() {
        System.out.println(DefaultPreparedStatementWriters.SET_LONG_WRITER.getType());
    }

    @Test
    public void testSet_nonNullValueIsPassedAsArgument_delegateIsInvoked() throws SQLException {
        MutableBoolean isDelegateInvoked = new MutableBoolean(Boolean.valueOf(false));
        NullSafeguardPreparedStatementWriter testInstance = new NullSafeguardPreparedStatementWriter((SerializableThrowingTriConsumer & Serializable)(preparedStatement, valueIndex, value) -> isDelegateInvoked.setTrue());
        testInstance.set((PreparedStatement)Mockito.mock(PreparedStatement.class), 42, (Object)666);
        Assertions.assertThat((Boolean)isDelegateInvoked.getValue()).isTrue();
    }

    @Test
    public void testSet_nullIsPassedAsArgument_nonNPEIsThrown() {
        MutableBoolean isDelegateInvoked = new MutableBoolean(Boolean.valueOf(false));
        NullSafeguardPreparedStatementWriter testInstance = new NullSafeguardPreparedStatementWriter((SerializableThrowingTriConsumer & Serializable)(preparedStatement, valueIndex, value) -> isDelegateInvoked.setTrue());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.set((PreparedStatement)Mockito.mock(PreparedStatement.class), 42, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Trying to pass null as primitive value");
    }
}

