/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.model.book.AbstractEntity;
import org.codefilarete.stalactite.engine.model.book.Author;
import org.codefilarete.stalactite.engine.model.book.Book;
import org.codefilarete.stalactite.engine.runtime.PersisterWrapper;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Hanger;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportCycleTest {
    private static final Dialect DIALECT = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();

    @BeforeAll
    public static void initAllTests() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
    }

    public static class Address
    implements Identified<Long> {
        private Identifier<Long> id;
        private String location;

        public Address() {
        }

        public Address(long id) {
            this(new PersistableIdentifier<Long>(id));
        }

        public Address(Identifier<Long> id) {
            this.id = id;
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        public Address setLocation(String location) {
            this.location = location;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Address)) {
                return false;
            }
            Address address = (Address)o;
            if (!this.id.equals(address.id)) {
                return false;
            }
            return this.location.equals(address.location);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.location.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class House
    implements Identified<Long> {
        private Identifier<Long> id;
        private Person gardener;
        private Address address;
        private String name;
        private Set<Person> inhabitants = new HashSet<Person>();

        public House() {
        }

        public House(long id) {
            this(new PersistableIdentifier<Long>(id));
        }

        public House(Identifier<Long> id) {
            this.id = id;
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public Person getGardener() {
            return this.gardener;
        }

        public House setGardener(Person gardener) {
            this.gardener = gardener;
            return this;
        }

        public House addInhabitant(Person person) {
            this.inhabitants.add(person);
            return this;
        }

        public Address getAddress() {
            return this.address;
        }

        public House setAddress(Address address) {
            this.address = address;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public House setName(String name) {
            this.name = name;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof House)) {
                return false;
            }
            House house = (House)o;
            if (!this.id.equals(house.id)) {
                return false;
            }
            if (!Objects.equals(this.gardener, house.gardener)) {
                return false;
            }
            if (!Objects.equals(this.address, house.address)) {
                return false;
            }
            if (!Objects.equals(this.name, house.name)) {
                return false;
            }
            return this.inhabitants.equals(house.inhabitants);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.gardener != null ? this.gardener.hashCode() : 0);
            result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + this.inhabitants.hashCode();
            return result;
        }

        public String toString() {
            return "House{id=" + this.id + ", gardener=" + this.gardener + ", address=" + this.address + ", name=" + this.name + ", inhabitants=" + this.inhabitants + '}';
        }
    }

    @Nested
    class ManyToManyBidirectional {
        ManyToManyBidirectional() {
        }

        @Test
        void simulatedBy_one2ManyAndASelectListener() {
            EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder authorMappingConfiguration = new EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder();
            EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder bookMappingConfiguration = new EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder();
            authorMappingConfiguration.setProvider((FluentEntityMappingBuilder)MappingEase.entityBuilder(Author.class, Long.class).mapKey(AbstractEntity::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).map(Author::getName));
            bookMappingConfiguration.setProvider((FluentEntityMappingBuilder)MappingEase.entityBuilder(Book.class, Long.class).mapKey(AbstractEntity::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).mapOneToMany(Book::getAuthors, (EntityMappingConfigurationProvider)authorMappingConfiguration).map(Book::getIsbn).columnName("isbn").map(Book::getPrice).map(Book::getTitle));
            Book book1 = new Book("a first book", 24.1, "AAA-BBB-CCC");
            Book book2 = new Book("a second book", 33.5, "XXX-YYY-ZZZ");
            Author author1 = new Author("John Doe");
            Author author2 = new Author("Jane Doe");
            book1.setAuthors(Arrays.asSet((Object[])new Author[]{author1, author2}));
            book2.setAuthors(Arrays.asSet((Object[])new Author[]{author1}));
            author1.setWrittenBooks(Arrays.asSet((Object[])new Book[]{book1, book2}));
            author2.setWrittenBooks(Arrays.asSet((Object[])new Book[]{book1}));
            PersistenceContext persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportCycleTest.this.dataSource, DIALECT);
            EntityPersister bookPersister = bookMappingConfiguration.getProvider().build(persistenceContext);
            bookPersister.addSelectListener((SelectListener)new SelectListener<Book, Long>(){

                public void afterSelect(Set<? extends Book> books) {
                    books.forEach(book -> book.getAuthors().forEach(author -> {
                        if (author.getWrittenBooks() == null) {
                            author.setWrittenBooks(new HashSet<Book>());
                        }
                        author.getWrittenBooks().add((Book)book);
                    }));
                }
            });
            DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
            ddlDeployer.deployDDL();
            bookPersister.insert((Object)book1);
            bookPersister.insert((Object)book2);
            Set select = bookPersister.select((Iterable)Arrays.asSet((Object[])new Long[]{book1.getId(), book2.getId()}));
            Book loadedBook1 = (Book)Iterables.find((Iterable)select, Book::getTitle, "a first book"::equals).getLeft();
            Book loadedBook2 = (Book)Iterables.find((Iterable)select, Book::getTitle, "a second book"::equals).getLeft();
            Assertions.assertThat(loadedBook1.getAuthors()).extracting(Author::getName).containsExactlyInAnyOrder((Object[])new String[]{author1.getName(), author2.getName()});
            Assertions.assertThat(loadedBook2.getAuthors()).extracting(Author::getName).containsExactlyInAnyOrder((Object[])new String[]{author1.getName()});
            List creationScripts = ddlDeployer.getCreationScripts();
            Assertions.assertThat((List)creationScripts).containsExactlyInAnyOrder((Object[])new String[]{"create table Book_authors(book_id bigint, authors_id bigint, unique (book_id, authors_id))", "create table Author(name varchar(255), id bigint GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) not null, unique (id))", "create table Book(isbn varchar(255), price double, title varchar(255), id bigint GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) not null, unique (id))", "alter table Book_authors add constraint FK_Book_authors_authors_id_Author_id foreign key(authors_id) references Author(id)", "alter table Book_authors add constraint FK_Book_authors_book_id_Book_id foreign key(book_id) references Book(id)"});
        }
    }

    public static class Person
    implements Identified<Long> {
        private Identifier<Long> id;
        private String name;
        private Person partner;
        private Person father;
        private final Set<Person> children = new HashSet<Person>();
        private Person directNeighbor;
        private final Set<Person> neighbours = new HashSet<Person>();
        private House house;
        private House house1;

        public Person() {
        }

        public Person(long id) {
            this(new PersistableIdentifier<Long>(id));
        }

        public Person(Identifier<Long> id) {
            this.id = id;
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Person getPartner() {
            return this.partner;
        }

        public Person setPartner(Person partner) {
            this.partner = partner;
            return this;
        }

        public Person getFather() {
            return this.father;
        }

        public Person setFather(Person father) {
            this.father = father;
            return this;
        }

        public Set<Person> getChildren() {
            return this.children;
        }

        public void addChild(Person person) {
            this.children.add(person);
        }

        public Person setDirectNeighbor(Person directNeighbor) {
            this.directNeighbor = directNeighbor;
            return this;
        }

        public Set<Person> getNeighbours() {
            return this.neighbours;
        }

        public void addNeighbor(Person neighbour) {
            this.neighbours.add(neighbour);
        }

        public House getHouse() {
            return this.house;
        }

        public Person setHouse(House house) {
            this.house = house;
            return this;
        }

        public House getHouse1() {
            return this.house1;
        }

        public Person setHouse1(House house) {
            this.house1 = house;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Person)) {
                return false;
            }
            Person person = (Person)o;
            if (!this.id.equals(person.id)) {
                return false;
            }
            if (!Objects.equals(this.name, person.name)) {
                return false;
            }
            if (!Objects.equals(this.partner, person.partner)) {
                return false;
            }
            return Objects.equals(this.father, person.father);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.partner != null ? this.partner.hashCode() : 0);
            result = 31 * result + (this.father != null ? this.father.hashCode() : 0);
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    @Nested
    public class ManyToMany {
        private PersistenceContext persistenceContext;
        private FluentEntityMappingBuilder<Person, Identifier<Long>> personMappingConfiguration;

        @BeforeEach
        public void initTest() {
            this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportCycleTest.this.dataSource, DIALECT);
            this.personMappingConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapManyToMany(Person::getChildren, () -> this.personMappingConfiguration.getConfiguration());
        }

        @Test
        void insertSelect_cycleIsDirect_1Parent_1Child() {
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(loadedPerson.getChildren()).isEqualTo(johnDo.getChildren());
        }

        @Test
        void insertSelect_cycleIsDirect_1Parent_2Children() {
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            Person child2 = new Person(888L);
            child2.setName("Ban Do");
            johnDo.addChild(child2);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(loadedPerson.getChildren()).isEqualTo(johnDo.getChildren());
        }

        @Test
        void insertSelect_sibling() {
            this.personMappingConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapManyToMany(Person::getChildren, () -> this.personMappingConfiguration.getConfiguration()).mapManyToMany(Person::getNeighbours, () -> this.personMappingConfiguration.getConfiguration());
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            Person child2 = new Person(888L);
            child2.setName("Ban Do");
            johnDo.addChild(child2);
            Person neighbour1 = new Person(123L);
            neighbour1.setName("Saca Do");
            johnDo.addNeighbor(neighbour1);
            neighbour1.setDirectNeighbor(johnDo);
            Person neighbour2 = new Person(456L);
            neighbour2.setName("Ban Do");
            johnDo.addNeighbor(neighbour2);
            neighbour2.setDirectNeighbor(johnDo);
            personPersister.insert((Object)johnDo);
            final ArrayList capturedValues = new ArrayList();
            final ArrayList capturedSQL = new ArrayList();
            ((SimpleRelationalEntityPersister)((PersisterWrapper)personPersister).getDeepestDelegate()).getEntityFinder().setOperationListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<Integer>(){

                public void onValuesSet(Map<Integer, ?> values) {
                    capturedValues.add(values);
                }

                public void onExecute(SQLStatement<Integer> sqlStatement) {
                    capturedSQL.add(sqlStatement.getSQL());
                }
            });
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(johnDo.getChildren()).containsExactlyInAnyOrderElementsOf(loadedPerson.getChildren());
            Assertions.assertThat(capturedSQL).containsExactly((Object[])new String[]{"select Person.name as Person_name, Person.id as Person_id, Person_children.children_id as Person_children_children_id, Person_neighbours.neighbours_id as Person_neighbours_neighbours_id from Person left outer join Person_children as Person_children on Person.id = Person_children.person_id left outer join Person_neighbours as Person_neighbours on Person.id = Person_neighbours.person_id where Person.id in (?)", "select Person.name as Person_name, Person.id as Person_id, Person_children.children_id as Person_children_children_id, Person_neighbours.neighbours_id as Person_neighbours_neighbours_id from Person left outer join Person_children as Person_children on Person.id = Person_children.person_id left outer join Person_neighbours as Person_neighbours on Person.id = Person_neighbours.person_id where Person.id in (?, ?, ?, ?)"});
            Assertions.assertThat(capturedValues).containsExactly((Object[])new Map[]{Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(42L)), Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(888L)).add((Object)2, new PersistedIdentifier<Long>(456L)).add((Object)3, new PersistedIdentifier<Long>(666L)).add((Object)4, new PersistedIdentifier<Long>(123L))});
        }

        @Test
        void insertSelect_cycleIsDirect() {
            this.personMappingConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapManyToMany(Person::getChildren, () -> this.personMappingConfiguration.getConfiguration()).mapManyToMany(Person::getNeighbours, () -> this.personMappingConfiguration.getConfiguration());
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            Person child2 = new Person(888L);
            child2.setName("Ban Do");
            johnDo.addChild(child2);
            Person neighbour1 = new Person(123L);
            neighbour1.setName("Saca Do");
            johnDo.addNeighbor(neighbour1);
            neighbour1.setDirectNeighbor(johnDo);
            Person neighbour2 = new Person(456L);
            neighbour2.setName("Ban Do");
            johnDo.addNeighbor(neighbour2);
            neighbour2.setDirectNeighbor(johnDo);
            personPersister.insert((Object)johnDo);
            final ArrayList capturedValues = new ArrayList();
            final ArrayList capturedSQL = new ArrayList();
            ((SimpleRelationalEntityPersister)((PersisterWrapper)personPersister).getDeepestDelegate()).getEntityFinder().setOperationListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<Integer>(){

                public void onValuesSet(Map<Integer, ?> values) {
                    capturedValues.add(values);
                }

                public void onExecute(SQLStatement<Integer> sqlStatement) {
                    capturedSQL.add(sqlStatement.getSQL());
                }
            });
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(johnDo.getChildren()).containsExactlyInAnyOrderElementsOf(loadedPerson.getChildren());
            Assertions.assertThat(capturedSQL).containsExactly((Object[])new String[]{"select Person.name as Person_name, Person.id as Person_id, Person_children.children_id as Person_children_children_id, Person_neighbours.neighbours_id as Person_neighbours_neighbours_id from Person left outer join Person_children as Person_children on Person.id = Person_children.person_id left outer join Person_neighbours as Person_neighbours on Person.id = Person_neighbours.person_id where Person.id in (?)", "select Person.name as Person_name, Person.id as Person_id, Person_children.children_id as Person_children_children_id, Person_neighbours.neighbours_id as Person_neighbours_neighbours_id from Person left outer join Person_children as Person_children on Person.id = Person_children.person_id left outer join Person_neighbours as Person_neighbours on Person.id = Person_neighbours.person_id where Person.id in (?, ?, ?, ?)"});
            Assertions.assertThat(capturedValues).containsExactly((Object[])new Map[]{Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(42L)), Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(888L)).add((Object)2, new PersistedIdentifier<Long>(456L)).add((Object)3, new PersistedIdentifier<Long>(666L)).add((Object)4, new PersistedIdentifier<Long>(123L))});
        }
    }

    @Nested
    public class OneToMany {
        private PersistenceContext persistenceContext;
        private FluentEntityMappingBuilder<Person, Identifier<Long>> personMappingConfiguration;

        @BeforeEach
        public void initTest() {
            this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportCycleTest.this.dataSource, DIALECT);
            this.personMappingConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToMany(Person::getChildren, () -> this.personMappingConfiguration.getConfiguration());
        }

        @Test
        void insertSelect_cycleIsDirect_withAssociationTable_1Parent_1Child() {
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(loadedPerson.getChildren()).isEqualTo(johnDo.getChildren());
        }

        @Test
        void insertSelect_cycleIsDirect_withAssociationTable_1Parent_2Children() {
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            Person child2 = new Person(888L);
            child2.setName("Ban Do");
            johnDo.addChild(child2);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(loadedPerson.getChildren()).isEqualTo(johnDo.getChildren());
        }

        @Test
        void insertSelect_cycleIsDirect_ownedByReverseSide_1Parent_2Children() {
            this.personMappingConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToMany(Person::getChildren, () -> this.personMappingConfiguration.getConfiguration()).mappedBy(Person::getFather);
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            child1.setFather(johnDo);
            Person child2 = new Person(888L);
            child2.setName("Ban Do");
            johnDo.addChild(child2);
            child2.setFather(johnDo);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(johnDo.getChildren()).containsExactlyElementsOf(loadedPerson.getChildren());
        }

        @Test
        void insertSelect_sibling_withAssociationTable() {
            this.personMappingConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToMany(Person::getChildren, () -> this.personMappingConfiguration.getConfiguration()).reverselySetBy(Person::setFather).mapOneToMany(Person::getNeighbours, () -> this.personMappingConfiguration.getConfiguration()).reverselySetBy(Person::setDirectNeighbor);
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            child1.setFather(johnDo);
            Person child2 = new Person(888L);
            child2.setName("Ban Do");
            johnDo.addChild(child2);
            child2.setFather(johnDo);
            Person neighbour1 = new Person(123L);
            neighbour1.setName("Saca Do");
            johnDo.addNeighbor(neighbour1);
            neighbour1.setDirectNeighbor(johnDo);
            Person neighbour2 = new Person(456L);
            neighbour2.setName("Ban Do");
            johnDo.addNeighbor(neighbour2);
            neighbour2.setDirectNeighbor(johnDo);
            personPersister.insert((Object)johnDo);
            final ArrayList capturedValues = new ArrayList();
            final ArrayList capturedSQL = new ArrayList();
            ((SimpleRelationalEntityPersister)((PersisterWrapper)personPersister).getDeepestDelegate()).getEntityFinder().setOperationListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<Integer>(){

                public void onValuesSet(Map<Integer, ?> values) {
                    capturedValues.add(values);
                }

                public void onExecute(SQLStatement<Integer> sqlStatement) {
                    capturedSQL.add(sqlStatement.getSQL());
                }
            });
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(johnDo.getChildren()).containsExactlyElementsOf(loadedPerson.getChildren());
            Assertions.assertThat(capturedSQL).containsExactly((Object[])new String[]{"select Person.name as Person_name, Person.id as Person_id, Person_children.children_id as Person_children_children_id, Person_neighbours.neighbours_id as Person_neighbours_neighbours_id from Person left outer join Person_children as Person_children on Person.id = Person_children.person_id left outer join Person_neighbours as Person_neighbours on Person.id = Person_neighbours.person_id where Person.id in (?)", "select Person.name as Person_name, Person.id as Person_id, Person_children.children_id as Person_children_children_id, Person_neighbours.neighbours_id as Person_neighbours_neighbours_id from Person left outer join Person_children as Person_children on Person.id = Person_children.person_id left outer join Person_neighbours as Person_neighbours on Person.id = Person_neighbours.person_id where Person.id in (?, ?, ?, ?)"});
            Assertions.assertThat(capturedValues).containsExactly((Object[])new Map[]{Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(42L)), Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(888L)).add((Object)2, new PersistedIdentifier<Long>(456L)).add((Object)3, new PersistedIdentifier<Long>(666L)).add((Object)4, new PersistedIdentifier<Long>(123L))});
        }

        @Test
        void insertSelect_sibling_ownedByTarget() {
            this.personMappingConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToMany(Person::getChildren, () -> this.personMappingConfiguration.getConfiguration()).mappedBy(Person::setFather).mapOneToMany(Person::getNeighbours, () -> this.personMappingConfiguration.getConfiguration()).mappedBy(Person::setDirectNeighbor);
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            child1.setFather(johnDo);
            Person child2 = new Person(888L);
            child2.setName("Ban Do");
            johnDo.addChild(child2);
            child2.setFather(johnDo);
            Person neighbour1 = new Person(123L);
            neighbour1.setName("Saca Do");
            johnDo.addNeighbor(neighbour1);
            neighbour1.setDirectNeighbor(johnDo);
            Person neighbour2 = new Person(456L);
            neighbour2.setName("Ban Do");
            johnDo.addNeighbor(neighbour2);
            neighbour2.setDirectNeighbor(johnDo);
            personPersister.insert((Object)johnDo);
            final ArrayList capturedValues = new ArrayList();
            final ArrayList capturedSQL = new ArrayList();
            ((SimpleRelationalEntityPersister)((PersisterWrapper)personPersister).getDeepestDelegate()).getEntityFinder().setOperationListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<Integer>(){

                public void onValuesSet(Map<Integer, ?> values) {
                    capturedValues.add(values);
                }

                public void onExecute(SQLStatement<Integer> sqlStatement) {
                    capturedSQL.add(sqlStatement.getSQL());
                }
            });
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(johnDo.getChildren()).containsExactlyElementsOf(loadedPerson.getChildren());
            Assertions.assertThat(capturedSQL).containsExactly((Object[])new String[]{"select Person.name as Person_name, Person.id as Person_id, Person_children.id as Person_children_id, Person_neighbours.id as Person_neighbours_id from Person left outer join Person as Person_children on Person.id = Person_children.fatherId left outer join Person as Person_neighbours on Person.id = Person_neighbours.directNeighborId where Person.id in (?)", "select Person.name as Person_name, Person.id as Person_id, Person_children.id as Person_children_id, Person_neighbours.id as Person_neighbours_id from Person left outer join Person as Person_children on Person.id = Person_children.fatherId left outer join Person as Person_neighbours on Person.id = Person_neighbours.directNeighborId where Person.id in (?, ?, ?, ?)"});
            Assertions.assertThat(capturedValues).containsExactly((Object[])new Map[]{Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(42L)), Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(888L)).add((Object)2, new PersistedIdentifier<Long>(456L)).add((Object)3, new PersistedIdentifier<Long>(666L)).add((Object)4, new PersistedIdentifier<Long>(123L))});
        }

        @Test
        void insertSelect_cycleIsDirect_withAssociationTable() {
            this.personMappingConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToMany(Person::getChildren, () -> this.personMappingConfiguration.getConfiguration()).reverselySetBy(Person::setFather).mapOneToMany(Person::getNeighbours, () -> this.personMappingConfiguration.getConfiguration()).reverselySetBy(Person::setDirectNeighbor);
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            child1.setFather(johnDo);
            Person child2 = new Person(888L);
            child2.setName("Ban Do");
            johnDo.addChild(child2);
            child2.setFather(johnDo);
            Person neighbour1 = new Person(123L);
            neighbour1.setName("Saca Do");
            johnDo.addNeighbor(neighbour1);
            neighbour1.setDirectNeighbor(johnDo);
            Person neighbour2 = new Person(456L);
            neighbour2.setName("Ban Do");
            johnDo.addNeighbor(neighbour2);
            neighbour2.setDirectNeighbor(johnDo);
            personPersister.insert((Object)johnDo);
            final ArrayList capturedValues = new ArrayList();
            final ArrayList capturedSQL = new ArrayList();
            ((SimpleRelationalEntityPersister)((PersisterWrapper)personPersister).getDeepestDelegate()).getEntityFinder().setOperationListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<Integer>(){

                public void onValuesSet(Map<Integer, ?> values) {
                    capturedValues.add(values);
                }

                public void onExecute(SQLStatement<Integer> sqlStatement) {
                    capturedSQL.add(sqlStatement.getSQL());
                }
            });
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(johnDo.getChildren()).containsExactlyInAnyOrderElementsOf(loadedPerson.getChildren());
            Assertions.assertThat(capturedSQL).containsExactly((Object[])new String[]{"select Person.name as Person_name, Person.id as Person_id, Person_children.children_id as Person_children_children_id, Person_neighbours.neighbours_id as Person_neighbours_neighbours_id from Person left outer join Person_children as Person_children on Person.id = Person_children.person_id left outer join Person_neighbours as Person_neighbours on Person.id = Person_neighbours.person_id where Person.id in (?)", "select Person.name as Person_name, Person.id as Person_id, Person_children.children_id as Person_children_children_id, Person_neighbours.neighbours_id as Person_neighbours_neighbours_id from Person left outer join Person_children as Person_children on Person.id = Person_children.person_id left outer join Person_neighbours as Person_neighbours on Person.id = Person_neighbours.person_id where Person.id in (?, ?, ?, ?)"});
            Assertions.assertThat(capturedValues).containsExactly((Object[])new Map[]{Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(42L)), Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(888L)).add((Object)2, new PersistedIdentifier<Long>(456L)).add((Object)3, new PersistedIdentifier<Long>(666L)).add((Object)4, new PersistedIdentifier<Long>(123L))});
        }

        @Test
        void insertSelect_cycleIsDirect_ownedByTarget() {
            this.personMappingConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToMany(Person::getChildren, () -> this.personMappingConfiguration.getConfiguration()).mappedBy(Person::setFather).mapOneToMany(Person::getNeighbours, () -> this.personMappingConfiguration.getConfiguration()).mappedBy(Person::setDirectNeighbor);
            EntityPersister personPersister = this.personMappingConfiguration.build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person child1 = new Person(666L);
            child1.setName("Saca Do");
            johnDo.addChild(child1);
            child1.setFather(johnDo);
            Person child2 = new Person(888L);
            child2.setName("Ban Do");
            johnDo.addChild(child2);
            child2.setFather(johnDo);
            Person neighbour1 = new Person(123L);
            neighbour1.setName("Saca Do");
            johnDo.addNeighbor(neighbour1);
            neighbour1.setDirectNeighbor(johnDo);
            Person neighbour2 = new Person(456L);
            neighbour2.setName("Ban Do");
            johnDo.addNeighbor(neighbour2);
            neighbour2.setDirectNeighbor(johnDo);
            personPersister.insert((Object)johnDo);
            final ArrayList capturedValues = new ArrayList();
            final ArrayList capturedSQL = new ArrayList();
            ((SimpleRelationalEntityPersister)((PersisterWrapper)personPersister).getDeepestDelegate()).getEntityFinder().setOperationListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<Integer>(){

                public void onValuesSet(Map<Integer, ?> values) {
                    capturedValues.add(values);
                }

                public void onExecute(SQLStatement<Integer> sqlStatement) {
                    capturedSQL.add(sqlStatement.getSQL());
                }
            });
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(johnDo.getChildren()).containsExactlyInAnyOrderElementsOf(loadedPerson.getChildren());
            Assertions.assertThat(capturedSQL).containsExactly((Object[])new String[]{"select Person.name as Person_name, Person.id as Person_id, Person_children.id as Person_children_id, Person_neighbours.id as Person_neighbours_id from Person left outer join Person as Person_children on Person.id = Person_children.fatherId left outer join Person as Person_neighbours on Person.id = Person_neighbours.directNeighborId where Person.id in (?)", "select Person.name as Person_name, Person.id as Person_id, Person_children.id as Person_children_id, Person_neighbours.id as Person_neighbours_id from Person left outer join Person as Person_children on Person.id = Person_children.fatherId left outer join Person as Person_neighbours on Person.id = Person_neighbours.directNeighborId where Person.id in (?, ?, ?, ?)"});
            Assertions.assertThat(capturedValues).containsExactly((Object[])new Map[]{Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(42L)), Maps.forHashMap(Integer.class, Object.class).add((Object)1, new PersistedIdentifier<Long>(888L)).add((Object)2, new PersistedIdentifier<Long>(456L)).add((Object)3, new PersistedIdentifier<Long>(666L)).add((Object)4, new PersistedIdentifier<Long>(123L))});
        }
    }

    @Nested
    public class OneToOne {
        private PersistenceContext persistenceContext;

        @BeforeEach
        public void initTest() {
            this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportCycleTest.this.dataSource, DIALECT);
        }

        @Test
        void crud_cycleWithIntermediary_ownedBySource() {
            EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder personMappingConfiguration = new EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder();
            personMappingConfiguration.setProvider((FluentEntityMappingBuilder)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Identifier.LONG_TYPE).mapKey(House::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(House::getAddress, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Address::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getLocation)).mapOneToOne(House::getGardener, (EntityMappingConfigurationProvider)personMappingConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL));
            EntityPersister personPersister = personMappingConfiguration.getProvider().build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            House house = new House(123L);
            house.setAddress(new Address(456L).setLocation("Somewhere in the world"));
            johnDo.setHouse(house);
            Person myGardener = new Person(888L);
            myGardener.setName("Poppy");
            house.setGardener(myGardener);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Object)loadedPerson.getHouse().getGardener()).isEqualTo((Object)johnDo.getHouse().getGardener());
            Person newGardener = new Person(999L);
            newGardener.setName("Dandelion");
            johnDo.getHouse().setGardener(newGardener);
            personPersister.update((Object)johnDo, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Long)((Long)loadedPerson.getHouse().getGardener().getId().getDelegate())).isEqualTo(999L);
            Assertions.assertThat((String)loadedPerson.getHouse().getGardener().getName()).isEqualTo("Dandelion");
            personPersister.delete((Object)johnDo);
            Set allPersons = (Set)this.persistenceContext.newQuery((CharSequence)"select id from Person", Long.class).mapKey(Long::new, "id", Long.TYPE).execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allPersons).isEmpty();
        }

        @Test
        void crud_cycleWithIntermediary_ownedByTarget() {
            Table personTable = new Table("Person");
            Column reverseGardenerId = personTable.addColumn("reverseGardenerId", Identifier.LONG_TYPE);
            Hanger.Holder personMappingConfiguration = new Hanger.Holder();
            personMappingConfiguration.set((Object)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).onTable(personTable).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Identifier.LONG_TYPE).mapKey(House::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(House::getAddress, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Address::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getLocation)).mapOneToOne(House::getGardener, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).mappedBy(reverseGardenerId).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL));
            EntityPersister personPersister = ((FluentEntityMappingBuilder)personMappingConfiguration.get()).build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            House house = new House(123L);
            house.setAddress(new Address(456L).setLocation("Somewhere in the world"));
            johnDo.setHouse(house);
            Person myGardener = new Person(888L);
            myGardener.setName("Poppy");
            house.setGardener(myGardener);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Object)loadedPerson.getHouse().getGardener()).isEqualTo((Object)johnDo.getHouse().getGardener());
            Person newGardener = new Person(999L);
            newGardener.setName("Dandelion");
            johnDo.getHouse().setGardener(newGardener);
            personPersister.update((Object)johnDo, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Long)((Long)loadedPerson.getHouse().getGardener().getId().getDelegate())).isEqualTo(999L);
            Assertions.assertThat((String)loadedPerson.getHouse().getGardener().getName()).isEqualTo("Dandelion");
            personPersister.delete((Object)johnDo);
            Set allPersons = (Set)this.persistenceContext.newQuery((CharSequence)"select id from Person", Long.class).mapKey(Long::new, "id", Long.TYPE).execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allPersons).isEmpty();
        }

        @Test
        void insertSelect_cycleIsDirect_ownedBySource() {
            Hanger.Holder personMappingConfiguration = new Hanger.Holder();
            personMappingConfiguration.set((Object)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getPartner, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()));
            EntityPersister personPersister = ((FluentEntityMappingBuilder)personMappingConfiguration.get()).build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person partner = new Person(666L);
            partner.setName("Saca Do");
            johnDo.setPartner(partner);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getPartner()).isEqualTo((Object)johnDo.getPartner());
        }

        @Test
        void insertSelect_cycleIsDirect_ownedByTarget() {
            Table personTable = new Table("Person");
            Column reversePartnerId = personTable.addColumn("reversePartnerId", Identifier.LONG_TYPE);
            Hanger.Holder personMappingConfiguration = new Hanger.Holder();
            personMappingConfiguration.set((Object)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).onTable(personTable).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getPartner, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).mappedBy(reversePartnerId));
            EntityPersister personPersister = ((FluentEntityMappingBuilder)personMappingConfiguration.get()).build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person partner = new Person(666L);
            partner.setName("Saca Do");
            johnDo.setPartner(partner);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)johnDo);
            Assertions.assertThat((Object)loadedPerson.getPartner()).isEqualTo((Object)johnDo.getPartner());
        }

        @Test
        void crud_2cycles_ownedBySource() {
            Hanger.Holder personMappingConfiguration = new Hanger.Holder();
            personMappingConfiguration.set((Object)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getPartner, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Identifier.LONG_TYPE).mapKey(House::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(House::getAddress, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Address::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getLocation)).mapOneToOne(House::getGardener, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL));
            EntityPersister personPersister = ((FluentEntityMappingBuilder)personMappingConfiguration.get()).build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person partner = new Person(666L);
            partner.setName("Saca Do");
            johnDo.setPartner(partner);
            House house = new House(123L);
            house.setAddress(new Address(456L).setLocation("Somewhere in the world"));
            johnDo.setHouse(house);
            Person myGardener = new Person(888L);
            myGardener.setName("Poppy");
            house.setGardener(myGardener);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getPartner()).isEqualTo((Object)johnDo.getPartner());
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Object)loadedPerson.getHouse().getGardener()).isEqualTo((Object)johnDo.getHouse().getGardener());
            Person newGardener = new Person(999L);
            newGardener.setName("Dandelion");
            johnDo.getHouse().setGardener(newGardener);
            personPersister.update((Object)johnDo, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Long)((Long)loadedPerson.getHouse().getGardener().getId().getDelegate())).isEqualTo(999L);
            Assertions.assertThat((String)loadedPerson.getHouse().getGardener().getName()).isEqualTo("Dandelion");
            personPersister.delete((Object)johnDo);
            Set allPersons = (Set)this.persistenceContext.newQuery((CharSequence)"select id from Person", Long.class).mapKey(Long::new, "id", Long.TYPE).execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allPersons).containsExactlyInAnyOrder((Object[])new Long[]{666L});
        }

        @Test
        void crud_2cycles_ownedByTarget() {
            Table personTable = new Table("Person");
            Column reversePartnerId = personTable.addColumn("reversePartnerId", Identifier.LONG_TYPE);
            Hanger.Holder personMappingConfiguration = new Hanger.Holder();
            personMappingConfiguration.set((Object)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).onTable(personTable).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getPartner, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).mappedBy(reversePartnerId).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Identifier.LONG_TYPE).mapKey(House::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(House::getAddress, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Address::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getLocation)).mapOneToOne(House::getGardener, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL));
            EntityPersister personPersister = ((FluentEntityMappingBuilder)personMappingConfiguration.get()).build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person partner = new Person(666L);
            partner.setName("Saca Do");
            johnDo.setPartner(partner);
            House house = new House(123L);
            house.setAddress(new Address(456L).setLocation("Somewhere in the world"));
            johnDo.setHouse(house);
            Person myGardener = new Person(888L);
            myGardener.setName("Poppy");
            house.setGardener(myGardener);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getPartner()).isEqualTo((Object)johnDo.getPartner());
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Object)loadedPerson.getHouse().getGardener()).isEqualTo((Object)johnDo.getHouse().getGardener());
            Person newGardener = new Person(999L);
            newGardener.setName("Dandelion");
            johnDo.getHouse().setGardener(newGardener);
            personPersister.update((Object)johnDo, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Long)((Long)loadedPerson.getHouse().getGardener().getId().getDelegate())).isEqualTo(999L);
            Assertions.assertThat((String)loadedPerson.getHouse().getGardener().getName()).isEqualTo("Dandelion");
            personPersister.delete((Object)johnDo);
            Set allPersons = (Set)this.persistenceContext.newQuery((CharSequence)"select id from Person", Long.class).mapKey(Long::new, "id", Long.TYPE).execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allPersons).containsExactlyInAnyOrder((Object[])new Long[]{666L});
        }

        @Test
        void crud_2cycles_ownedBySource_entityCycle() {
            Hanger.Holder personMappingConfiguration = new Hanger.Holder();
            personMappingConfiguration.set((Object)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getPartner, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Identifier.LONG_TYPE).mapKey(House::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(House::getAddress, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Address::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getLocation)).mapOneToOne(House::getGardener, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL));
            EntityPersister personPersister = ((FluentEntityMappingBuilder)personMappingConfiguration.get()).build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person partner = new Person(666L);
            partner.setName("Saca Do");
            johnDo.setPartner(partner);
            House house = new House(123L);
            house.setAddress(new Address(456L).setLocation("Somewhere in the world"));
            johnDo.setHouse(house);
            house.setGardener(partner);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getPartner()).isEqualTo((Object)johnDo.getPartner());
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Object)loadedPerson.getHouse().getGardener()).isEqualTo((Object)johnDo.getHouse().getGardener());
            Assertions.assertThat((Object)loadedPerson.getHouse().getGardener()).isSameAs((Object)loadedPerson.getPartner());
        }

        @Test
        void crud_2cycles_ownedByTarget_entityCycle() {
            Table personTable = new Table("Person");
            Column reversePartnerId = personTable.addColumn("reversePartnerId", Identifier.LONG_TYPE);
            Hanger.Holder personMappingConfiguration = new Hanger.Holder();
            personMappingConfiguration.set((Object)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).onTable(personTable).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getPartner, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).mappedBy(reversePartnerId).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Identifier.LONG_TYPE).mapKey(House::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(House::getAddress, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Address::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getLocation)).mapOneToOne(House::getGardener, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).onTable(personTable)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL));
            EntityPersister personPersister = ((FluentEntityMappingBuilder)personMappingConfiguration.get()).build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person partner = new Person(666L);
            partner.setName("Saca Do");
            johnDo.setPartner(partner);
            House house = new House(123L);
            house.setAddress(new Address(456L).setLocation("Somewhere in the world"));
            johnDo.setHouse(house);
            house.setGardener(partner);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getPartner()).isEqualTo((Object)johnDo.getPartner());
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Object)loadedPerson.getHouse().getGardener()).isEqualTo((Object)johnDo.getHouse().getGardener());
            Assertions.assertThat((Object)loadedPerson.getHouse().getGardener()).isSameAs((Object)loadedPerson.getPartner());
        }

        @Test
        void crud_2cycles_sibling() {
            Table personTable = new Table("Person");
            Hanger.Holder personMappingConfiguration = new Hanger.Holder();
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions houseMapping = MappingEase.entityBuilder(House.class, Identifier.LONG_TYPE).mapKey(House::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(House::getName);
            personMappingConfiguration.set((Object)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).onTable(personTable).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)houseMapping).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapOneToOne(Person::getHouse1, (EntityMappingConfigurationProvider)houseMapping).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL));
            EntityPersister personPersister = ((FluentEntityMappingBuilder)personMappingConfiguration.get()).build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            House house = new House(123L);
            house.setName("main house");
            johnDo.setHouse(house);
            House house1 = new House(456L);
            house1.setName("secondary house");
            johnDo.setHouse1(house1);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Object)loadedPerson.getHouse1()).isEqualTo((Object)johnDo.getHouse1());
            johnDo.getHouse().setName("new main house name");
            personPersister.update((Object)johnDo, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
        }

        @Test
        void crud_2cycles_sibling_ownedByTarget() {
            Table personTable = new Table("Person");
            Column reversePartnerId = personTable.addColumn("reversePartnerId", Identifier.LONG_TYPE);
            Hanger.Holder personMappingConfiguration = new Hanger.Holder();
            FluentEntityMappingBuilder.FluentMappingBuilderOneToOneOptions houseMapping = MappingEase.entityBuilder(House.class, Identifier.LONG_TYPE).mapKey(House::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(House::getAddress, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Address::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getLocation)).mapOneToOne(House::getGardener, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL);
            personMappingConfiguration.set((Object)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).onTable(personTable).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapOneToOne(Person::getPartner, () -> ((FluentEntityMappingBuilder)personMappingConfiguration.get()).getConfiguration()).mappedBy(reversePartnerId).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)houseMapping).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapOneToOne(Person::getHouse1, (EntityMappingConfigurationProvider)houseMapping).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL));
            EntityPersister personPersister = ((FluentEntityMappingBuilder)personMappingConfiguration.get()).build(this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Person johnDo = new Person(42L);
            johnDo.setName("John Do");
            Person partner = new Person(666L);
            partner.setName("Saca Do");
            johnDo.setPartner(partner);
            House house = new House(123L);
            house.setAddress(new Address(321L).setLocation("Somewhere in the world"));
            johnDo.setHouse(house);
            Person myGardener = new Person(888L);
            myGardener.setName("Poppy");
            house.setGardener(myGardener);
            House house1 = new House(456L);
            house1.setAddress(new Address(654L).setLocation("Somewhere else in the world"));
            johnDo.setHouse1(house1);
            Person myGardener1 = new Person(999L);
            myGardener1.setName("Daffodil");
            house1.setGardener(myGardener1);
            personPersister.insert((Object)johnDo);
            Person loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getPartner()).isEqualTo((Object)johnDo.getPartner());
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Object)loadedPerson.getHouse1()).isEqualTo((Object)johnDo.getHouse1());
            Assertions.assertThat((Object)loadedPerson.getHouse().getGardener()).isEqualTo((Object)johnDo.getHouse().getGardener());
            Person newGardener = new Person(new PersistedIdentifier<Long>(999L));
            newGardener.setName("Dandelion");
            johnDo.getHouse1().setGardener(newGardener);
            personPersister.update((Object)johnDo, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedPerson.getHouse()).isEqualTo((Object)johnDo.getHouse());
            Assertions.assertThat((Long)((Long)loadedPerson.getHouse1().getGardener().getId().getDelegate())).isEqualTo(999L);
            Assertions.assertThat((String)loadedPerson.getHouse1().getGardener().getName()).isEqualTo("Dandelion");
            personPersister.delete((Object)johnDo);
            Set allPersons = (Set)this.persistenceContext.newQuery((CharSequence)"select id from Person", Long.class).mapKey(Long::new, "id", Long.TYPE).execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allPersons).containsExactlyInAnyOrder((Object[])new Long[]{666L});
        }
    }
}

