/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.idprovider.LongProvider;
import org.codefilarete.stalactite.engine.model.book.AbstractEntity;
import org.codefilarete.stalactite.engine.model.book.Author;
import org.codefilarete.stalactite.engine.model.book.Book;
import org.codefilarete.stalactite.engine.runtime.OptimizedUpdatePersister;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.SerializableTriFunction;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class FluentEntityMappingConfigurationSupportManyToManyTest {
    private static final Dialect DIALECT = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private static FluentEntityMappingBuilder<Choice, Identifier<Long>> CHOICE_MAPPING_CONFIGURATION;
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private final ConnectionProvider connectionProvider = new CurrentThreadConnectionProvider(this.dataSource);
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportManyToManyTest() {
    }

    @BeforeAll
    static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
    }

    @BeforeEach
    void beforeTest() {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, DIALECT);
        CHOICE_MAPPING_CONFIGURATION = MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel);
    }

    @Test
    void crud_relationContainsOneToMany() {
        EntityPersister persister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Answer answer = new Answer(new PersistableIdentifier<Long>(1L));
        Choice grenoble = new Choice(new PersistableIdentifier<Long>(13L));
        grenoble.setLabel("Grenoble");
        Choice lyon = new Choice(new PersistableIdentifier<Long>(17L));
        lyon.setLabel("Lyon");
        answer.addChoices(grenoble, lyon);
        persister.insert((Object)answer);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        Set choiceAnswerIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer.getId().getDelegate()});
        Answer loadedAnswer = (Answer)persister.select(answer.getId());
        Assertions.assertThat(loadedAnswer.getChoices()).extracting(Choice::getLabel).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Lyon"});
        Answer modifiedAnswer = new Answer(answer.getId());
        modifiedAnswer.addChoices((Choice)Iterables.first(answer.getChoices()));
        persister.update((Object)modifiedAnswer, (Object)answer, false);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        choiceAnswerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer.getId().getDelegate()});
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = this.persistenceContext.newQuery((CharSequence)"select id from choice", Long.class).mapKey("id", Long.class);
        Set choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)grenoble.getId().getDelegate(), (Long)lyon.getId().getDelegate()});
        persister.delete((Object)modifiedAnswer);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        choiceAnswerIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).isEmpty();
    }

    @Test
    void crud_relationContainsManyToMany() {
        EntityPersister persister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Answer answer1 = new Answer(new PersistableIdentifier<Long>(1L));
        Answer answer2 = new Answer(new PersistableIdentifier<Long>(2L));
        Choice grenoble = new Choice(new PersistableIdentifier<Long>(13L));
        grenoble.setLabel("Grenoble");
        Choice lyon = new Choice(new PersistableIdentifier<Long>(17L));
        lyon.setLabel("Lyon");
        answer1.addChoices(grenoble, lyon);
        answer2.addChoices(grenoble, lyon);
        persister.insert((Iterable)Arrays.asList((Object[])new Answer[]{answer1, answer2}));
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        Set choiceAnswerIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer1.getId().getDelegate(), (Long)answer2.getId().getDelegate()});
        Answer loadedAnswer = (Answer)persister.select(answer1.getId());
        Assertions.assertThat(loadedAnswer.getChoices()).extracting(Choice::getLabel).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Lyon"});
        Answer modifiedAnswer = new Answer(answer1.getId());
        modifiedAnswer.addChoices((Choice)Iterables.first(answer1.getChoices()));
        persister.update((Object)modifiedAnswer, (Object)answer1, false);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        choiceAnswerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer1.getId().getDelegate(), (Long)answer2.getId().getDelegate()});
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = this.persistenceContext.newQuery((CharSequence)"select id from choice", Long.class).mapKey("id", Long.class);
        Set choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)grenoble.getId().getDelegate(), (Long)lyon.getId().getDelegate()});
        persister.delete((Object)modifiedAnswer);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        choiceAnswerIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer2.getId().getDelegate()});
    }

    @Test
    void crud_relationContainsManyToMany_indexed() {
        EntityPersister persister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).indexedBy("myIdx").initializeWith(KeepOrderSet::new).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Answer answer1 = new Answer(new PersistableIdentifier<Long>(1L));
        Answer answer2 = new Answer(new PersistableIdentifier<Long>(2L));
        Choice grenoble = new Choice(new PersistableIdentifier<Long>(13L));
        grenoble.setLabel("Grenoble");
        Choice lyon = new Choice(new PersistableIdentifier<Long>(17L));
        lyon.setLabel("Lyon");
        answer1.addChoices(lyon, grenoble);
        answer2.addChoices(grenoble, lyon);
        persister.insert((Iterable)Arrays.asList((Object[])new Answer[]{answer1, answer2}));
        PersistenceContext.ExecutableBeanPropertyQueryMapper trioExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select answer_id, choices_id, myIdx from answer_choices", Trio.class).mapKey((SerializableTriFunction & Serializable)(x$0, x$1, x$2) -> Trio.forInteger(x$0, x$1, x$2), "answer_id", "choices_id", "myIdx");
        Set choiceAnswerIds = (Set)trioExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Trio[]{new Trio<Integer, Integer, Integer>(1, 17, 1), new Trio<Integer, Integer, Integer>(1, 13, 2), new Trio<Integer, Integer, Integer>(2, 13, 1), new Trio<Integer, Integer, Integer>(2, 17, 2)});
        Answer loadedAnswer1 = (Answer)persister.select(answer1.getId());
        Assertions.assertThat(loadedAnswer1.getChoices()).isInstanceOf(KeepOrderSet.class);
        Assertions.assertThat(loadedAnswer1.getChoices()).containsExactly((Object[])new Choice[]{lyon, grenoble});
        Answer loadedAnswer2 = (Answer)persister.select(answer2.getId());
        Assertions.assertThat(loadedAnswer2.getChoices()).isInstanceOf(KeepOrderSet.class);
        Assertions.assertThat(loadedAnswer2.getChoices()).containsExactly((Object[])new Choice[]{grenoble, lyon});
    }

    @Test
    void crud_relationContainsManyToMany_indexed_siblingProperties() {
        EntityPersister persister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).indexedBy("myIdx").initializeWith(KeepOrderSet::new).cascading(CascadeOptions.RelationMode.ALL).mapManyToMany(Answer::getSecondaryChoices, CHOICE_MAPPING_CONFIGURATION).indexedBy("myIdx2").initializeWith(KeepOrderSet::new).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Answer answer1 = new Answer(new PersistableIdentifier<Long>(1L));
        Answer answer2 = new Answer(new PersistableIdentifier<Long>(2L));
        Choice grenoble = new Choice(new PersistableIdentifier<Long>(13L));
        grenoble.setLabel("Grenoble");
        Choice lyon = new Choice(new PersistableIdentifier<Long>(17L));
        lyon.setLabel("Lyon");
        answer1.addChoices(lyon, grenoble);
        answer1.addSecondaryChoices(lyon, grenoble);
        answer2.addChoices(grenoble, lyon);
        answer2.addSecondaryChoices(grenoble, lyon);
        persister.insert((Iterable)Arrays.asList((Object[])new Answer[]{answer1, answer2}));
        PersistenceContext.ExecutableBeanPropertyQueryMapper answerChoicesQuery = this.persistenceContext.newQuery((CharSequence)"select answer_id, choices_id, myIdx from answer_choices", Trio.class).mapKey((SerializableTriFunction & Serializable)(x$0, x$1, x$2) -> Trio.forInteger(x$0, x$1, x$2), "answer_id", "choices_id", "myIdx");
        Set answerChoicesIds = (Set)answerChoicesQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)answerChoicesIds).containsExactlyInAnyOrder((Object[])new Trio[]{new Trio<Integer, Integer, Integer>(1, 17, 1), new Trio<Integer, Integer, Integer>(1, 13, 2), new Trio<Integer, Integer, Integer>(2, 13, 1), new Trio<Integer, Integer, Integer>(2, 17, 2)});
        PersistenceContext.ExecutableBeanPropertyQueryMapper answerSecondaryChoicesQuery = this.persistenceContext.newQuery((CharSequence)"select answer_id, secondaryChoices_id, myIdx2 from answer_secondaryChoices", Trio.class).mapKey((SerializableTriFunction & Serializable)(x$0, x$1, x$2) -> Trio.forInteger(x$0, x$1, x$2), "answer_id", "secondaryChoices_id", "myIdx2");
        Set secondaryChoicesIds = (Set)answerSecondaryChoicesQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)secondaryChoicesIds).containsExactlyInAnyOrder((Object[])new Trio[]{new Trio<Integer, Integer, Integer>(1, 17, 1), new Trio<Integer, Integer, Integer>(1, 13, 2), new Trio<Integer, Integer, Integer>(2, 13, 1), new Trio<Integer, Integer, Integer>(2, 17, 2)});
        Map answerMap = persister.select((Object[])new Identifier[]{answer1.getId(), answer2.getId()}).stream().collect(Collectors.toMap(Answer::getId, Function.identity()));
        Answer loadedAnswer1 = (Answer)answerMap.get(answer1.getId());
        Assertions.assertThat(loadedAnswer1.getChoices()).isInstanceOf(KeepOrderSet.class);
        Assertions.assertThat(loadedAnswer1.getChoices()).containsExactly((Object[])new Choice[]{lyon, grenoble});
        Answer loadedAnswer2 = (Answer)answerMap.get(answer2.getId());
        Assertions.assertThat(loadedAnswer2.getChoices()).isInstanceOf(KeepOrderSet.class);
        Assertions.assertThat(loadedAnswer2.getChoices()).containsExactly((Object[])new Choice[]{grenoble, lyon});
    }

    @Test
    void select_collectionFactory() throws SQLException {
        EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).initializeWith(() -> new TreeSet<Choice>(Comparator.comparing(Choice::getLabel))).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Answer(id) values (42)").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Choice(id, label) values (1, 'Paris')").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Choice(id, label) values (2, 'Lyon')").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Answer_Choices(answer_id, choices_id) values (42, 1), (42, 2)").execute();
        Answer loadedAnswer = (Answer)answerPersister.select(new PersistedIdentifier<Long>(42L));
        Assertions.assertThat(loadedAnswer.getChoices().getClass()).isEqualTo(TreeSet.class);
        Assertions.assertThat(loadedAnswer.getChoices()).extracting(Choice::getLabel).containsExactly((Object[])new String[]{"Lyon", "Paris"});
    }

    @Test
    void select_noRecordInAssociationTable_mustReturnEmptyCollection() throws SQLException {
        EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.READ_ONLY).build(this.persistenceContext);
        Assertions.assertThat((Object)((OptimizedUpdatePersister)answerPersister).getDelegate().getEntityJoinTree().getJoin("Answer_Choices0")).isNull();
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer(id) values (42)");
        Answer loadedAnswer = (Answer)answerPersister.select(new PersistedIdentifier<Long>(42L));
        Assertions.assertThat(loadedAnswer.getChoices()).isEqualTo(null);
    }

    @Test
    void bidirectionality_reverselySetBy() {
        EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder authorMappingConfiguration = new EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder();
        EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder bookMappingConfiguration = new EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder();
        authorMappingConfiguration.setProvider((FluentEntityMappingBuilder)MappingEase.entityBuilder(Author.class, Long.class).mapKey(AbstractEntity::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).map(Author::getName));
        bookMappingConfiguration.setProvider((FluentEntityMappingBuilder)MappingEase.entityBuilder(Book.class, Long.class).mapKey(AbstractEntity::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).mapManyToMany(Book::getAuthors, (EntityMappingConfigurationProvider)authorMappingConfiguration).reverselySetBy(Author::addBook).reverselyInitializeWith(LinkedHashSet::new).map(Book::getIsbn).columnName("isbn").map(Book::getPrice).map(Book::getTitle));
        Book book1 = new Book("a first book", 24.1, "AAA-BBB-CCC");
        Book book2 = new Book("a second book", 33.5, "XXX-YYY-ZZZ");
        Author author1 = new Author("John Doe");
        Author author2 = new Author("Jane Doe");
        book1.setAuthors(Arrays.asSet((Object[])new Author[]{author1}));
        book2.setAuthors(Arrays.asSet((Object[])new Author[]{author1, author2}));
        author1.setWrittenBooks(Arrays.asSet((Object[])new Book[]{book1, book2}));
        author2.setWrittenBooks(Arrays.asSet((Object[])new Book[]{book2}));
        PersistenceContext persistenceContext = new PersistenceContext(this.dataSource, DIALECT);
        EntityPersister bookPersister = bookMappingConfiguration.getProvider().build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        bookPersister.insert((Object)book1);
        bookPersister.insert((Object)book2);
        Set select = bookPersister.select((Iterable)Arrays.asSet((Object[])new Long[]{book1.getId(), book2.getId()}));
        Book loadedBook1 = (Book)Iterables.find((Iterable)select, Book::getTitle, "a first book"::equals).getLeft();
        Book loadedBook2 = (Book)Iterables.find((Iterable)select, Book::getTitle, "a second book"::equals).getLeft();
        Assertions.assertThat(loadedBook1.getAuthors()).allSatisfy(author -> {
            Assertions.assertThat(author.getWrittenBooks()).isInstanceOf(LinkedHashSet.class);
            Assertions.assertThat(author.getWrittenBooks()).containsExactly((Object[])new Book[]{loadedBook1, loadedBook2});
        });
        List creationScripts = ddlDeployer.getCreationScripts();
        Assertions.assertThat((List)creationScripts).containsExactlyInAnyOrder((Object[])new String[]{"create table Book_authors(book_id bigint, authors_id bigint, unique (book_id, authors_id))", "create table Author(name varchar(255), id bigint GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) not null, unique (id))", "create table Book(isbn varchar(255), price double, title varchar(255), id bigint GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) not null, unique (id))", "alter table Book_authors add constraint FK_Book_authors_authors_id_Author_id foreign key(authors_id) references Author(id)", "alter table Book_authors add constraint FK_Book_authors_book_id_Book_id foreign key(book_id) references Book(id)"});
    }

    @Test
    void bidirectionality_reverseInitializedWith() {
        EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder authorMappingConfiguration = new EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder();
        EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder bookMappingConfiguration = new EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder();
        authorMappingConfiguration.setProvider((FluentEntityMappingBuilder)MappingEase.entityBuilder(Author.class, Long.class).mapKey(AbstractEntity::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).map(Author::getName));
        bookMappingConfiguration.setProvider((FluentEntityMappingBuilder)MappingEase.entityBuilder(Book.class, Long.class).mapKey(AbstractEntity::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).mapManyToMany(Book::getAuthors, (EntityMappingConfigurationProvider)authorMappingConfiguration).reverselyInitializeWith(LinkedHashSet::new).map(Book::getIsbn).columnName("isbn").map(Book::getPrice).map(Book::getTitle));
        Book book1 = new Book("a first book", 24.1, "AAA-BBB-CCC");
        Book book2 = new Book("a second book", 33.5, "XXX-YYY-ZZZ");
        Author author1 = new Author("John Doe");
        Author author2 = new Author("Jane Doe");
        book1.setAuthors(Arrays.asSet((Object[])new Author[]{author1}));
        book2.setAuthors(Arrays.asSet((Object[])new Author[]{author1, author2}));
        author1.setWrittenBooks(Arrays.asSet((Object[])new Book[]{book1, book2}));
        author2.setWrittenBooks(Arrays.asSet((Object[])new Book[]{book2}));
        PersistenceContext persistenceContext = new PersistenceContext(this.dataSource, DIALECT);
        EntityPersister bookPersister = bookMappingConfiguration.getProvider().build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        bookPersister.insert((Object)book1);
        bookPersister.insert((Object)book2);
        Set select = bookPersister.select((Iterable)Arrays.asSet((Object[])new Long[]{book1.getId(), book2.getId()}));
        Book loadedBook1 = (Book)Iterables.find((Iterable)select, Book::getTitle, "a first book"::equals).getLeft();
        Book loadedBook2 = (Book)Iterables.find((Iterable)select, Book::getTitle, "a second book"::equals).getLeft();
        Assertions.assertThat(loadedBook1.getAuthors()).allSatisfy(author -> {
            AbstractCollectionAssert cfr_ignored_0 = (AbstractCollectionAssert)Assertions.assertThat(author.getWrittenBooks()).isInstanceOf(LinkedHashSet.class);
        });
    }

    @Test
    void bidirectionality_reverseCollection() {
        EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder authorMappingConfiguration = new EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder();
        EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder bookMappingConfiguration = new EntityMappingConfigurationProvider.EntityMappingConfigurationProviderHolder();
        authorMappingConfiguration.setProvider((FluentEntityMappingBuilder)MappingEase.entityBuilder(Author.class, Long.class).mapKey(AbstractEntity::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).map(Author::getName));
        bookMappingConfiguration.setProvider((FluentEntityMappingBuilder)MappingEase.entityBuilder(Book.class, Long.class).mapKey(AbstractEntity::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).mapManyToMany(Book::getAuthors, (EntityMappingConfigurationProvider)authorMappingConfiguration).reverseCollection(Author::getBooks).map(Book::getIsbn).columnName("isbn").map(Book::getPrice).map(Book::getTitle));
        Book book1 = new Book("a first book", 24.1, "AAA-BBB-CCC");
        Book book2 = new Book("a second book", 33.5, "XXX-YYY-ZZZ");
        Author author1 = new Author("John Doe");
        Author author2 = new Author("Jane Doe");
        book1.setAuthors(Arrays.asSet((Object[])new Author[]{author1}));
        book2.setAuthors(Arrays.asSet((Object[])new Author[]{author1, author2}));
        author1.setWrittenBooks(Arrays.asSet((Object[])new Book[]{book1, book2}));
        author2.setWrittenBooks(Arrays.asSet((Object[])new Book[]{book2}));
        PersistenceContext persistenceContext = new PersistenceContext(this.dataSource, DIALECT);
        EntityPersister bookPersister = bookMappingConfiguration.getProvider().build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        bookPersister.insert((Object)book1);
        bookPersister.insert((Object)book2);
        Set select = bookPersister.select((Iterable)Arrays.asSet((Object[])new Long[]{book1.getId(), book2.getId()}));
        Book loadedBook1 = (Book)Iterables.find((Iterable)select, Book::getTitle, "a first book"::equals).getLeft();
        Book loadedBook2 = (Book)Iterables.find((Iterable)select, Book::getTitle, "a second book"::equals).getLeft();
        Assertions.assertThat(loadedBook1.getAuthors()).allSatisfy(author -> {
            Assertions.assertThat(author.getWrittenBooks()).isExactlyInstanceOf(HashSet.class);
            Assertions.assertThat(author.getWrittenBooks()).containsExactlyInAnyOrder((Object[])new Book[]{loadedBook1, loadedBook2});
        });
    }

    public static class Choice
    implements Identified<Long> {
        private Identifier<Long> id;
        private String label;

        public Choice() {
        }

        public Choice(long id) {
            this.id = new PersistableIdentifier<Long>(id);
        }

        public Choice(Identifier<Long> id) {
            this.id = id;
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Choice)) {
                return false;
            }
            Choice choice = (Choice)o;
            return Objects.equals(this.id, choice.id);
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public String toString() {
            return "Choice{id=" + this.id.getDelegate() + ", label='" + this.label + '\'' + '}';
        }
    }

    public static class Answer
    implements Identified<Long> {
        private Identifier<Long> id;
        private String comment;
        private Set<Choice> choices;
        private Set<Choice> secondaryChoices;

        private Answer() {
        }

        private Answer(Long id) {
            this(new PersistableIdentifier<Long>(id));
        }

        private Answer(Identifier<Long> id) {
            this.id = id;
        }

        public Answer(Choice choice) {
            this.choices.add(choice);
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Set<Choice> getChoices() {
            return this.choices;
        }

        public void addChoices(Collection<Choice> choices) {
            this.choices.addAll(choices);
        }

        public void addChoices(Choice ... choices) {
            if (this.choices == null) {
                this.choices = new LinkedHashSet<Choice>();
            }
            this.choices.addAll(Arrays.asList((Object[])choices));
        }

        public void setChoices(Set<Choice> choices) {
            this.choices = choices;
        }

        public Set<Choice> getSecondaryChoices() {
            return this.secondaryChoices;
        }

        public void addSecondaryChoices(Collection<Choice> choices) {
            this.secondaryChoices.addAll(choices);
        }

        public void addSecondaryChoices(Choice ... choices) {
            if (this.secondaryChoices == null) {
                this.secondaryChoices = new LinkedHashSet<Choice>();
            }
            this.secondaryChoices.addAll(Arrays.asList((Object[])choices));
        }

        public void setSecondaryChoices(Set<Choice> secondaryChoices) {
            this.secondaryChoices = secondaryChoices;
        }

        public String toString() {
            return "Answer{id=" + this.id + '}';
        }
    }

    @Nested
    class CascadeAssociationOnly {
        CascadeAssociationOnly() {
        }

        @Test
        void insert_associationRecordsMustBeInserted_butNotTargetEntities() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200), (300)");
            Answer answer1 = new Answer(new PersistableIdentifier<Long>(42L));
            Choice choice1 = new Choice(new PersistableIdentifier<Long>(100L));
            Choice choice2 = new Choice(new PersistableIdentifier<Long>(200L));
            answer1.addChoices(choice1, choice2);
            Answer answer2 = new Answer(new PersistableIdentifier<Long>(666L));
            Choice choice3 = new Choice(new PersistableIdentifier<Long>(300L));
            answer2.addChoices(choice3);
            answerPersister.insert((Iterable)Arrays.asList((Object[])new Answer[]{answer1, answer2}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Answer where id in (42, 666)", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer1.getId().getDelegate(), (Long)answer2.getId().getDelegate()});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select choices_Id from Answer_choices where answer_id in (42, 666)", Long.class).mapKey("choices_id", Long.class);
            Set choicesInRelationIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choicesInRelationIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)choice1.getId().getDelegate(), (Long)choice2.getId().getDelegate(), (Long)choice3.getId().getDelegate()});
        }

        @Test
        void update_associationRecordsMustBeUpdated_butNotTargetEntities() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Answer::getComment).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200)");
            Answer answer1 = new Answer(new PersistableIdentifier<Long>(42L));
            answer1.setComment("Hello world !");
            Choice choice1 = new Choice(new PersistableIdentifier<Long>(100L));
            Choice choice2 = new Choice(new PersistableIdentifier<Long>(200L));
            answer1.addChoices(choice1, choice2);
            answerPersister.insert((Object)answer1);
            choice1.setLabel("Grenoble");
            answerPersister.update((Object)answer1, answerPersister.select(answer1.getId()), true);
            String answerComment = (String)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select comment from Answer where id = 42", String.class).mapKey("comment", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)answerComment).isEqualTo(answer1.getComment());
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select label from Choice where id = 100", String.class).mapKey("label", String.class);
            Set choiceLabels = (Set)stringExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceLabels).containsExactlyInAnyOrder((Object[])new String[]{null});
            Assertions.assertThat((int)answer1.getChoices().size()).isEqualTo(2);
            answer1.getChoices().remove(choice1);
            Assertions.assertThat((int)answer1.getChoices().size()).isEqualTo(1);
            answerPersister.update((Object)answer1, answerPersister.select(answer1.getId()), true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select label from Choice where id = 100", String.class).mapKey("label", String.class);
            choiceLabels = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceLabels).containsExactlyInAnyOrder((Object[])new String[]{null});
        }

        @Test
        void delete_associationRecordsMustBeDeleted_butNotTargetEntities() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200), (300)");
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer_choices(answer_Id, choices_Id) values (42, 100), (42, 200), (666, 300)");
            Answer answer1 = new Answer(new PersistedIdentifier<Long>(42L));
            Choice choice1 = new Choice(new PersistedIdentifier<Long>(100L));
            Choice choice2 = new Choice(new PersistedIdentifier<Long>(200L));
            answer1.addChoices(choice1, choice2);
            Answer answer2 = new Answer(new PersistedIdentifier<Long>(666L));
            Choice choice3 = new Choice(new PersistedIdentifier<Long>(300L));
            answer2.addChoices(choice3);
            answerPersister.delete((Object)answer1);
            Long answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 42", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            Long relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 42", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id in (100, 200)", Long.class).mapKey("id", Long.class);
            Set choiceIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{100L, 200L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Answer where id = 666", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{666L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
            answerPersister.delete((Object)answer2);
            answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 666", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 666", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
        }
    }

    @Nested
    class CascadeAllOrphanRemoval {
        CascadeAllOrphanRemoval() {
        }

        @Test
        void update_removedElementsAreDeleted() {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider answerIdProvider = new LongProvider();
            Answer dummyAnswer = new Answer((Long)answerIdProvider.giveNewIdentifier());
            LongProvider cityIdProvider = new LongProvider();
            Choice paris = new Choice((Long)cityIdProvider.giveNewIdentifier());
            paris.setLabel("Paris");
            dummyAnswer.addChoices(paris);
            Choice lyon = new Choice((Long)cityIdProvider.giveNewIdentifier());
            lyon.setLabel("Lyon");
            dummyAnswer.addChoices(lyon);
            answerPersister.insert((Object)dummyAnswer);
            Answer persistedAnswer = (Answer)answerPersister.select(dummyAnswer.getId());
            persistedAnswer.getChoices().remove(paris);
            Choice grenoble = new Choice((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setLabel("Grenoble");
            persistedAnswer.addChoices(grenoble);
            ((Choice)Iterables.first(persistedAnswer.getChoices())).setLabel("changed");
            answerPersister.update((Object)persistedAnswer, (Object)dummyAnswer, true);
            Answer persistedAnswer2 = (Answer)answerPersister.select(dummyAnswer.getId());
            Assertions.assertThat(persistedAnswer2.getChoices()).isEqualTo((Object)Arrays.asHashSet((Object[])new Choice[]{lyon, grenoble}));
            Assertions.assertThat(persistedAnswer2.getChoices()).extracting(Choice::getLabel).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
        }

        @Test
        void delete_associationRecordsMustBeDeleted() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200), (300)");
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer_choices(answer_Id, choices_Id) values (42, 100), (42, 200), (666, 300)");
            Answer answer1 = new Answer(new PersistedIdentifier<Long>(42L));
            Choice city1 = new Choice(new PersistedIdentifier<Long>(100L));
            Choice city2 = new Choice(new PersistedIdentifier<Long>(200L));
            answer1.addChoices(city1, city2);
            Answer answer2 = new Answer(new PersistedIdentifier<Long>(666L));
            Choice city3 = new Choice(new PersistedIdentifier<Long>(300L));
            answer2.addChoices(city3);
            answerPersister.delete((Object)answer1);
            Long answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 42", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            Long relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 42", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id in (100, 200)", Long.class).mapKey("id", Long.class);
            Set choiceIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Answer where id = 666", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{666L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
            answerPersister.delete((Object)answer2);
            answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 666", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 666", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).isEmpty();
        }
    }

    @Nested
    class CascadeAll {
        CascadeAll() {
        }

        @Test
        void update_associationTableIsMaintained() {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider answerIdProvider = new LongProvider();
            Answer dummyAnswer = new Answer((Long)answerIdProvider.giveNewIdentifier());
            LongProvider cityIdProvider = new LongProvider();
            Choice paris = new Choice((Long)cityIdProvider.giveNewIdentifier());
            paris.setLabel("Paris");
            dummyAnswer.addChoices(paris);
            Choice lyon = new Choice((Long)cityIdProvider.giveNewIdentifier());
            lyon.setLabel("Lyon");
            dummyAnswer.addChoices(lyon);
            answerPersister.insert((Object)dummyAnswer);
            Answer persistedAnswer = (Answer)answerPersister.select(dummyAnswer.getId());
            persistedAnswer.getChoices().remove(paris);
            Choice grenoble = new Choice((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setLabel("Grenoble");
            persistedAnswer.addChoices(grenoble);
            ((Choice)Iterables.first(persistedAnswer.getChoices())).setLabel("changed");
            answerPersister.update((Object)persistedAnswer, (Object)dummyAnswer, true);
            Answer persistedAnswer2 = (Answer)answerPersister.select(dummyAnswer.getId());
            Assertions.assertThat(persistedAnswer2.getChoices()).extracting(Choice::getLabel).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
        }

        @Test
        void delete_associationRecordsMustBeDeleted() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200), (300)");
            FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer_choices(answer_Id, choices_Id) values (42, 100), (42, 200), (666, 300)");
            Answer answer1 = new Answer(new PersistedIdentifier<Long>(42L));
            Choice city1 = new Choice(new PersistedIdentifier<Long>(100L));
            Choice city2 = new Choice(new PersistedIdentifier<Long>(200L));
            answer1.addChoices(city1, city2);
            Answer answer2 = new Answer(new PersistedIdentifier<Long>(666L));
            Choice city3 = new Choice(new PersistedIdentifier<Long>(300L));
            answer2.addChoices(city3);
            answerPersister.delete((Object)answer1);
            Long answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 42", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            Long relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 42", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id in (100, 200)", Long.class).mapKey("id", Long.class);
            Set choiceIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{100L, 200L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Answer where id = 666", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{666L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
            answerPersister.delete((Object)answer2);
            answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 666", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 666", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
        }
    }

    @Nested
    class CascadeReadOnly {
        CascadeReadOnly() {
        }

        @Test
        void insert_onlySourceEntitiesArePersisted() {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Answer answer = new Answer(new PersistableIdentifier<Long>(1L));
            Choice grenoble = new Choice(new PersistableIdentifier<Long>(13L));
            grenoble.setLabel("Grenoble");
            Choice lyon = new Choice(new PersistableIdentifier<Long>(17L));
            lyon.setLabel("Lyon");
            answer.addChoices(grenoble, lyon);
            answerPersister.insert((Object)answer);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select id from answer", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer.getId().getDelegate()});
            Long choiceAnswerCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from answer_choices", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)choiceAnswerCount).isEqualTo(0L);
            Long choiceCount = (Long)FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as choiceCount from choice", Long.class).mapKey("choiceCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)choiceCount).isEqualTo(0L);
        }
    }

    private static class Trio<L, M, R> {
        private final L left;
        private final M middle;
        private final R right;

        private static Trio<Integer, Integer, Integer> forInteger(Integer left, Integer middle, Integer right) {
            return new Trio<Integer, Integer, Integer>(left, middle, right);
        }

        public Trio(L left, M middle, R right) {
            this.left = left;
            this.middle = middle;
            this.right = right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trio trio = (Trio)o;
            return Objects.equals(this.left, trio.left) && Objects.equals(this.middle, trio.middle) && Objects.equals(this.right, trio.right);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.left, this.middle, this.right});
        }

        public String toString() {
            return "{left=" + this.left + ", middle=" + this.middle + ", right=" + this.right + '}';
        }
    }

    @Nested
    class ForeignKeyCreation {
        ForeignKeyCreation() {
        }

        @Test
        void foreignKeysAreCreated() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkChoiceIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getImportedKeys(null, null, "ANSWER_CHOICES")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            Set foundForeignKey = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$foreignKeysAreCreated$0((ResultSetIterator)fkChoiceIterator), JdbcForeignKey::getSignature, HashSet::new);
            Assertions.assertThat((Collection)foundForeignKey).containsExactlyInAnyOrder((Object[])new String[]{new JdbcForeignKey("FK_ANSWER_CHOICES_ANSWER_ID_ANSWER_ID", "ANSWER_CHOICES", "ANSWER_ID", "ANSWER", "ID").getSignature(), new JdbcForeignKey("FK_ANSWER_CHOICES_CHOICES_ID_CHOICE_ID", "ANSWER_CHOICES", "CHOICES_ID", "CHOICE", "ID").getSignature()});
        }

        @Test
        void withTargetTable_targetTableIsUsed() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION, new Table("MyChoice")).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTable_targetTableIsUsed$1((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"ANSWER", "MYCHOICE", "ANSWER_CHOICES"});
            ResultSetIterator<JdbcForeignKey> fkChoiceIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getImportedKeys(null, null, "ANSWER_CHOICES")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            Set foundForeignKey = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTable_targetTableIsUsed$2((ResultSetIterator)fkChoiceIterator), JdbcForeignKey::getSignature, HashSet::new);
            Assertions.assertThat((Collection)foundForeignKey).containsExactlyInAnyOrder((Object[])new String[]{new JdbcForeignKey("FK_ANSWER_CHOICES_ANSWER_ID_ANSWER_ID", "ANSWER_CHOICES", "ANSWER_ID", "ANSWER", "ID").getSignature(), new JdbcForeignKey("FK_ANSWER_CHOICES_CHOICES_ID_MYCHOICE_ID", "ANSWER_CHOICES", "CHOICES_ID", "MYCHOICE", "ID").getSignature()});
        }

        @Test
        void withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).onTable(new Table("PossibleChoices")).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel)).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$3((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"ANSWER", "POSSIBLECHOICES", "ANSWER_CHOICES"});
            ResultSetIterator<JdbcForeignKey> fkChoiceIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getImportedKeys(null, null, "ANSWER_CHOICES")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            Set foundForeignKey = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$4((ResultSetIterator)fkChoiceIterator), JdbcForeignKey::getSignature, HashSet::new);
            Assertions.assertThat((Collection)foundForeignKey).containsExactlyInAnyOrder((Object[])new String[]{new JdbcForeignKey("FK_ANSWER_CHOICES_ANSWER_ID_ANSWER_ID", "ANSWER_CHOICES", "ANSWER_ID", "ANSWER", "ID").getSignature(), new JdbcForeignKey("FK_ANSWER_CHOICES_CHOICES_ID_POSSIBLECHOICES_ID", "ANSWER_CHOICES", "CHOICES_ID", "POSSIBLECHOICES", "ID").getSignature()});
        }

        @Test
        void withTargetTableAndTableSetByTargetEntity_targetTableIsUsed() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).onTable(new Table("PossibleChoices")).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel), new Table("MyChoice")).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportManyToManyTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$5((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"ANSWER", "MYCHOICE", "ANSWER_CHOICES"});
            ResultSetIterator<JdbcForeignKey> fkChoiceIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getImportedKeys(null, null, "ANSWER_CHOICES")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            Set foundForeignKey = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$6((ResultSetIterator)fkChoiceIterator), JdbcForeignKey::getSignature, HashSet::new);
            Assertions.assertThat((Collection)foundForeignKey).containsExactlyInAnyOrder((Object[])new String[]{new JdbcForeignKey("FK_ANSWER_CHOICES_ANSWER_ID_ANSWER_ID", "ANSWER_CHOICES", "ANSWER_ID", "ANSWER", "ID").getSignature(), new JdbcForeignKey("FK_ANSWER_CHOICES_CHOICES_ID_MYCHOICE_ID", "ANSWER_CHOICES", "CHOICES_ID", "MYCHOICE", "ID").getSignature()});
        }

        private static /* synthetic */ Iterator lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$6(ResultSetIterator fkChoiceIterator) {
            return fkChoiceIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$5(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$4(ResultSetIterator fkChoiceIterator) {
            return fkChoiceIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$3(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTable_targetTableIsUsed$2(ResultSetIterator fkChoiceIterator) {
            return fkChoiceIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTable_targetTableIsUsed$1(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$foreignKeysAreCreated$0(ResultSetIterator fkChoiceIterator) {
            return fkChoiceIterator;
        }
    }
}

