/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.ColumnNamingStrategy;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.MapEntryTableNamingStrategy;
import org.codefilarete.stalactite.engine.cascade.BeforeDeleteCollectionCascader;
import org.codefilarete.stalactite.engine.cascade.BeforeInsertCollectionCascader;
import org.codefilarete.stalactite.engine.configurer.map.ConvertingMapAccessor;
import org.codefilarete.stalactite.engine.configurer.map.InMemoryRelationHolder;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecord;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMapping;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.map.MapRelation;
import org.codefilarete.stalactite.engine.configurer.map.MapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.MapUpdater;
import org.codefilarete.stalactite.engine.configurer.map.RecordId;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.function.Functions;

public class EntityAsKeyMapRelationConfigurer<SRC, SRCID, K, KID, V, M extends Map<K, V>, MM extends Map<KID, V>>
extends MapRelationConfigurer<SRC, SRCID, KID, V, MM> {
    private final MapRelation<SRC, K, V, M> originalMapRelation;
    private final ConfiguredRelationalPersister<K, KID> keyEntityPersister;
    private final Function<SRC, M> mapGetter;
    private final InMemoryRelationHolder<SRCID, KID, V, K> inMemoryRelationHolder;
    private Key<?, KID> keyIdColumnsProjectInAssociationTable;
    private final CascadeOptions.RelationMode maintenanceMode;

    private static <SRC, K, KID, V, M extends Map<K, V>, MM extends Map<KID, V>> MapRelation<SRC, KID, V, MM> convertEntityMapToIdentifierMap(MapRelation<SRC, K, V, M> mapRelation, ConfiguredRelationalPersister<K, KID> keyEntityPersister) {
        ConvertingMapAccessor mapAccessor = new ConvertingMapAccessor(mapRelation, (k, v, result) -> result.put(keyEntityPersister.getId(k), v));
        PropertyAccessor propertyAccessor = new PropertyAccessor(mapAccessor, (src, mm) -> {});
        return new MapRelation(propertyAccessor, keyEntityPersister.getMapping().getIdMapping().getIdentifierInsertionManager().getIdentifierType(), mapRelation.getValueType());
    }

    public EntityAsKeyMapRelationConfigurer(MapRelation<SRC, K, V, M> mapRelation, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, ConfiguredRelationalPersister<K, KID> keyEntityPersister, ForeignKeyNamingStrategy foreignKeyNamingStrategy, ColumnNamingStrategy columnNamingStrategy, MapEntryTableNamingStrategy tableNamingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        super(EntityAsKeyMapRelationConfigurer.convertEntityMapToIdentifierMap(mapRelation, keyEntityPersister), sourcePersister, foreignKeyNamingStrategy, columnNamingStrategy, tableNamingStrategy, dialect, connectionConfiguration);
        this.originalMapRelation = mapRelation;
        this.keyEntityPersister = keyEntityPersister;
        this.mapGetter = arg_0 -> this.originalMapRelation.getMapProvider().get(arg_0);
        this.inMemoryRelationHolder = new InMemoryRelationHolder(trio -> new Duo(trio.getEntity(), trio.getEntryValue()));
        this.maintenanceMode = mapRelation.getKeyEntityRelationMode();
    }

    @Override
    public void configure() {
        AccessorDefinition mapProviderDefinition = AccessorDefinition.giveDefinition(this.originalMapRelation.getMapProvider());
        final Supplier mapFactory = BeanRelationFixer.giveMapFactory((Class)mapProviderDefinition.getMemberType());
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>(){

            public void beforeSelect(Iterable<SRCID> ids) {
                EntityAsKeyMapRelationConfigurer.this.inMemoryRelationHolder.init();
            }

            public void afterSelect(Set<? extends SRC> result) {
                BeanRelationFixer originalRelationFixer = BeanRelationFixer.ofMapAdapter((arg_0, arg_1) -> ((Mutator)EntityAsKeyMapRelationConfigurer.this.originalMapRelation.getMapProvider().toMutator()).set(arg_0, arg_1), (Function)EntityAsKeyMapRelationConfigurer.this.mapGetter, (Supplier)mapFactory, (bean, duo, map) -> map.put(duo.getLeft(), duo.getRight()));
                result.forEach(bean -> {
                    Collection<Duo<Object, Object>> keyValuePairs = EntityAsKeyMapRelationConfigurer.this.inMemoryRelationHolder.get(EntityAsKeyMapRelationConfigurer.this.sourcePersister.getId(bean));
                    if (keyValuePairs != null) {
                        keyValuePairs.forEach(duo -> originalRelationFixer.apply(bean, duo));
                    }
                });
                EntityAsKeyMapRelationConfigurer.this.inMemoryRelationHolder.clear();
            }
        });
        super.configure();
    }

    @Override
    <TT extends Table<TT>, TARGETTABLE extends Table<TARGETTABLE>> ClassMapping<KeyValueRecord<KID, V, SRCID>, RecordId<KID, SRCID>, TARGETTABLE> buildKeyValueRecordMapping(final TARGETTABLE targetTable, IdentifierAssembler<SRCID, TT> sourceIdentifierAssembler, Map<Column<TT, ?>, Column<TARGETTABLE, ?>> primaryKeyForeignColumnMapping, EmbeddableMappingConfiguration<KID> keyEmbeddableConfiguration, EmbeddableMappingConfiguration<V> valueEmbeddableConfiguration) {
        KeyValueRecordMappingBuilder builder = new KeyValueRecordMappingBuilder<KID, V, SRCID, TARGETTABLE, TT>(targetTable, sourceIdentifierAssembler, primaryKeyForeignColumnMapping){
            private final Map<Column<TARGETTABLE, Object>, Column<Table, Object>> foreignKeyBootstrap;
            {
                super(associationTable, sourceIdentifierAssembler, primaryKeyForeignColumnMapping);
                this.foreignKeyBootstrap = new HashMap();
            }

            @Override
            void withEntryKeyIsSingleProperty(Column<TARGETTABLE, KID> keyColumn) {
                super.withEntryKeyIsSingleProperty(keyColumn);
                Column column = ((SimpleIdMapping)EntityAsKeyMapRelationConfigurer.this.keyEntityPersister.getMapping().getIdMapping()).getIdentifierAssembler().getColumn();
                this.foreignKeyBootstrap.put(keyColumn, (Column<Table, Object>)column);
                EntityAsKeyMapRelationConfigurer.this.keyIdColumnsProjectInAssociationTable = Key.ofSingleColumn(keyColumn);
            }

            @Override
            void withEntryKeyIsComplexType(EmbeddedClassMapping<KID, TARGETTABLE> entryKeyMapping) {
                super.withEntryKeyIsComplexType(entryKeyMapping);
                Key.KeyBuilder keyIdColumnsProjectInAssociationTableBuilder = Key.from((Fromable)targetTable);
                entryKeyMapping.getPropertyToColumn().values().forEach(arg_0 -> ((Key.KeyBuilder)keyIdColumnsProjectInAssociationTableBuilder).addColumn(arg_0));
                EntityAsKeyMapRelationConfigurer.this.keyIdColumnsProjectInAssociationTable = keyIdColumnsProjectInAssociationTableBuilder.build();
            }

            @Override
            KeyValueRecordMapping<KID, V, SRCID, TARGETTABLE> build() {
                Key.KeyBuilder keyBuilder1 = Key.from((Fromable)targetTable);
                Key.KeyBuilder keyBuilder2 = Key.from(EntityAsKeyMapRelationConfigurer.this.keyEntityPersister.getMainTable());
                this.foreignKeyBootstrap.forEach((key, value) -> {
                    keyBuilder1.addColumn((JoinLink)key);
                    keyBuilder2.addColumn((JoinLink)value);
                });
                targetTable.addForeignKey(EntityAsKeyMapRelationConfigurer.this.foreignKeyNamingStrategy::giveName, keyBuilder1.build(), keyBuilder2.build());
                return super.build();
            }
        };
        return super.buildKeyValueRecordMapping(keyEmbeddableConfiguration, targetTable, builder, valueEmbeddableConfiguration);
    }

    @Override
    protected void addInsertCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, EntityPersister<KeyValueRecord<KID, V, SRCID>, RecordId<KID, SRCID>> relationRecordPersister, Accessor<SRC, MM> mapAccessor) {
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            sourcePersister.addInsertListener(new BeforeInsertCollectionCascader<SRC, K>(this.keyEntityPersister){

                @Override
                protected Collection<K> getTargets(SRC src) {
                    return ((Map)EntityAsKeyMapRelationConfigurer.this.mapGetter.apply(src)).keySet();
                }
            });
        }
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            Function mapProviderForInsert = this.toRecordCollectionProvider(sourcePersister.getMapping(), false);
            sourcePersister.addInsertListener(new MapRelationConfigurer.TargetInstancesInsertCascader(relationRecordPersister, mapProviderForInsert));
        }
    }

    @Override
    protected void addUpdateCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, EntityPersister<KeyValueRecord<KID, V, SRCID>, RecordId<KID, SRCID>> relationRecordPersister) {
        Functions.NullProofFunction targetEntitiesGetter = new Functions.NullProofFunction(this.mapGetter).andThen(Map::entrySet);
        BiFunction<Map.Entry, Object, KeyValueRecord> entryKeyValueRecordFunction = (record, srcId) -> new KeyValueRecord(srcId, this.keyEntityPersister.getId(record.getKey()), record.getValue());
        MapUpdater mapUpdater = new MapUpdater(targetEntitiesGetter, this.keyEntityPersister, relationRecordPersister, sourcePersister, this.maintenanceMode, Map.Entry::getKey, entryKeyValueRecordFunction);
        sourcePersister.addUpdateListener(new OneToManyWithMappedAssociationEngine.AfterUpdateTrigger(mapUpdater));
    }

    @Override
    protected void addDeleteCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, EntityPersister<KeyValueRecord<KID, V, SRCID>, RecordId<KID, SRCID>> relationRecordPersister) {
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            super.addDeleteCascade(sourcePersister, relationRecordPersister);
        }
        if (this.maintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
            Functions.NullProofFunction targetEntitiesGetter = new Functions.NullProofFunction(this.mapGetter).andThen(Map::entrySet).andThen(entries -> entries.stream().map(Map.Entry::getKey).collect(Collectors.toSet()));
            sourcePersister.addDeleteListener(new BeforeDeleteCollectionCascader<SRC, K>(this.keyEntityPersister, (Function)targetEntitiesGetter){
                final /* synthetic */ Function val$targetEntitiesGetter;
                {
                    this.val$targetEntitiesGetter = function;
                    super(persister);
                }

                @Override
                protected Collection<K> getTargets(SRC src) {
                    return (Collection)this.val$targetEntitiesGetter.apply(src);
                }
            });
        }
    }

    @Override
    protected void addSelectCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, SimpleRelationalEntityPersister<KeyValueRecord<KID, V, SRCID>, RecordId<KID, SRCID>, ?> relationRecordPersister, PrimaryKey<?, SRCID> sourcePK, ForeignKey<?, ?, SRCID> keyValueRecordToSourceForeignKey, BiConsumer<SRC, MM> mapSetter, Accessor<SRC, MM> mapGetter, Supplier<MM> mapFactory) {
        BeanRelationFixer relationFixer = BeanRelationFixer.ofMapAdapter(mapSetter, arg_0 -> mapGetter.get(arg_0), mapFactory, (bean, input, map) -> this.inMemoryRelationHolder.storeRelation(sourcePersister.getId(bean), input.getKey(), input.getValue()));
        this.keyEntityPersister.joinAsMany("ROOT", relationRecordPersister, (Accessor)Accessors.accessorByMethodReference(KeyValueRecord::getKey), this.keyIdColumnsProjectInAssociationTable, (Key)this.keyEntityPersister.getMainTable().getPrimaryKey(), (bean, input) -> this.inMemoryRelationHolder.storeEntity(bean.getId().getId(), this.keyEntityPersister.getId(input), input), null, true, false);
        relationRecordPersister.joinAsMany("ROOT", sourcePersister, (Accessor)mapGetter, (Key)sourcePK, (Key)keyValueRecordToSourceForeignKey, relationFixer, null, true, this.originalMapRelation.isFetchSeparately());
    }
}

