/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.ddl.DDLAppender;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.StringAppender;

public class StringSQLAppender
implements SQLAppender {
    private final DDLAppender delegate;

    public StringSQLAppender(DMLNameProvider dmlNameProvider) {
        this.delegate = new QualifiedNameDDLAppender(dmlNameProvider);
    }

    private StringSQLAppender(DDLAppender delegate) {
        this.delegate = delegate;
    }

    public DDLAppender getDelegate() {
        return this.delegate;
    }

    @Override
    public StringSQLAppender cat(String s, String ... ss) {
        this.delegate.cat(s).cat((Object[])ss);
        return this;
    }

    @Override
    public <V> StringSQLAppender catValue(@Nullable Selectable<V> column, Object value) {
        return this.catValue(value);
    }

    @Override
    public StringSQLAppender catValue(Object value) {
        if (value instanceof ValuedVariable) {
            value = ((ValuedVariable)value).getValue();
        }
        if (value instanceof CharSequence) {
            this.delegate.cat("'", value.toString().replace("'", "''"), "'");
        } else {
            this.delegate.cat(value);
        }
        return this;
    }

    @Override
    public StringSQLAppender catColumn(Selectable<?> column) {
        this.delegate.cat(column);
        return this;
    }

    @Override
    public SQLAppender catTable(Fromable table) {
        this.delegate.cat(table);
        return this;
    }

    @Override
    public SQLAppender removeLastChars(int length) {
        this.delegate.cutTail(length);
        return this;
    }

    @Override
    public String getSQL() {
        return this.delegate.toString();
    }

    @Override
    public SQLAppender.SubSQLAppender newSubPart(DMLNameProvider dmlNameProvider) {
        return new SQLAppender.DefaultSubSQLAppender(new StringSQLAppender(new QualifiedNameDDLAppender(this.delegate.getAppender(), dmlNameProvider))){

            @Override
            public SQLAppender close() {
                return StringSQLAppender.this;
            }
        };
    }

    private static class QualifiedNameDDLAppender
    extends DDLAppender {
        public QualifiedNameDDLAppender(DMLNameProvider dmlNameProvider) {
            super(dmlNameProvider, new Object[0]);
        }

        public QualifiedNameDDLAppender(StringBuilder delegate, DMLNameProvider dmlNameProvider) {
            super(delegate, dmlNameProvider, new Object[0]);
        }

        @Override
        public StringAppender cat(Object o) {
            if (o instanceof Column || o instanceof QueryStatement.PseudoColumn) {
                return super.cat(this.dmlNameProvider.getName((Selectable)o));
            }
            if (o instanceof Selectable) {
                return super.cat(((Selectable)o).getExpression());
            }
            return super.cat(o);
        }
    }
}

