/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.diff;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.codefilarete.stalactite.engine.diff.AbstractDiff;
import org.codefilarete.stalactite.engine.diff.State;

public class IndexedDiff<C>
extends AbstractDiff<C> {
    private final Set<Integer> sourceIndexes;
    private final Set<Integer> replacerIndexes;

    public IndexedDiff(State state, C sourceInstance, C replacingInstance) {
        this(state, sourceInstance, replacingInstance, new HashSet<Integer>(), new HashSet<Integer>());
    }

    public IndexedDiff(State state, C sourceInstance, C replacingInstance, Set<Integer> sourceIndexes, Set<Integer> replacerIndexes) {
        super(state, sourceInstance, replacingInstance);
        this.sourceIndexes = sourceIndexes;
        this.replacerIndexes = replacerIndexes;
    }

    public Set<Integer> getSourceIndexes() {
        return this.sourceIndexes;
    }

    public IndexedDiff addSourceIndex(int index) {
        this.sourceIndexes.add(index);
        return this;
    }

    public Set<Integer> getReplacerIndexes() {
        return this.replacerIndexes;
    }

    public IndexedDiff addReplacerIndex(int index) {
        this.replacerIndexes.add(index);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexedDiff)) {
            return false;
        }
        IndexedDiff that = (IndexedDiff)o;
        return Objects.equals(this.getSourceInstance(), that.getSourceInstance()) && Objects.equals(this.getReplacingInstance(), that.getReplacingInstance());
    }

    public int hashCode() {
        return Objects.hash(this.getSourceInstance(), this.getReplacingInstance());
    }
}

