/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manyToOne;

import java.util.Collection;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneCycleConfigurer;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneOwnedBySourceConfigurer;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;

public class ManyToOneRelationConfigurer<C, I> {
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final ConfiguredRelationalPersister<C, I> sourcePersister;
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;

    public ManyToOneRelationConfigurer(Dialect dialect, ConnectionConfiguration connectionConfiguration, ConfiguredRelationalPersister<C, I> sourcePersister, JoinColumnNamingStrategy joinColumnNamingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy) {
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.sourcePersister = sourcePersister;
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
    }

    public <TRGT, TRGTID> void configure(ManyToOneRelation<C, TRGT, TRGTID, Collection<C>> manyToOneRelation) {
        PersisterBuilderContext currentBuilderContext = PersisterBuilderContext.CURRENT.get();
        ManyToOneOwnedBySourceConfigurer configurer = new ManyToOneOwnedBySourceConfigurer(this.sourcePersister, manyToOneRelation, this.joinColumnNamingStrategy, this.foreignKeyNamingStrategy);
        String relationName = AccessorDefinition.giveDefinition(manyToOneRelation.getTargetProvider()).getName();
        EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration = manyToOneRelation.getTargetMappingConfiguration();
        if (currentBuilderContext.isCycling(targetMappingConfiguration)) {
            Class targetEntityType = targetMappingConfiguration.getEntityType();
            ManyToOneCycleConfigurer cycleSolver = (ManyToOneCycleConfigurer)Iterables.find(currentBuilderContext.getBuildLifeCycleListeners(), p -> p instanceof ManyToOneCycleConfigurer && ((ManyToOneCycleConfigurer)p).getEntityType() == targetEntityType);
            if (cycleSolver == null) {
                cycleSolver = new ManyToOneCycleConfigurer(targetEntityType);
                currentBuilderContext.addBuildLifeCycleListener(cycleSolver);
            }
            cycleSolver.addCycleSolver(relationName, configurer);
        } else {
            Table targetTable = manyToOneRelation.getTargetTable();
            ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = new PersisterBuilderImpl<TRGT, TRGTID>(targetMappingConfiguration).build(this.dialect, this.connectionConfiguration, targetTable);
            configurer.configure(relationName, targetPersister, manyToOneRelation.isFetchSeparately());
        }
    }
}

