/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetomany;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyConfigurerTemplate;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.cycle.OneToManyCycleLoader;

class OneToManyCycleConfigurer<TRGT>
extends PersisterBuilderImpl.PostInitializer<TRGT> {
    private final Set<RelationConfigurer<?, ?, ?>> relations = new LinkedHashSet();

    public OneToManyCycleConfigurer(Class<TRGT> entityType) {
        super(entityType);
    }

    public <SRC> void addCycleSolver(String relationIdentifier, OneToManyConfigurerTemplate<SRC, TRGT, ?, ?, ? extends Collection<TRGT>, ?> oneToManyRelationConfigurer) {
        this.relations.add(new RelationConfigurer(relationIdentifier, oneToManyRelationConfigurer));
    }

    @Override
    public void consume(ConfiguredRelationalPersister<TRGT, ?> targetPersister) {
        this.registerRelationLoader(targetPersister);
    }

    private <SRC, TRGTID> void registerRelationLoader(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        OneToManyCycleLoader oneToManyCycleLoader = new OneToManyCycleLoader(targetPersister);
        targetPersister.addSelectListener(oneToManyCycleLoader);
        this.relations.forEach(c -> {
            String tableAlias = ((RelationConfigurer)c).relationName.replaceAll("\\W", "_");
            CascadeConfigurationResult configurationResult = ((RelationConfigurer)c).oneToManyRelationConfigurer.configureWithSelectIn2Phases(tableAlias, targetPersister, oneToManyCycleLoader.buildRowReader(((RelationConfigurer)c).relationName));
            oneToManyCycleLoader.addRelation(((RelationConfigurer)c).relationName, configurationResult);
        });
    }

    private class RelationConfigurer<SRC, SRCID, TRGTID> {
        private final String relationName;
        private final OneToManyConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, Collection<TRGT>, ?> oneToManyRelationConfigurer;

        public RelationConfigurer(String relationName, OneToManyConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, ? extends Collection<TRGT>, ?> oneToManyRelationConfigurer) {
            this.relationName = relationName;
            this.oneToManyRelationConfigurer = oneToManyRelationConfigurer;
        }
    }
}

