/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.util.Collection;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.RelationalMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementCollectionRelation;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementCollectionRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneRelation;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelation;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.EntityAsKeyAndValueMapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.EntityAsKeyMapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.MapRelation;
import org.codefilarete.stalactite.engine.configurer.map.MapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.ValueAsKeyMapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelationConfigurer;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;

public class RelationConfigurer<C, I> {
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final ConfiguredRelationalPersister<C, I> sourcePersister;
    private final NamingConfiguration namingConfiguration;
    private final OneToOneRelationConfigurer<C, I> oneToOneRelationConfigurer;
    private final OneToManyRelationConfigurer<C, ?, I, ?> oneToManyRelationConfigurer;
    private final ManyToManyRelationConfigurer<C, ?, I, ?, ?, Collection<C>> manyToManyRelationConfigurer;
    private final ManyToOneRelationConfigurer<C, I> manyToOneRelationConfigurer;
    private final ElementCollectionRelationConfigurer<C, ?, I, ? extends Collection<?>> elementCollectionRelationConfigurer;

    public RelationConfigurer(Dialect dialect, ConnectionConfiguration connectionConfiguration, ConfiguredRelationalPersister<C, I> sourcePersister, NamingConfiguration namingConfiguration) {
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.sourcePersister = sourcePersister;
        this.namingConfiguration = namingConfiguration;
        this.oneToOneRelationConfigurer = new OneToOneRelationConfigurer<C, I>(this.dialect, this.connectionConfiguration, this.sourcePersister, this.namingConfiguration.getJoinColumnNamingStrategy(), this.namingConfiguration.getForeignKeyNamingStrategy());
        this.oneToManyRelationConfigurer = new OneToManyRelationConfigurer(this.sourcePersister, this.dialect, this.connectionConfiguration, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getJoinColumnNamingStrategy(), this.namingConfiguration.getAssociationTableNamingStrategy(), this.namingConfiguration.getIndexColumnNamingStrategy());
        this.manyToManyRelationConfigurer = new ManyToManyRelationConfigurer(this.sourcePersister, this.dialect, this.connectionConfiguration, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getJoinColumnNamingStrategy(), this.namingConfiguration.getIndexColumnNamingStrategy(), this.namingConfiguration.getAssociationTableNamingStrategy());
        this.manyToOneRelationConfigurer = new ManyToOneRelationConfigurer<C, I>(this.dialect, this.connectionConfiguration, this.sourcePersister, this.namingConfiguration.getJoinColumnNamingStrategy(), this.namingConfiguration.getForeignKeyNamingStrategy());
        this.elementCollectionRelationConfigurer = new ElementCollectionRelationConfigurer(sourcePersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getElementCollectionTableNamingStrategy(), dialect, this.connectionConfiguration);
    }

    public <TRGT, TRGTID> void configureRelations(RelationalMappingConfiguration<C> entityMappingConfiguration) {
        for (OneToOneRelation oneToOneRelation : entityMappingConfiguration.getOneToOnes()) {
            this.oneToOneRelationConfigurer.configure(oneToOneRelation);
        }
        for (OneToManyRelation oneToManyRelation : entityMappingConfiguration.getOneToManys()) {
            this.oneToManyRelationConfigurer.configure(oneToManyRelation);
        }
        for (ManyToManyRelation manyToManyRelation : entityMappingConfiguration.getManyToManys()) {
            this.manyToManyRelationConfigurer.configure(manyToManyRelation);
        }
        for (ManyToOneRelation manyToOneRelation : entityMappingConfiguration.getManyToOnes()) {
            this.manyToOneRelationConfigurer.configure(manyToOneRelation);
        }
        for (ElementCollectionRelation elementCollectionRelation : entityMappingConfiguration.getElementCollections()) {
            this.elementCollectionRelationConfigurer.configure(elementCollectionRelation);
        }
        for (MapRelation mapRelation : entityMappingConfiguration.getMaps()) {
            ConfiguredRelationalPersister keyEntityPersister;
            EntityMappingConfiguration keyEntityConfiguration;
            if (mapRelation.getKeyEntityConfigurationProvider() != null && mapRelation.getValueEntityConfigurationProvider() != null) {
                keyEntityConfiguration = mapRelation.getKeyEntityConfigurationProvider().getConfiguration();
                keyEntityPersister = new PersisterBuilderImpl(keyEntityConfiguration).build(this.dialect, this.connectionConfiguration, null);
                EntityMappingConfiguration valueEntityConfiguration = mapRelation.getValueEntityConfigurationProvider().getConfiguration();
                ConfiguredRelationalPersister valueEntityPersister = new PersisterBuilderImpl(valueEntityConfiguration).build(this.dialect, this.connectionConfiguration, null);
                EntityAsKeyAndValueMapRelationConfigurer entityAsKeyMapRelationConfigurer = new EntityAsKeyAndValueMapRelationConfigurer(mapRelation, this.sourcePersister, keyEntityPersister, valueEntityPersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getEntryMapTableNamingStrategy(), this.dialect, this.connectionConfiguration);
                entityAsKeyMapRelationConfigurer.configure();
                continue;
            }
            if (mapRelation.getKeyEntityConfigurationProvider() != null) {
                keyEntityConfiguration = mapRelation.getKeyEntityConfigurationProvider().getConfiguration();
                keyEntityPersister = new PersisterBuilderImpl(keyEntityConfiguration).build(this.dialect, this.connectionConfiguration, null);
                EntityAsKeyMapRelationConfigurer entityAsKeyMapRelationConfigurer = new EntityAsKeyMapRelationConfigurer(mapRelation, this.sourcePersister, keyEntityPersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getEntryMapTableNamingStrategy(), this.dialect, this.connectionConfiguration);
                entityAsKeyMapRelationConfigurer.configure();
                continue;
            }
            if (mapRelation.getValueEntityConfigurationProvider() != null) {
                EntityMappingConfiguration valueEntityConfiguration = mapRelation.getValueEntityConfigurationProvider().getConfiguration();
                ConfiguredRelationalPersister valueEntityPersister = new PersisterBuilderImpl(valueEntityConfiguration).build(this.dialect, this.connectionConfiguration, null);
                ValueAsKeyMapRelationConfigurer valueAsKeyMapRelationConfigurer = new ValueAsKeyMapRelationConfigurer(mapRelation, this.sourcePersister, valueEntityPersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getEntryMapTableNamingStrategy(), this.dialect, this.connectionConfiguration);
                valueAsKeyMapRelationConfigurer.configure();
                continue;
            }
            MapRelationConfigurer mapRelationConfigurer = new MapRelationConfigurer(mapRelation, this.sourcePersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getEntryMapTableNamingStrategy(), this.dialect, this.connectionConfiguration);
            mapRelationConfigurer.configure();
        }
    }
}

