/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.ColumnedCollectionMapping;
import org.codefilarete.stalactite.mapping.ColumnedMapMapping;
import org.codefilarete.stalactite.mapping.EmbeddedBeanMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.PersistentFieldHarvester;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ClassMappingTest {
    private static Column colA;
    private static Column colB;
    private static Column colC;
    private static Column colD1;
    private static Column colD2;
    private static Column colE1;
    private static Column colE2;
    private static ClassMapping testInstance;

    ClassMappingTest() {
    }

    static <T extends Table<T>> void setUpInstance() {
        TestData testData = new TestData();
        colA = testData.colA;
        colB = testData.colB;
        colC = testData.colC;
        colD1 = testData.colD1;
        colD2 = testData.colD2;
        colE1 = testData.colE1;
        colE2 = testData.colE2;
        testInstance = testData.classMapping;
    }

    static Object[][] getInsertValues() {
        ClassMappingTest.setUpInstance();
        return new Object[][]{{new Toto(1, 2, 3), Maps.asMap((Object)colA, (Object)1).add((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto(null, null, null), Maps.asMap((Object)colA, null).add((Object)colB, null).add((Object)colC, null).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto(null, 2, 3), Maps.asMap((Object)colA, null).add((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto((Integer)1, (Integer)2, (Integer)3, Arrays.asList((Object[])new String[]{"a"})), Maps.asMap((Object)colA, (Object)1).add((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, (Object)"a").add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto((Integer)1, (Integer)2, (Integer)3, (Map<String, String>)Maps.asMap((Object)"x", (Object)"y")), Maps.asMap((Object)colA, (Object)1).add((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, (Object)"y").add((Object)colE2, null)}};
    }

    @ParameterizedTest
    @MethodSource(value={"getInsertValues"})
    void testGetInsertValues(Toto modified, Map<Column<?, Object>, Object> expectedResult) {
        Map valuesToInsert = testInstance.getInsertValues((Object)modified);
        Assertions.assertThat((Map)valuesToInsert).isEqualTo(expectedResult);
    }

    static Object[][] getUpdateValues_diffOnly() {
        ClassMappingTest.setUpInstance();
        return new Object[][]{{new Toto(1, 2, 3), new Toto(1, 5, 6), Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3)}, {new Toto(1, 2, 3), new Toto(1, null, null), Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3)}, {new Toto(1, 2, 3), new Toto(1, 2, 42), Maps.asMap((Object)colC, (Object)3)}, {new Toto(1, null, null), new Toto(1, 2, 3), Maps.asMap((Object)colB, null).add((Object)colC, null)}, {new Toto(1, 2, 3), new Toto(1, 2, 3), new HashMap()}, {new Toto(1, 2, 3), null, Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3)}, {new Toto((Integer)1, (Integer)2, (Integer)3, Arrays.asList((Object[])new String[]{"a"})), new Toto((Integer)1, (Integer)5, (Integer)6, Arrays.asList((Object[])new String[]{"b"})), Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, (Object)"a")}, {new Toto((Integer)1, (Integer)2, (Integer)3, (Map<String, String>)Maps.asMap((Object)"x", (Object)"y")), new Toto((Integer)1, (Integer)5, (Integer)6, (Map<String, String>)Maps.asMap((Object)"x", (Object)"z")), Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colE1, (Object)"y")}, {new Toto(1, 2, 3, Arrays.asList((Object[])new String[]{"a"}), (Map<String, String>)Maps.asMap((Object)"x", (Object)"y")), null, Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, (Object)"a").add((Object)colE1, (Object)"y")}, {new Toto(1, 2, 3), new Toto(10, 20, 30), new HashMap()}};
    }

    @ParameterizedTest
    @MethodSource(value={"getUpdateValues_diffOnly"})
    <T extends Table<T>> void getUpdateValues_diffOnly(Toto modified, Toto unmodified, Map<Column, Object> expectedResult) {
        Map valuesToUpdate = testInstance.getUpdateValues((Object)modified, (Object)unmodified, false);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getUpdateColumns((Map)valuesToUpdate)).isEqualTo(expectedResult);
        if (!expectedResult.isEmpty()) {
            Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToUpdate)).isEqualTo((Object)Maps.asMap((Object)colA, (Object)modified.a));
        } else {
            Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToUpdate)).isEqualTo(new HashMap());
        }
    }

    static Object[][] getUpdateValues_allColumns() {
        ClassMappingTest.setUpInstance();
        return new Object[][]{{new Toto(1, 2, 3), new Toto(1, 5, 6), Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto(1, 2, 3), new Toto(1, null, null), Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto(1, 2, 3), new Toto(1, 2, 42), Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto(1, null, null), new Toto(1, 2, 3), Maps.asMap((Object)colB, null).add((Object)colC, null).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto(1, 2, 3), new Toto(1, 2, 3), new HashMap()}, {new Toto(1, 2, 3), null, Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto((Integer)1, (Integer)2, (Integer)3, Arrays.asList((Object[])new String[]{"a"})), new Toto((Integer)1, (Integer)5, (Integer)6, Arrays.asList((Object[])new String[]{"b"})), Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, (Object)"a").add((Object)colD2, null).add((Object)colE1, null).add((Object)colE2, null)}, {new Toto((Integer)1, (Integer)2, (Integer)3, (Map<String, String>)Maps.asMap((Object)"x", (Object)"y")), new Toto((Integer)1, (Integer)5, (Integer)6, (Map<String, String>)Maps.asMap((Object)"x", (Object)"z")), Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, null).add((Object)colD2, null).add((Object)colE1, (Object)"y").add((Object)colE2, null)}, {new Toto(1, 2, 3, Arrays.asList((Object[])new String[]{"a"}), (Map<String, String>)Maps.asMap((Object)"x", (Object)"y")), null, Maps.asMap((Object)colB, (Object)2).add((Object)colC, (Object)3).add((Object)colD1, (Object)"a").add((Object)colD2, null).add((Object)colE1, (Object)"y").add((Object)colE2, null)}};
    }

    @ParameterizedTest
    @MethodSource(value={"getUpdateValues_allColumns"})
    <T extends Table<T>> void getUpdateValues_allColumns(Toto modified, Toto unmodified, Map<Column, Object> expectedResult) {
        Map valuesToUpdate = testInstance.getUpdateValues((Object)modified, (Object)unmodified, true);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getUpdateColumns((Map)valuesToUpdate)).isEqualTo(expectedResult);
        if (!expectedResult.isEmpty()) {
            Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToUpdate)).isEqualTo((Object)Maps.asMap((Object)colA, (Object)modified.a));
        } else {
            Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToUpdate)).isEqualTo(new HashMap());
        }
    }

    @Test
    <T extends Table<T>> void beanKeyIsPresent() {
        TestData testData = new TestData();
        PropertyAccessor identifierAccessor = Accessors.propertyAccessor((Field)testData.persistentFieldHarvester.getField("a"));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> new ClassMapping(Toto.class, testData.targetTable, (Map)Maps.asMap((Object)Accessors.propertyAccessor(Toto.class, (String)"b"), (Object)colB), (ReversibleAccessor)identifierAccessor, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Integer.class, c -> {}, c -> false))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Bean identifier 'o.c.s.m.ClassMappingTest$Toto.a' must have its matching column in the mapping");
    }

    private static class Toto {
        private Integer a;
        private Integer b;
        private Integer c;
        private List<String> myList;
        private Map<String, String> myMap;

        public Toto() {
        }

        public Toto(Integer a, Integer b, Integer c) {
            this(a, b, c, null, null);
        }

        public Toto(Integer a, Integer b, Integer c, List<String> myList) {
            this(a, b, c, myList, null);
        }

        public Toto(Integer a, Integer b, Integer c, Map<String, String> myMap) {
            this(a, b, c, null, myMap);
        }

        public Toto(Integer a, Integer b, Integer c, List<String> myList, Map<String, String> myMap) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.myList = myList;
            this.myMap = myMap;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"a", (Object)this.a).add((Object)"b", (Object)this.b).add((Object)"c", (Object)this.c).add((Object)"myList", this.myList).add((Object)"myMap", this.myMap) + "]";
        }
    }

    private static class TestData<T extends Table<T>> {
        private Column<T, ?> colA;
        private Column<T, ?> colB;
        private Column<T, ?> colC;
        private Column<T, ?> colD1;
        private Column<T, ?> colD2;
        private Column<T, ?> colE1;
        private Column<T, ?> colE2;
        private Map<? extends ReversibleAccessor<Toto, ?>, Column<T, ?>> propertyMapping;
        private T targetTable;
        private PersistentFieldHarvester persistentFieldHarvester = new PersistentFieldHarvester();
        private Map<String, Column<T, ?>> columnMapOnName;
        private PropertyAccessor<Toto, List<String>> myListField;
        private PropertyAccessor<Toto, Map<String, String>> myMapField;
        private ClassMapping<Toto, Integer, ?> classMapping;

        private TestData() {
            this.targetTable = new Table("Toto");
            this.propertyMapping = this.persistentFieldHarvester.mapFields(Toto.class, this.targetTable);
            this.columnMapOnName = this.targetTable.mapColumnsOnName();
            this.colA = this.columnMapOnName.get("a");
            this.colA.setPrimaryKey(true);
            this.colB = this.columnMapOnName.get("b");
            this.colC = this.columnMapOnName.get("c");
            this.myListField = Accessors.propertyAccessor((Field)Reflections.findField(Toto.class, (String)"myList"));
            this.propertyMapping.remove(this.myListField);
            this.myMapField = Accessors.propertyAccessor((Field)Reflections.findField(Toto.class, (String)"myMap"));
            this.propertyMapping.remove(this.myMapField);
            this.classMapping = new ClassMapping(Toto.class, this.targetTable, this.propertyMapping, (ReversibleAccessor)Accessors.propertyAccessor((Field)this.persistentFieldHarvester.getField("a")), (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Integer.class, c -> {}, c -> false));
            int nbCol = 2;
            LinkedHashSet<Column> collectionColumn = new LinkedHashSet<Column>(nbCol);
            for (int i = 1; i <= nbCol; ++i) {
                String columnName = "cold_" + i;
                collectionColumn.add(this.targetTable.addColumn(columnName, String.class));
            }
            ColumnedCollectionMapping columnedCollectionMapping = new ColumnedCollectionMapping<List<String>, String, T>((Table)this.targetTable, collectionColumn, ArrayList.class){

                protected String toCollectionValue(Object object) {
                    return object.toString();
                }
            };
            this.classMapping.put(this.myListField, (EmbeddedBeanMapping)columnedCollectionMapping);
            final HashMap<String, Column> mappedColumnsByKey = new HashMap<String, Column>();
            block5: for (int i = 1; i <= 2; ++i) {
                String columnName = "cole_" + i;
                Column column = this.targetTable.addColumn(columnName, String.class);
                switch (i) {
                    case 1: {
                        mappedColumnsByKey.put("x", column);
                        continue block5;
                    }
                    case 2: {
                        mappedColumnsByKey.put("y", column);
                    }
                }
            }
            ColumnedMapMapping columnedMapMapping = new ColumnedMapMapping<Map<String, String>, String, String, T>((Table)this.targetTable, new HashSet(mappedColumnsByKey.values()), HashMap.class){

                protected Column<T, ?> getColumn(String key) {
                    Column column = (Column)mappedColumnsByKey.get(key);
                    if (column == null) {
                        throw new IllegalArgumentException("Unknown key " + key);
                    }
                    return column;
                }

                protected String getKey(Column column) {
                    return null;
                }

                protected String toDatabaseValue(String key, String s) {
                    return s;
                }

                protected String toMapValue(String key, Object o) {
                    return o.toString();
                }
            };
            this.classMapping.put(this.myMapField, (EmbeddedBeanMapping)columnedMapMapping);
            this.columnMapOnName = this.targetTable.mapColumnsOnName();
            this.colD1 = this.columnMapOnName.get("cold_1");
            this.colD2 = this.columnMapOnName.get("cold_2");
            this.colE1 = this.columnMapOnName.get("cole_1");
            this.colE2 = this.columnMapOnName.get("cole_2");
        }
    }
}

