/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.test.DatabaseIntegrationTest;
import org.codefilarete.tool.Duo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class SQLOperationITTest
extends DatabaseIntegrationTest {
    protected BiFunction<PreparedSQL, ConnectionProvider, ReadOperation<Integer>> readOperationFactory;

    SQLOperationITTest() {
    }

    abstract String giveLockStatement();

    protected String giveCreateTableStatement() {
        return "create table Toto(id bigint)";
    }

    abstract Predicate<Throwable> giveCancelOperationPredicate();

    @Override
    protected void setConnectionProvider() {
        DataSource dataSource = this.giveDataSource();
        this.connectionProvider = new CurrentThreadConnectionProvider(dataSource);
        this.clearDatabaseSchema();
    }

    @AfterEach
    protected void cleanThreadAttachment() {
        try {
            this.connectionProvider.giveConnection().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @BeforeEach
    protected void createReadOperationFactory() {
        this.readOperationFactory = ReadOperation::new;
    }

    @Test
    void cancel() throws SQLException, InterruptedException {
        try (Connection lockingConnection = this.connectionProvider.giveConnection();){
            lockingConnection.setAutoCommit(false);
            lockingConnection.prepareStatement(this.giveCreateTableStatement()).execute();
            lockingConnection.commit();
            this.lockTable(lockingConnection);
            CountDownLatch threadStartedMarker = new CountDownLatch(1);
            AtomicBoolean isSelectExecuted = new AtomicBoolean(false);
            Duo<Runnable, SQLOperation> testInstance = this.createLockingStatement();
            Throwable[] capturedException = new Throwable[1];
            Thread selectCommandThread = new Thread(() -> {
                try (SQLOperation localTestInstance = (SQLOperation)testInstance.getRight();){
                    threadStartedMarker.countDown();
                    ((Runnable)testInstance.getLeft()).run();
                    isSelectExecuted.set(true);
                }
                catch (Throwable t) {
                    capturedException[0] = t;
                }
                finally {
                    ((CurrentThreadConnectionProvider)this.connectionProvider).releaseConnection();
                }
            });
            selectCommandThread.start();
            threadStartedMarker.await(1L, TimeUnit.SECONDS);
            selectCommandThread.join(200L);
            Assertions.assertThat((boolean)isSelectExecuted.get()).isFalse();
            ((SQLOperation)testInstance.getRight()).cancel();
            selectCommandThread.join(200L);
            Assertions.assertThat((boolean)isSelectExecuted.get()).isFalse();
            selectCommandThread.join(200L);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.giveCancelOperationPredicate().test(capturedException[0])).withThreadDumpOnError()).isTrue();
            lockingConnection.rollback();
            ((CurrentThreadConnectionProvider)this.connectionProvider).releaseConnection();
        }
    }

    protected Duo<Runnable, SQLOperation> createLockingStatement() {
        ReadOperation<Integer> testInstance = this.readOperationFactory.apply(new PreparedSQL("select * from Toto", new HashMap()), this.connectionProvider);
        return new Duo(() -> testInstance.execute(), testInstance);
    }

    protected void lockTable(Connection lockingConnection) throws SQLException {
        lockingConnection.prepareStatement(this.giveLockStatement()).execute();
    }
}

