/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;

public class SQLParameterParser {
    public static final Pattern IN_PATTERN = Pattern.compile("\\s+in\\s*\\(\\s*");
    private static final Set<Character> PARAMETER_NAME_ALLOWED_CHARACTERS = Collections.unmodifiableSet(Arrays.asHashSet((Object[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('_'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')}));
    private static final char SIMPLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SEMI_COLON = ':';
    private static final Set<Character> SPECIAL_SYMBOLS = Collections.unmodifiableSet(Arrays.asHashSet((Object[])new Character[]{Character.valueOf(':'), Character.valueOf('\''), Character.valueOf('\"')}));
    private static final Set<Character> TEXT_MARKS = Collections.unmodifiableSet(Arrays.asHashSet((Object[])new Character[]{Character.valueOf('\''), Character.valueOf('\"')}));
    private final ParsedSQL parsedSQL;
    private final int sqlLength;
    private final String sql;
    private int currentPos;
    private char currentChar;
    private StringBuilder sqlSnippet;

    public SQLParameterParser(String sql) {
        this.sql = sql;
        this.sqlLength = sql.length();
        this.currentPos = -1;
        this.parsedSQL = new ParsedSQL();
    }

    public String getSql() {
        return this.sql;
    }

    public ParsedSQL parse() {
        this.sqlSnippet = new StringBuilder(50);
        while (this.currentPos < this.sqlLength) {
            this.doUntil(SPECIAL_SYMBOLS, new ParsingListener(){

                @Override
                public void onRead() {
                    SQLParameterParser.this.sqlSnippet.append(SQLParameterParser.this.currentChar);
                }

                @Override
                public void onConsumptionEnd() {
                    SQLParameterParser.this.parsedSQL.addSqlSnippet(SQLParameterParser.this.sqlSnippet.toString());
                    switch (SQLParameterParser.this.currentChar) {
                        case '\"': 
                        case '\'': {
                            SQLParameterParser.this.readQuotes();
                            break;
                        }
                        case ':': {
                            SQLParameterParser.this.readParam();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Symbol '" + SQLParameterParser.this.currentChar + "' was set as blocker but its consumption is not implemented");
                        }
                    }
                    SQLParameterParser.this.sqlSnippet.setLength(0);
                }
            });
            if (this.currentPos != this.sqlLength || this.sqlSnippet.length() == 0) continue;
            this.parsedSQL.addSqlSnippet(this.sqlSnippet.toString());
        }
        return this.parsedSQL;
    }

    private void readParam() {
        final StringBuilder paramName = new StringBuilder();
        this.doWhile(PARAMETER_NAME_ALLOWED_CHARACTERS, new ParsingListener(){

            @Override
            public void onRead() {
                paramName.append(SQLParameterParser.this.currentChar);
            }

            @Override
            public void onConsumptionEnd() {
                Matcher inMatcher = IN_PATTERN.matcher(SQLParameterParser.this.sqlSnippet.toString());
                if (inMatcher.find()) {
                    SQLParameterParser.this.parsedSQL.addCollectionParam(paramName.toString());
                } else {
                    SQLParameterParser.this.parsedSQL.addParam(paramName.toString());
                }
                SQLParameterParser.this.unread();
            }
        });
        if (this.currentPos == this.sqlLength) {
            if (paramName.length() == 0) {
                throw new IllegalArgumentException("Parameter name can't be empty at position " + this.currentPos);
            }
            this.parsedSQL.addParam(paramName.toString());
        }
    }

    private void readQuotes() {
        final StringBuilder quotes = new StringBuilder();
        char prefix = this.currentChar;
        this.doUntil(TEXT_MARKS, new ParsingListener(){

            @Override
            public void onRead() {
                quotes.append(SQLParameterParser.this.currentChar);
            }

            @Override
            public void onConsumptionEnd() {
            }
        });
        this.parsedSQL.addSqlSnippet(prefix + quotes.toString() + prefix);
    }

    private void doUntil(Set<Character> stoppingChars, ParsingListener parsingListener) {
        boolean charFound = true;
        while (charFound && this.read()) {
            charFound = !stoppingChars.contains(Character.valueOf(this.currentChar));
            if (!charFound) continue;
            parsingListener.onRead();
        }
        if (!charFound) {
            parsingListener.onConsumptionEnd();
        }
    }

    private void doWhile(Set<Character> continuingChars, ParsingListener parsingListener) {
        boolean charFound = true;
        while (charFound && this.read()) {
            charFound = continuingChars.contains(Character.valueOf(this.currentChar));
            if (!charFound) continue;
            parsingListener.onRead();
        }
        if (!charFound) {
            parsingListener.onConsumptionEnd();
        }
    }

    private boolean read() {
        if (++this.currentPos < this.sqlLength) {
            this.currentChar = this.sql.charAt(this.currentPos);
            return true;
        }
        return false;
    }

    private void unread() {
        if (--this.currentPos >= 0) {
            this.currentChar = this.sql.charAt(this.currentPos);
        }
    }

    public static class CollectionParameter
    extends Parameter {
        public CollectionParameter(String name) {
            super(name);
        }
    }

    public static class Parameter {
        private final String name;

        public Parameter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return Objects.equals(this.name, parameter.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class ParsedSQL {
        private List<Object> sqlSnippets = new ArrayList<Object>(10);
        private Map<String, Parameter> parametersMap = new HashMap<String, Parameter>();

        public ParsedSQL() {
        }

        public ParsedSQL(List<Object> sqlSnippets, Map<String, Parameter> parametersMap) {
            this.sqlSnippets = sqlSnippets;
            this.parametersMap = parametersMap;
        }

        public List<Object> getSqlSnippets() {
            return this.sqlSnippets;
        }

        public Map<String, Parameter> getParametersMap() {
            return this.parametersMap;
        }

        public void addParam(String paramName) {
            Parameter parameter = this.parametersMap.computeIfAbsent(paramName, Parameter::new);
            this.sqlSnippets.add(parameter);
        }

        public void addCollectionParam(String paramName) {
            Parameter parameter = this.parametersMap.computeIfAbsent(paramName, Parameter::new);
            if (!(parameter instanceof CollectionParameter)) {
                parameter = new CollectionParameter(paramName);
                this.parametersMap.put(paramName, parameter);
            }
            this.sqlSnippets.add(parameter);
        }

        public void addSqlSnippet(CharSequence sqlSnippet) {
            this.sqlSnippets.add(sqlSnippet);
        }

        public String toString() {
            return new StringAppender(){

                public StringAppender cat(Object s) {
                    if (s instanceof Parameter) {
                        super.cat((Object)":");
                        super.cat((Object)((Parameter)s).getName());
                    } else {
                        super.cat(s);
                    }
                    return this;
                }
            }.cat(this.getSqlSnippets()).toString();
        }
    }

    private static interface ParsingListener {
        public void onRead();

        public void onConsumptionEnd();
    }
}

